/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.formula.kscript.debug.ui;

import com.kingdee.bos.formula.kscript.debug.ui.DebugUI;
import com.kingdee.bos.formula.kscript.debug.ui.SourcePage;
import com.kingdee.bos.formula.kscript.debug.ui.SourcePanel;
import com.kingdee.bos.formula.kscript.debug.ui.StackPanel;
import com.kingdee.bos.formula.kscript.debug.ui.WatchPanel;
import com.kingdee.bos.kscript.debug.IDebugContext;
import com.kingdee.bos.kscript.parser.Position;
import com.kingdee.bos.kscript.parser.Source;
import java.awt.Component;
import javax.swing.JSplitPane;
import org.apache.log4j.Logger;

public class DebugPanel {
    static final Logger logger = Logger.getLogger(DebugPanel.class);
    public DebugUI uiMain;
    public IDebugContext debug = null;
    public SourcePanel sourcePanel;
    public WatchPanel watchPanel;
    public StackPanel stackPanel;
    public Component component;

    public DebugPanel(DebugUI uiMain) {
        this.uiMain = uiMain;
        this.sourcePanel = new SourcePanel(this);
        this.watchPanel = new WatchPanel(this);
        this.stackPanel = new StackPanel(this);
        JSplitPane p1 = new JSplitPane(0, this.stackPanel.getComponent(), this.watchPanel.getComponent());
        p1.setResizeWeight(0.35);
        JSplitPane p2 = new JSplitPane(1, this.sourcePanel.getComponent(), p1);
        p2.setResizeWeight(0.7);
        this.component = p2;
    }

    public Component getComponent() {
        return this.component;
    }

    public void actionPerformed(int action) {
        try {
            if (this.isActionEnabled(action)) {
                switch (action) {
                    case 128: {
                        if (this.sourcePanel.getActivedPage() == null) break;
                        this.uiMain.debugScript(this.sourcePanel.getActivedPage().getSource(), null);
                        break;
                    }
                    case 8: {
                        if (this.debug == null) break;
                        this.debug.resume();
                        break;
                    }
                    case 4: {
                        this.debug.stepOut();
                        break;
                    }
                    case 1: {
                        this.debug.stepOver();
                        break;
                    }
                    case 2: {
                        this.debug.stepInto();
                        break;
                    }
                    case 64: {
                        this.dropToFrame();
                        break;
                    }
                    case 16: {
                        this.debug.pause();
                        break;
                    }
                    case 32: {
                        if (this.debug.getState() == 1) {
                            this.uiMain.removeDebug(this.debug);
                            break;
                        }
                        this.debug.stop();
                        break;
                    }
                    case 512: {
                        this.debug.stopDebug();
                        this.uiMain.removeDebug(this.debug);
                        break;
                    }
                    case 256: {
                        this.sourcePanel.closeActivedPage();
                    }
                }
            }
        }
        catch (Exception ex) {
            this.uiMain.handleException(ex);
        }
    }

    private String sourceName() {
        Source source = this.debug.getCurrentSource();
        if (source == null) {
            return null;
        }
        return source.getName();
    }

    public String getStatusText() {
        if (this.debug == null) {
            return "Ready";
        }
        switch (this.debug.getState()) {
            case 1: {
                return "Error occured in " + this.sourceName();
            }
            case 4: {
                return "Script is paused in " + this.sourceName();
            }
            case 2: {
                return "Script is running in " + this.sourceName();
            }
            case 8: {
                return "Script is running stoped";
            }
        }
        return "Ready";
    }

    public boolean isSourceLoaded(IDebugContext debug) {
        if (debug == null) {
            return false;
        }
        Source s = debug.getCurrentSource();
        if (s == null) {
            return false;
        }
        return this.sourcePanel.getSourcePage(s) != null;
    }

    public boolean isActionEnabled(int action) {
        if (action == 128) {
            return this.sourcePanel.getActivedPage() != null;
        }
        if (action == 256) {
            SourcePage page = this.sourcePanel.getActivedPage();
            if (page == null) {
                return false;
            }
            if (this.debug == null) {
                return true;
            }
            Source s = this.debug.getCurrentSource();
            return s == null || !page.getSource().equals((Object)s);
        }
        if (this.debug == null) {
            return false;
        }
        int state = this.debug.getState();
        switch (action) {
            case 8: {
                return state == 4 && this.isSourceLoaded(this.debug);
            }
            case 1: 
            case 2: 
            case 4: {
                return state == 4 && this.isSourceLoaded(this.debug);
            }
            case 64: {
                if ((state == 4 || state == 1) && this.isSourceLoaded(this.debug)) {
                    Position pos = this.debug.getCurrentPosition();
                    return pos.isValidPosition();
                }
                return false;
            }
            case 16: {
                return state == 2 && this.isSourceLoaded(this.debug);
            }
            case 32: 
            case 512: {
                return state != 8;
            }
        }
        return false;
    }

    public void setDebugContext(IDebugContext debug) {
        int state;
        if (debug != null && (state = debug.getState()) == 8) {
            debug = null;
        }
        this.debug = debug;
        this.sourcePanel.notifyChanged();
        this.dropToFrame();
        this.stackPanel.notifyChanged();
        this.watchPanel.notifyChanged(false);
    }

    public void dropToFrame() {
        if (!this.isPausedState()) {
            return;
        }
        Position pos = this.debug.getCurrentPosition();
        if (pos == null || !pos.isValidPosition()) {
            this.uiMain.setSubTitle("");
        } else {
            this.sourcePanel.dropToPosition(pos);
            this.stackPanel.selectPosition(pos);
        }
    }

    public boolean isPausedState() {
        try {
            if (this.debug == null) {
                return false;
            }
            int state = this.debug.getState();
            return state == 4 || state == 1;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

