/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.formula.kscript.debug.ui;

import com.kingdee.bos.formula.kscript.debug.ui.DebugManager;
import com.kingdee.bos.formula.kscript.debug.ui.DebugPanel;
import com.kingdee.bos.formula.kscript.debug.ui.DebugUI;
import com.kingdee.bos.formula.kscript.debug.ui.SourcePage;
import com.kingdee.bos.formula.kscript.debug.ui.ValueTree;
import com.kingdee.bos.kscript.debug.IDebugContext;
import com.kingdee.bos.kscript.debug.IValue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class ValueTable
extends JScrollPane {
    public final DefaultTableModel model = new DefaultTableModel();
    public JTable table;
    public DebugPanel debugPanel;
    private String lastKey;
    private ValueTree lastTree;
    public ValueTree tree;

    public ValueTable(DebugPanel debugPanel) {
        this.model.addColumn("name");
        this.model.addColumn("type");
        this.model.addColumn("value");
        this.table = new JTable(this.model){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    ValueTable.this.expandTable();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 3) {
                    ValueTable.this.valueActions(e);
                }
            }
        });
        this.lastKey = null;
        this.lastTree = null;
        this.tree = null;
        this.debugPanel = debugPanel;
        this.setViewportView(this.table);
    }

    static boolean equals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public void notifyChanged(boolean forceRefresh) {
        try {
            IDebugContext debug = this.debugPanel.debug;
            IValue ref = null;
            if (debug != null && (debug.getState() == 4 || debug.getState() == 1)) {
                ref = debug.getContext();
            }
            if (ref == null) {
                this.setValue(null, true);
                return;
            }
            String key = DebugManager.getDebugRuntimeName(debug) + "." + debug.getKey() + "." + debug.getStepTickCount();
            if (!forceRefresh && ValueTable.equals(this.lastKey, key)) {
                this.setValue(this.lastTree, false);
                return;
            }
            this.lastKey = key;
            this.lastTree = new ValueTree(null);
            this.lastTree.source = debug.getCurrentSource();
            this.lastTree.setValue("contexts", 0, ref, true);
            this.setValue(this.lastTree, true);
        }
        catch (Exception ex) {
            this.debugPanel.uiMain.handleDebugContextException(ex);
        }
    }

    public ValueTree getSelectedValue() {
        ValueTree v;
        int index = this.table.getSelectedRow();
        if (index >= 0 && index < this.model.getRowCount() && (v = (ValueTree)this.model.getValueAt(index, 0)) != null) {
            v.setSelected();
            return v;
        }
        return null;
    }

    private void expandTable() {
        ValueTree v = this.getSelectedValue();
        if (v != null && v.expandOrNot()) {
            this.setValue(this.tree, false);
        }
    }

    public void setValue(ValueTree tree, boolean forceRefresh) {
        try {
            ValueTree lastTree = this.tree;
            this.tree = tree;
            if (tree == null) {
                this.model.setRowCount(0);
                return;
            }
            if (!forceRefresh) {
                boolean bl = forceRefresh = tree != lastTree;
            }
            if (!forceRefresh) {
                boolean bl = forceRefresh = this.model.getRowCount() != tree.getAllChildCount();
            }
            if (!forceRefresh) {
                return;
            }
            ValueTree[] values = tree.listAll(false);
            if (values.length != this.model.getRowCount()) {
                this.model.setRowCount(values.length);
            }
            for (int i = 0; i < values.length; ++i) {
                ValueTree v = values[i];
                this.model.setValueAt(v, i, 0);
                this.model.setValueAt(v.typeName, i, 1);
                String val = v.value;
                val = String.valueOf(val);
                this.model.setValueAt(val, i, 2);
                if (!v.isSelected()) continue;
                this.table.getSelectionModel().setSelectionInterval(i, i);
            }
        }
        catch (Exception ex) {
            this.debugPanel.uiMain.handleException(ex);
        }
    }

    private void valueActions(MouseEvent e) {
        final ValueTree v = this.getSelectedValue();
        if (v == null) {
            return;
        }
        String var = v.getVarScript();
        if (var == null) {
            return;
        }
        JPopupMenu menu = new JPopupMenu("Actions");
        ActionListener l = new ActionListener(){
            ValueTree item;
            {
                this.item = v;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ValueTable.this.valueAction(this.item, e);
            }
        };
        menu.add("changeValue").addActionListener(l);
        if (v.isTypeOf(Collection.class) || v.isTypeOf(Map.class)) {
            menu.add("clear").addActionListener(l);
        }
        if (v.parent.parent != null && (v.parent.isTypeOf(Map.class) || v.parent.isTypeOf(List.class))) {
            menu.add("remove").addActionListener(l);
        }
        if (v.isTypeOf(Throwable.class)) {
            menu.add("printStackTrace").addActionListener(l);
        }
        menu.add("Refresh").addActionListener(l);
        menu.show(this.table, e.getX(), e.getY());
    }

    private void valueAction(ValueTree v, ActionEvent e) {
        try {
            boolean r = false;
            if (e.getActionCommand().equals("changeValue")) {
                r = this.actionChangeValue(v);
            } else if (e.getActionCommand().equals("clear")) {
                r = this.actionClear(v);
            } else if (e.getActionCommand().equals("remove")) {
                r = this.actionRemove(v);
            } else if (e.getActionCommand().equals("printStackTrace")) {
                r = this.actionPrintStackTrace(v);
            } else if (e.getActionCommand().equals("Refresh")) {
                r = true;
            }
            if (r) {
                this.notifyChanged(true);
            }
        }
        catch (Exception ex) {
            this.debugPanel.uiMain.handleException(ex);
        }
    }

    private boolean actionChangeValue(ValueTree v) throws Exception {
        IDebugContext debug = this.debugPanel.debug;
        if (debug == null) {
            return false;
        }
        String var = v.getVarScript();
        if (var == null) {
            return false;
        }
        String expr = DebugUI.props.inputText("changeValue." + var, v.getFullName());
        if (expr == null) {
            return false;
        }
        if ((expr = v.getAssignScript(expr)) == null) {
            return false;
        }
        expr = expr + ";";
        debug.evalNoDebug(expr);
        return true;
    }

    private boolean actionClear(ValueTree v) throws Exception {
        IDebugContext debug = this.debugPanel.debug;
        if (debug == null) {
            return false;
        }
        String var = v.getVarScript();
        if (var == null) {
            return false;
        }
        String expr = var + ".clear();";
        debug.evalNoDebug(expr);
        v.childCount = 0;
        v.children = null;
        return true;
    }

    private boolean actionRemove(ValueTree v) throws Exception {
        if (v.parent.parent == null) {
            return false;
        }
        IDebugContext debug = this.debugPanel.debug;
        if (debug == null) {
            return false;
        }
        String var = v.parent.getVarScript();
        if (var == null) {
            return false;
        }
        String expr = v.name == null ? var + ".remove(" + v.index + ");" : var + ".remove(\"" + v.name + "\");";
        debug.evalNoDebug(expr);
        v.parent.setSelected();
        return true;
    }

    private boolean actionPrintStackTrace(ValueTree v) throws Exception {
        if (!v.isTypeOf(Throwable.class)) {
            return false;
        }
        String text = v.ref.getStackTrace();
        SourcePage page = this.debugPanel.sourcePanel.activePage(v.getSource());
        IDebugContext debug = this.debugPanel.debug;
        if (page == null || debug == null) {
            this.debugPanel.uiMain.alert(v.typeName, text, true);
        } else {
            page.console.output(debug, text, 1);
        }
        return false;
    }
}

