/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.formula.builder.highlight;

import com.kingdee.bos.ctrl.swing.KDTextPane;
import com.kingdee.bos.service.formula.builder.FormulaBuilderPanelBean;
import com.kingdee.bos.service.formula.builder.highlight.HighlightStringTokenizer;
import com.kingdee.bos.service.formula.engine.KeyWordTransformer;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.rtf.RTFEditorKit;

public class ExtendKDTextPane
extends KDTextPane {
    protected StyleContext m_context;
    protected DefaultStyledDocument m_doc;
    private MutableAttributeSet keyAttr;
    private MutableAttributeSet normalAttr;
    private MutableAttributeSet inputAttributes = new RTFEditorKit().getInputAttributes();
    private String[] keyWord = KeyWordTransformer.getKeyWords();
    private static final String COMMENT_END_IGNORE_TURNLINE = "--comments end";

    public ExtendKDTextPane() {
        this.m_context = new StyleContext();
        this.m_doc = new DefaultStyledDocument(this.m_context);
        this.setDocument(this.m_doc);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent ke) {
                ExtendKDTextPane.this.syntaxParse();
            }
        });
        this.keyAttr = new SimpleAttributeSet();
        StyleConstants.setForeground(this.keyAttr, Color.blue);
        this.normalAttr = new SimpleAttributeSet();
        StyleConstants.setForeground(this.normalAttr, Color.black);
    }

    public void syntaxParse() {
        try {
            String s = null;
            Element root = this.m_doc.getDefaultRootElement();
            int cursorPos = this.getCaretPosition();
            int line = root.getElementIndex(cursorPos);
            Element para = root.getElement(line);
            int start = para.getStartOffset();
            int end = para.getEndOffset() - 1;
            s = this.m_doc.getText(start, end - start);
            int i = 0;
            int xStart = 0;
            this.m_doc.setCharacterAttributes(start, s.length(), this.normalAttr, false);
            HighlightStringTokenizer st = new HighlightStringTokenizer(s);
            while (st.hasMoreTokens()) {
                s = st.nextToken();
                if (s == null) {
                    return;
                }
                for (i = 0; i < this.keyWord.length && !s.equals(this.keyWord[i]); ++i) {
                }
                if (i >= this.keyWord.length) continue;
                xStart = st.getCurrPosition();
                this.m_doc.setCharacterAttributes(start + xStart, s.length(), this.keyAttr, false);
            }
            HighlightStringTokenizer est = new HighlightStringTokenizer(s);
            while (est.hasMoreTokens()) {
                s = est.nextToken();
                if (s == null) {
                    return;
                }
                for (i = 0; i < this.keyWord.length && !s.equals(this.keyWord[i]); ++i) {
                }
                if (i >= this.keyWord.length) continue;
                xStart = est.getCurrPosition();
                this.m_doc.setCharacterAttributes(start + xStart, s.length(), this.keyAttr, false);
            }
            this.inputAttributes.addAttributes(this.normalAttr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void cut() {
        if (this.isEditable() && this.isEnabled()) {
            String formulaStr = FormulaBuilderPanelBean.This.getFormulaStr();
            StringSelection tra = new StringSelection(formulaStr);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(tra, null);
            FormulaBuilderPanelBean.This.clear();
        }
    }

    public void copy() {
        String formulaStr = FormulaBuilderPanelBean.This.getFormulaStr();
        StringSelection tra = new StringSelection(formulaStr);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(tra, null);
    }

    public void paste() {
        if (this.isEditable() && this.isEnabled()) {
            String ss = null;
            Transferable clipT = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            if (clipT != null && clipT.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    ss = (String)clipT.getTransferData(DataFlavor.stringFlavor);
                    if (ss.indexOf(COMMENT_END_IGNORE_TURNLINE) != -1) {
                        int begin = ss.indexOf(COMMENT_END_IGNORE_TURNLINE);
                        ss = ss.substring(begin + COMMENT_END_IGNORE_TURNLINE.length() + 2);
                    }
                }
                catch (UnsupportedFlavorException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            FormulaBuilderPanelBean.This.clear();
            FormulaBuilderPanelBean.This.setFormulaStr(StringUtils.cnulls(ss));
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("test text pane");
        frame.getContentPane().add((Component)((Object)new ExtendKDTextPane()));
        WindowAdapter wndCloser = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        };
        frame.addWindowListener(wndCloser);
        int inset = 50;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setBounds(50, 50, screenSize.width - 100, screenSize.height - 100);
        frame.show();
    }
}

