/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.formula.engine;

import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.parser.Lexer;
import com.kingdee.bos.kscript.parser.Token;
import com.kingdee.bos.kscript.parser.TokenList;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.TypeReference;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.service.formula.api.BuilderResourceUtil;
import com.kingdee.bos.service.formula.api.IVarInfo;
import com.kingdee.bos.service.formula.engine.AliasTransformer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class BOSObjectRetransformerHelper {
    public static String TYPE_VARINFO = "varinfo";
    public static String TYPE_PROPERTY = "property";
    public static String TYPE_METHOD = "method";
    public static String TYPE_OTHER = "other";
    public static String TYPE_CONSTANT = "constant";
    private HashMap boMap;
    private TokenList tokenlist;
    private Vector varList;
    private List analyseList = new ArrayList();
    private static String[] chineseKeywords = new String[]{BuilderResourceUtil.getString("GetStringUnicode_Shi"), BuilderResourceUtil.getString("GetStringUnicode_RuGuo"), BuilderResourceUtil.getString("GetStringUnicode_FouZe"), BuilderResourceUtil.getString("GetStringUnicode_FouZeRuGuo"), BuilderResourceUtil.getString("GetStringUnicode_Qie"), BuilderResourceUtil.getString("GetStringUnicode_Huo"), BuilderResourceUtil.getString("GetStringUnicode_BuShi"), BuilderResourceUtil.getString("GetStringUnicode_DaYu"), BuilderResourceUtil.getString("GetStringUnicode_DaYuDengYu"), BuilderResourceUtil.getString("GetStringUnicode_DengYu"), BuilderResourceUtil.getString("GetStringUnicode_XiaoYu"), BuilderResourceUtil.getString("GetStringUnicode_XiaoYuDengYu"), BuilderResourceUtil.getString("GetStringUnicode_BuDengYu")};

    public BOSObjectRetransformerHelper(HashMap bos, Vector vars, TokenList tokens) {
        this.boMap = bos;
        this.varList = vars;
        this.tokenlist = tokens;
        try {
            this.analyse();
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
    }

    private void analyse() throws ParserException {
        Token token;
        if (this.tokenlist == null) {
            return;
        }
        this.analyseList.clear();
        int index = 0;
        while ((token = this.tokenlist.lookup(index)) != null && token.type != 12) {
            if (this.isVarinfo(token)) {
                this.analyseList.add(TYPE_VARINFO);
            } else if (this.isProperty(index)) {
                this.analyseList.add(TYPE_PROPERTY);
            } else if (this.isMethod(index)) {
                this.analyseList.add(TYPE_METHOD);
            } else if (this.isConstant(index)) {
                this.analyseList.add(TYPE_CONSTANT);
            } else {
                this.analyseList.add(TYPE_OTHER);
            }
            ++index;
        }
    }

    private boolean isVarinfo(Token token) {
        if (this.varList != null && token != null) {
            for (IVarInfo varinfo : this.varList) {
                String name = varinfo.getVarName();
                if (!name.equals(token.value)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isProperty(int index) throws ParserException {
        if (this.tokenlist != null && index > 0) {
            Token self = this.tokenlist.lookup(index);
            if (self != null && self.type != 1) {
                return false;
            }
            Token token = this.tokenlist.lookup(index + 1);
            if (token == null || token.type == 12 || Token.PeriodToken.equals(token) || 4 == token.type || token.value.equals(";") || 5 == token.type && !Token.OpenBraceToken.equals(token)) {
                return true;
            }
        }
        return false;
    }

    private boolean isMethod(int index) throws ParserException {
        if (this.tokenlist != null && index > 0) {
            Token self = this.tokenlist.lookup(index);
            Token token = this.tokenlist.lookup(index + 1);
            Token bToken = this.tokenlist.lookup(index - 1);
            if (1 == self.type && 5 == token.type && Token.OpenBraceToken.equals(token) && bToken.value != null && bToken.value.equals(".")) {
                return true;
            }
        }
        return false;
    }

    private boolean isConstant(int index) throws ParserException {
        if (index < 1) {
            return false;
        }
        Token token = this.tokenlist.lookup(index);
        return 6 == token.type;
    }

    private BusinessObjectInfo getPropertyOrMethodBO(int index) throws ParserException {
        block10: {
            String type;
            block11: {
                Token beforToken;
                block9: {
                    if (index < 2) {
                        return null;
                    }
                    beforToken = this.tokenlist.lookup(index - 2);
                    type = (String)this.analyseList.get(index - 2);
                    while (!TYPE_VARINFO.equals(type) && !TYPE_PROPERTY.equals(type) && TYPE_METHOD.equals(type) && --index >= 0) {
                        beforToken = this.tokenlist.lookup(index);
                        type = (String)this.analyseList.get(index);
                    }
                    if (!TYPE_VARINFO.equals(type)) break block9;
                    IVarInfo var = this.getVarinfoByName(beforToken.value);
                    String voFullName = var.getVarType();
                    boolean isMethod = this.isMethod(index);
                    for (BusinessObjectInfo entity : this.boMap.values()) {
                        if (entity instanceof EntityObjectInfo) {
                            EntityObjectInfo temp = (EntityObjectInfo)entity;
                            if (isMethod && temp.getBusinessInterface().equals(voFullName)) {
                                return entity;
                            }
                            if (!temp.getObjectValueClass().equals(voFullName)) continue;
                            return entity;
                        }
                        if (!(entity instanceof FacadeInfo) || !entity.getBusinessInterface().equals(voFullName)) continue;
                        return entity;
                    }
                    break block10;
                }
                if (!TYPE_PROPERTY.equals(type)) break block11;
                BusinessObjectInfo pBO = this.getPropertyOrMethodBO(index - 2);
                if (!(pBO instanceof EntityObjectInfo)) break block10;
                EntityObjectInfo pentity = (EntityObjectInfo)pBO;
                PropertyCollection pc = pentity.getInheritedNoDuplicatedProperties();
                int j = pc.size();
                for (int i = 0; i < j; ++i) {
                    PropertyInfo pro = pc.get(i);
                    if (!(pro instanceof LinkPropertyInfo) || pro.getName() == null || !pro.getName().equals(beforToken.value)) continue;
                    RelationshipInfo re = ((LinkPropertyInfo)pro).getRelationship();
                    if (re.isReverseLink(pentity)) {
                        return re.getClientObject();
                    }
                    return re.getSupplierObject();
                }
                break block10;
            }
            if (TYPE_METHOD.equals(type)) {
                Token beforeMethodToken = this.tokenlist.lookup(index);
                BusinessObjectInfo pBO = this.getPropertyOrMethodBO(index - 2);
                MethodCollection mc = pBO.getAllMethods();
                int j = mc.size();
                for (int i = 0; i < j; ++i) {
                    MethodInfo method = mc.get(i);
                    if (method.getName() == null || !method.getName().equals(beforeMethodToken.value)) continue;
                    TypeReference rtype = method.getReturnValueType();
                    String re = rtype.metaDataRef;
                    return (BusinessObjectInfo)this.boMap.get(re);
                }
            }
        }
        return null;
    }

    private IVarInfo getVarinfoByName(String varName) {
        if (this.varList != null) {
            for (IVarInfo varinfo : this.varList) {
                String name = varinfo.getVarName();
                if (!name.equals(varName)) continue;
                return varinfo;
            }
        }
        return null;
    }

    public TokenList getAliasTokenList() throws ParserException {
        Token token;
        StringBuffer aliassb = new StringBuffer();
        int index = 0;
        while ((token = this.tokenlist.lookup(index)) != null && token.type != 12) {
            int i;
            int j;
            boolean find;
            if (this.isVarinfo(token)) {
                IVarInfo var = this.getVarinfoByName(token.value);
                aliassb.append(var.getVarAlias());
            } else if (this.isProperty(index)) {
                EntityObjectInfo bo = (EntityObjectInfo)this.getPropertyOrMethodBO(index);
                find = false;
                if (bo != null) {
                    PropertyCollection pc = bo.getInheritedNoDuplicatedProperties();
                    j = pc.size();
                    for (i = 0; i < j; ++i) {
                        PropertyInfo pro = pc.get(i);
                        if (pro.getName() == null || !pro.getName().equals(token.value)) continue;
                        aliassb.append(AliasTransformer.propTransform(pro.getAlias()));
                        find = true;
                        break;
                    }
                }
                if (!find) {
                    aliassb.append(token.value);
                }
            } else if (this.isMethod(index)) {
                BusinessObjectInfo bo = this.getPropertyOrMethodBO(index);
                find = false;
                if (bo != null) {
                    MethodCollection mc = bo.getAllMethods();
                    j = mc.size();
                    for (i = 0; i < j; ++i) {
                        MethodInfo method = mc.get(i);
                        if (method.getName() == null || !method.getName().equals(token.value)) continue;
                        aliassb.append(AliasTransformer.propTransform(method.getAlias()));
                        find = true;
                        break;
                    }
                }
                if (!find) {
                    aliassb.append(token.value);
                }
            } else if (this.isConstant(index)) {
                aliassb.append("\"");
                aliassb.append(token.value);
                aliassb.append("\"");
            } else {
                boolean flag = false;
                for (int i2 = 0; i2 < chineseKeywords.length; ++i2) {
                    if (!chineseKeywords[i2].equals(token.value)) continue;
                    flag = true;
                    break;
                }
                if (flag) {
                    aliassb.append(" ");
                    aliassb.append(token.value);
                    aliassb.append(" ");
                } else if (token.value.equals("if") || token.value.equals("else")) {
                    aliassb.append(token.value);
                    aliassb.append(" ");
                } else if (token.value.equals("new")) {
                    aliassb.append(token.value);
                    aliassb.append(" ");
                } else {
                    aliassb.append(token.value);
                }
            }
            ++index;
        }
        Lexer _lexer = new Lexer(aliassb.toString());
        TokenList _tokenList = new TokenList(_lexer);
        return _tokenList;
    }
}

