/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.formula.engine;

import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.parser.Lexer;
import com.kingdee.bos.kscript.parser.Token;
import com.kingdee.bos.kscript.parser.TokenList;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueCollection;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.bos.service.formula.api.IVarInfo;
import com.kingdee.bos.service.formula.api.VarInfo;
import com.kingdee.bos.service.formula.engine.IKScriptTransformer;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.Enum;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class EnumTransformer
implements IKScriptTransformer {
    private Vector varList;
    private HashMap boMap;

    public EnumTransformer(Vector varList) {
        this.varList = varList;
        this.boMap = new HashMap();
    }

    public void addBOSObjects(BusinessObjectInfo[] bosobjs) {
        for (int i = 0; i < bosobjs.length; ++i) {
            if (!(bosobjs[i] instanceof EntityObjectInfo)) continue;
            EntityObjectInfo entity = (EntityObjectInfo)bosobjs[i];
            this.boMap.put(entity.getFullName(), entity);
        }
    }

    public void addBOSObjects(Vector bosobjs) {
        for (Object obj : bosobjs) {
            if (!(obj instanceof EntityObjectInfo)) continue;
            EntityObjectInfo entity = (EntityObjectInfo)obj;
            this.boMap.put(entity.getFullName(), entity);
        }
    }

    @Override
    public TokenList transform(TokenList tokenList) throws ParserException {
        int index = 0;
        while (true) {
            boolean match = false;
            IVarInfo varinfo2 = null;
            Token k = tokenList.lookup(index);
            if (k == null || k.type == 12) break;
            if (k.type == 1) {
                if (index > 0 && tokenList.lookup(index - 1).equals(Token.PeriodToken)) {
                    ++index;
                    continue;
                }
                if (this.varList != null) {
                    for (IVarInfo varinfo2 : this.varList) {
                        String varName = varinfo2.getVarName();
                        if (!varName.equals(k.value)) continue;
                        match = true;
                        break;
                    }
                }
            }
            if (match) {
                StringBuffer propertyName = new StringBuffer("");
                if (varinfo2 == null) {
                    varinfo2 = new VarInfo(null, null, null, null, null, null);
                }
                String property = varinfo2.getVarName();
                int start = index;
                while (true) {
                    Token t1 = tokenList.lookup(start + 1);
                    Token t2 = tokenList.lookup(start + 2);
                    if (!t1.equals(Token.PeriodToken)) break;
                    if (start != index) {
                        propertyName.append(".");
                    } else {
                        property = property + ".";
                    }
                    ++start;
                    if (t2.type != 1) break;
                    propertyName.append(t2.value);
                    ++start;
                }
                ObjectType type = null;
                EntityObjectInfo bo = this.findBOSObject(varinfo2);
                type = bo instanceof EntityObjectInfo ? new ObjectType(bo) : new ObjectType(varinfo2.getVarType());
                type = this.getPropertyType(type, propertyName.toString());
                index = start + 1;
                Token next = tokenList.lookup(index);
                if ((Token.EqualToken.equals(next) || Token.NotEqualToken.equals(next)) && type != null && type.type.equals("OWNER") && type.ownProperty.getDataType().equals((Object)DataType.ENUM)) {
                    Token nextnext = tokenList.lookup(index + 1);
                    BizEnumInfo enumInfo = type.ownProperty.getEnumType();
                    this.replaceEnumWhenPossible(nextnext, enumInfo);
                }
                index += 2;
                continue;
            }
            ++index;
        }
        return tokenList;
    }

    private void replaceEnumWhenPossible(Token token, BizEnumInfo enumInfo) {
        if (token != null && token.type == 1) {
            BizEnumValueCollection enumValues = enumInfo.getEnumValue();
            for (int i = 0; i < enumValues.size(); ++i) {
                BizEnumValueInfo element = enumValues.get(i);
                if (!element.getAlias().equals(token.value)) continue;
                token.value = element.getValue().toString();
                if (enumInfo.getDataType().equals((Object)BizEnumValueType.INTEGER)) {
                    token.type = 8;
                }
                if (enumInfo.getDataType().equals((Object)BizEnumValueType.STRING)) {
                    token.type = 6;
                }
                if (enumInfo.getDataType().equals((Object)BizEnumValueType.LONG)) {
                    token.type = 15;
                }
                if (enumInfo.getDataType().equals((Object)BizEnumValueType.FLOAT)) {
                    token.type = 9;
                }
                if (!enumInfo.getDataType().equals((Object)BizEnumValueType.DOUBLE)) break;
                token.type = 10;
                break;
            }
        }
    }

    private void replaceEnumAliasWhenPossible(Token token, BizEnumInfo enumInfo) {
        if (token != null) {
            BizEnumValueCollection enumValues = enumInfo.getEnumValue();
            for (int i = 0; i < enumValues.size(); ++i) {
                BizEnumValueInfo element = enumValues.get(i);
                if (!element.getValue().equals(token.value)) continue;
                token.value = element.getAlias();
                token.type = 1;
                break;
            }
        }
    }

    private EntityObjectInfo findBOSObject(IVarInfo var) {
        if (var != null && !EnumTransformer.isSimapleType(var)) {
            String voFullName = var.getVarType();
            for (EntityObjectInfo entity : this.boMap.values()) {
                if (!entity.getObjectValueClass().equals(voFullName)) continue;
                return entity;
            }
        }
        return null;
    }

    private static boolean isSimapleType(IVarInfo var) {
        return var.getVarType().equals("BIGDECIMAL") || var.getVarType().equals("BOOLEAN") || var.getVarType().equals("DATE") || var.getVarType().equals("DOUBLE") || var.getVarType().equals("INT") || var.getVarType().equals("LONG") || var.getVarType().equals("STRING");
    }

    static int findOpHead(TokenList tokenList, int opPos) throws ParserException {
        int i;
        int braceDep = 0;
        for (i = opPos - 1; i > 0; --i) {
            Token __t;
            Token _t = tokenList.lookup(i);
            if (_t == null) continue;
            if (_t.equals(Token.CloseBraceToken)) {
                ++braceDep;
                continue;
            }
            if (_t.equals(Token.OpenBraceToken)) {
                --braceDep;
                continue;
            }
            if (_t.type != 1 || braceDep != 0 || i <= 0 || (__t = tokenList.lookup(i - 1)) == null || __t.equals(Token.PeriodToken)) continue;
            return i - 1;
        }
        return i;
    }

    private static int convertEnum(TokenList tokenList, int pos, Enum _enum) throws ParserException {
        StringBuffer sb = new StringBuffer();
        if (pos > 0) {
            Token opToken = tokenList.lookup(pos - 1);
            if (opToken.equals(Token.EqualToken)) {
                sb.append(".equals(");
                String enumClassName = _enum.getClass().getName();
                String enumName = _enum.getName();
                sb.append(enumClassName).append(".").append(enumName);
                sb.append(")");
                Lexer _lexer = new Lexer(sb.toString());
                TokenList _tokenList = new TokenList(_lexer);
                return EnumTransformer.replaceTokens(tokenList, _tokenList, pos - 1, pos);
            }
            if (opToken.equals(Token.NotEqualToken)) {
                int head = EnumTransformer.findOpHead(tokenList, pos - 1);
                tokenList.insert(head, Token.NotToken);
                sb.append(".equals(");
                String enumClassName = _enum.getClass().getName();
                String enumName = _enum.getName();
                sb.append(enumClassName).append(".").append(enumName);
                sb.append(")");
                Lexer _lexer = new Lexer(sb.toString());
                TokenList _tokenList = new TokenList(_lexer);
                return EnumTransformer.replaceTokens(tokenList, _tokenList, pos - 1 + 1, pos + 1);
            }
            String enumClassName = _enum.getClass().getName();
            String enumName = _enum.getName();
            sb.append(enumClassName).append(".").append(enumName);
            Lexer _lexer = new Lexer(sb.toString());
            TokenList _tokenList = new TokenList(_lexer);
            return EnumTransformer.replaceTokens(tokenList, _tokenList, pos, pos);
        }
        return pos;
    }

    private static int replaceTokens(TokenList tokenList, TokenList insert, int start, int end) throws ParserException {
        Token first = tokenList.lookup(start);
        Token k = insert.lookup(0);
        first.type = k.type;
        first.value = k.value;
        for (int i = start + 1; i <= end; ++i) {
            tokenList.remove(start);
        }
        ++start;
        int index = 1;
        while (true) {
            k = insert.lookup(index++);
            if (k.type == 12) break;
            tokenList.insert(start++, k);
        }
        return start;
    }

    @Override
    public TokenList reverseTransform(TokenList tokenList) throws ParserException {
        int index = 0;
        while (true) {
            boolean match = false;
            IVarInfo varinfo2 = null;
            Token k = tokenList.lookup(index);
            if (k == null || k.type == 12) break;
            if (k.type == 1) {
                if (index > 0 && tokenList.lookup(index - 1).equals(Token.PeriodToken)) {
                    ++index;
                    continue;
                }
                if (this.varList != null) {
                    for (IVarInfo varinfo2 : this.varList) {
                        String varName = varinfo2.getVarName();
                        if (!varName.equals(k.value)) continue;
                        match = true;
                        break;
                    }
                }
            }
            if (match) {
                StringBuffer propertyName = new StringBuffer("");
                if (varinfo2 == null) {
                    varinfo2 = new VarInfo(null, null, null, null, null, null);
                }
                String property = varinfo2.getVarName();
                int start = index;
                while (true) {
                    Token t1 = tokenList.lookup(start + 1);
                    Token t2 = tokenList.lookup(start + 2);
                    if (!t1.equals(Token.PeriodToken)) break;
                    if (start != index) {
                        propertyName.append(".");
                    } else {
                        property = property + ".";
                    }
                    ++start;
                    if (t2.type != 1) break;
                    propertyName.append(t2.value);
                    ++start;
                }
                ObjectType type = null;
                EntityObjectInfo bo = this.findBOSObject(varinfo2);
                type = bo instanceof EntityObjectInfo ? new ObjectType(bo) : new ObjectType(varinfo2.getVarType());
                type = this.getPropertyType(type, propertyName.toString());
                index = start + 1;
                Token next = tokenList.lookup(index);
                if ((Token.EqualToken.equals(next) || Token.NotEqualToken.equals(next)) && type != null && type.type.equals("OWNER") && type.ownProperty.getDataType().equals((Object)DataType.ENUM)) {
                    Token nextnext = tokenList.lookup(index + 1);
                    BizEnumInfo enumInfo = type.ownProperty.getEnumType();
                    this.replaceEnumAliasWhenPossible(nextnext, enumInfo);
                }
                index += 2;
                continue;
            }
            ++index;
        }
        return tokenList;
    }

    public ObjectType getPropertyType(ObjectType owner, String name) {
        if (StringUtils.isEmpty((String)name)) {
            return owner;
        }
        if (owner == null) {
            return null;
        }
        String _name = name;
        String left = "";
        ObjectType next = null;
        int pos = name.indexOf(46);
        if (pos != -1) {
            _name = name.substring(0, pos);
            left = name.substring(pos + 1);
        }
        if (owner.type.equals("LINK")) {
            PropertyInfo property = null;
            PropertyCollection properties = owner.entity.getInheritedNoDuplicatedPropertiesRuntime();
            Iterator it = properties.iterator();
            boolean match = false;
            while (it.hasNext()) {
                PropertyInfo _property = (PropertyInfo)it.next();
                String propertyName = _property.getName();
                if (!_name.equals(propertyName)) continue;
                match = true;
                property = _property;
                break;
            }
            if (match && property != null) {
                if (property instanceof LinkPropertyInfo) {
                    LinkPropertyInfo linkProperty = (LinkPropertyInfo)property;
                    EntityObjectInfo entity = linkProperty.getRelationship().getSupplierObject();
                    next = new ObjectType(entity);
                } else if (property instanceof OwnPropertyInfo) {
                    next = new ObjectType((OwnPropertyInfo)property);
                }
                return this.getPropertyType(next, left);
            }
            String ovClassName = owner.entity.getObjectValueClass();
            return this.getPropertyType(new ObjectType(ovClassName), name);
        }
        if (owner.type.equals("OWNER")) {
            String className = owner.ownProperty.getJavaType();
            return this.getPropertyType(new ObjectType(className), name);
        }
        if (owner.type.equals("OBJECT")) {
            String className = owner.objClass;
            Field field = null;
            try {
                field = Class.forName(className).getField(_name);
            }
            catch (SecurityException it) {
            }
            catch (NoSuchFieldException it) {
            }
            catch (ClassNotFoundException it) {
                // empty catch block
            }
            if (field == null) {
                return null;
            }
            Class<?> fieldClass = field.getDeclaringClass();
            next = new ObjectType(fieldClass.getName());
            return this.getPropertyType(next, left);
        }
        return null;
    }

    class ObjectType {
        public static final String TYPE_LINK = "LINK";
        public static final String TYPE_OWNER = "OWNER";
        public static final String TYPE_OBJECT = "OBJECT";
        String type;
        EntityObjectInfo entity;
        OwnPropertyInfo ownProperty;
        String objClass;

        ObjectType(EntityObjectInfo entity) {
            this.entity = entity;
            this.type = TYPE_LINK;
        }

        ObjectType(OwnPropertyInfo ownProperty) {
            this.ownProperty = ownProperty;
            this.type = TYPE_OWNER;
        }

        ObjectType(String objClass) {
            this.objClass = objClass;
            this.type = TYPE_OBJECT;
        }
    }
}

