/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mobile.MobileException;
import com.kingdee.eas.mobile.MobileMessageQuerySchemaCollection;
import com.kingdee.eas.mobile.MobileMessageQuerySchemaInfo;
import com.kingdee.eas.mobile.app.AbstractMobileMessageQuerySchemaControllerBean;
import com.kingdee.util.StringUtils;

public class MobileMessageQuerySchemaControllerBean
extends AbstractMobileMessageQuerySchemaControllerBean {
    @Override
    protected IObjectCollection _getSchemaByUserAndFunction(Context ctx, String userID, String functionID) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)userID) || StringUtils.isEmpty((String)functionID)) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("user", (Object)userID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("bizFunction", (Object)functionID, CompareType.EQUALS));
        viewInfo.getSorter().add(new SorterItemInfo("number"));
        viewInfo.setFilter(filterInfo);
        return this.getMobileMessageQuerySchemaCollection(ctx, viewInfo);
    }

    @Override
    protected IObjectValue _getDefaultSchemaByUserAndFunction(Context ctx, String userID, String functionID) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)userID) || StringUtils.isEmpty((String)functionID)) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("user", (Object)userID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("bizFunction", (Object)functionID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isDefault", (Object)new Integer(1), CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        MobileMessageQuerySchemaCollection col = this.getMobileMessageQuerySchemaCollection(ctx, viewInfo);
        if (col != null && col.size() > 0) {
            return col.get(0);
        }
        return null;
    }

    @Override
    protected void _submitSchemaInfo(Context ctx, IObjectValue schemaInfo) throws BOSException, EASBizException {
        if (schemaInfo == null) {
            return;
        }
        MobileMessageQuerySchemaInfo info = (MobileMessageQuerySchemaInfo)schemaInfo;
        if (info.getId() == null) {
            this._addnew(ctx, (IObjectValue)info);
        } else {
            this._update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (IObjectValue)info);
        }
    }

    @Override
    protected void _submitSchemaCollection(Context ctx, IObjectCollection schemaCol) throws BOSException, EASBizException {
        if (schemaCol == null && (schemaCol == null || schemaCol.size() == 0)) {
            return;
        }
        MobileMessageQuerySchemaCollection schemaCollection = (MobileMessageQuerySchemaCollection)schemaCol;
        for (int i = 0; i < schemaCollection.size(); ++i) {
            MobileMessageQuerySchemaInfo schemaInfo = schemaCollection.get(i);
            if (schemaInfo.getId() == null) {
                this._addnew(ctx, (IObjectValue)schemaInfo);
                continue;
            }
            this._update(ctx, (IObjectPK)new ObjectUuidPK(schemaInfo.getId()), (IObjectValue)schemaInfo);
        }
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MobileMessageQuerySchemaInfo schemaInfo = (MobileMessageQuerySchemaInfo)model;
        this.checkNumberLength(ctx, schemaInfo.getNumber());
        this.checkNumberDuplicate(ctx, schemaInfo);
        this.checkDefaultUnique(ctx, schemaInfo);
        return super._addnew(ctx, (IObjectValue)schemaInfo);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        MobileMessageQuerySchemaInfo schemaInfo = (MobileMessageQuerySchemaInfo)model;
        this.checkNumberLength(ctx, schemaInfo.getNumber());
        this.checkNumberDuplicate(ctx, schemaInfo);
        this.checkDefaultUnique(ctx, schemaInfo);
        super._update(ctx, pk, (IObjectValue)schemaInfo);
    }

    private void checkNumberLength(Context ctx, String number) throws EASBizException, BOSException {
        if (number.length() > 80) {
            throw new MobileException(MobileException.NUMBER_TOO_LONG);
        }
    }

    private void checkNumberDuplicate(Context ctx, MobileMessageQuerySchemaInfo schemaInfo) throws EASBizException, BOSException {
        String userID = schemaInfo.getUser().getId().toString();
        String functionID = schemaInfo.getBizFunction().getId().toString();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("user", (Object)userID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("bizFunction", (Object)functionID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)schemaInfo.getNumber(), CompareType.EQUALS));
        if (schemaInfo.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)schemaInfo.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filterInfo)) {
            throw new MobileException(MobileException.SCHEMA_NUMBER_CANT_DUPLICATE);
        }
    }

    private void checkDefaultUnique(Context ctx, MobileMessageQuerySchemaInfo schemaInfo) throws EASBizException, BOSException {
        if (!schemaInfo.isIsDefault()) {
            return;
        }
        String userID = schemaInfo.getUser().getId().toString();
        String functionID = schemaInfo.getBizFunction().getId().toString();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("user", (Object)userID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("bizFunction", (Object)functionID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isDefault", (Object)new Integer(1), CompareType.EQUALS));
        if (schemaInfo.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)schemaInfo.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filterInfo)) {
            throw new MobileException(MobileException.SCHEMA_DEFAULT_CANT_DUPLICATE);
        }
    }
}

