/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.mobile.CoreMessageInfo;
import com.kingdee.eas.mobile.CoreSendMessageInfo;
import com.kingdee.eas.mobile.MobileException;
import com.kingdee.eas.mobile.SendMobileMessageInfo;
import com.kingdee.eas.mobile.app.AbstractSendMobileMessageControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import org.apache.log4j.Logger;

public class SendMobileMessageControllerBean
extends AbstractSendMobileMessageControllerBean {
    private Logger logger = Logger.getLogger(SendMobileMessageControllerBean.class);

    @Override
    public void delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        if (arrayPK != null && arrayPK.length > 0) {
            for (int i = 0; i < arrayPK.length; ++i) {
                super.delete(ctx, arrayPK[i]);
            }
        }
    }

    public String getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SendMobileMessageInfo info = this.getSendMobileMessageInfo(ctx, pk);
        if (info != null) {
            return info.getContent();
        }
        return "";
    }

    private void checkSendMsgNum(Context ctx) throws MobileException {
        int totalMessageNumber = this.getTotalMessageNumber(ctx);
        this.logger.error((Object)("\u53c2\u6570\u4e2d\u7684\u77ed\u4fe1\u53ef\u751f\u6210\u7684\u6700\u5927\u6570\u91cf\u4e3a:" + totalMessageNumber));
        int sendMobileMessageTotal = this.getSendMobileMessageTotal(ctx);
        if (sendMobileMessageTotal >= totalMessageNumber) {
            throw new MobileException(MobileException.EXCEED_TOTALMESSAGENUMBE);
        }
    }

    private int getSendMobileMessageTotal(Context ctx) {
        String sql2 = "SELECT count(*) total FROM T_MO_SENDMOMSG where  FCREATETIME  < CURDATE()+1 and  FCREATETIME >= CURDATE()";
        int total = 0;
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql2);
            if (rowSet.next()) {
                total = rowSet.getInt("total");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return total;
    }

    private int getTotalMessageNumber(Context ctx) {
        try {
            String paramValue = ParamManager.getParamValue((Context)ctx, null, (String)"TotalMessageNumberForEveryDay");
            return Integer.valueOf(paramValue);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return 9999999;
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkSendMsgNum(ctx);
        return super._addnew(ctx, model);
    }

    @Override
    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkSendMsgNum(ctx);
        super._addnew(ctx, pk, model);
    }

    @Override
    public IObjectPK addnew(Context ctx, SendMobileMessageInfo model) throws BOSException, EASBizException {
        this.checkSendMsgNum(ctx);
        return super.addnew(ctx, model);
    }

    @Override
    public void addnew(Context ctx, IObjectPK pk, SendMobileMessageInfo model) throws BOSException, EASBizException {
        this.checkSendMsgNum(ctx);
        super.addnew(ctx, pk, model);
    }

    @Override
    public IObjectPK addnew(Context ctx, CoreSendMessageInfo model) throws BOSException, EASBizException {
        this.checkSendMsgNum(ctx);
        return super.addnew(ctx, model);
    }

    @Override
    public void addnew(Context ctx, IObjectPK pk, CoreSendMessageInfo model) throws BOSException, EASBizException {
        this.checkSendMsgNum(ctx);
        super.addnew(ctx, pk, model);
    }

    @Override
    public IObjectPK addnew(Context ctx, CoreMessageInfo model) throws BOSException, EASBizException {
        this.checkSendMsgNum(ctx);
        return super.addnew(ctx, model);
    }

    @Override
    public void addnew(Context ctx, IObjectPK pk, CoreMessageInfo model) throws BOSException, EASBizException {
        this.checkSendMsgNum(ctx);
        super.addnew(ctx, pk, model);
    }

    public Result addnew(Context ctx, CoreBaseCollection colls) throws BOSException, EASBizException {
        this.checkSendMsgNum(ctx);
        return super.addnew(ctx, colls);
    }

    protected Result _addnew(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        this.checkSendMsgNum(ctx);
        return super._addnew(ctx, colls);
    }

    public IObjectPK addnew(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        this.checkSendMsgNum(ctx);
        return super.addnew(ctx, model);
    }

    public void addnew(Context ctx, IObjectPK pk, CoreBaseInfo model) throws BOSException, EASBizException {
        this.checkSendMsgNum(ctx);
        super.addnew(ctx, pk, model);
    }

    public IObjectPK[] addnewBatchData(Context ctx, CoreBaseCollection colls) throws BOSException, EASBizException {
        this.checkSendMsgNum(ctx);
        return super.addnewBatchData(ctx, colls);
    }
}

