/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.msg.biz;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.message.common.KDMessage;
import com.kingdee.bos.message.common.KDMessageAddress;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.SubmitAssignResult;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.IMultiApprove;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mobile.UserInfo;
import com.kingdee.eas.mobile.dao.DBHelper;
import com.kingdee.eas.mobile.dao.UserInfoDao;
import com.kingdee.eas.mobile.framework.ServerContext;
import com.kingdee.eas.mobile.msg.SendUserMsgInfo;
import com.kingdee.eas.mobile.msg.dao.DaoFactory;
import com.kingdee.eas.mobile.msg.dao.SendUserMsgDao;
import com.kingdee.eas.mobile.msg.dao.jdbc.MsgConvert;
import com.kingdee.eas.mobile.msg.framework.IRevertible;
import com.kingdee.eas.mobile.msg.framework.ValidateException;
import com.kingdee.eas.mobile.util.AppMsgUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class WorkflowBIZ
implements IRevertible {
    private static final String MOBILERESOURCE = "com.kingdee.eas.mobile.msg.MobileResource";
    private static final Logger logger = Logger.getLogger(WorkflowBIZ.class);
    private Hashtable assignmentMap = new Hashtable();
    private SendUserMsgDao msgDao = DaoFactory.getSendUserMsgDao();
    private UserInfoDao userDao = DaoFactory.getUserInfoDao();
    private ServerContext context;
    private IEnactmentService WFService;
    private IMultiApprove iMultiApprove;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validate(KDMessage msg) throws ValidateException {
        logger.info((Object)"---mobile---WorkflowBIZ--msg---validate--");
        boolean validate = false;
        String msgId = msg.getRelativeId();
        if (msgId == null || msgId.trim().length() == 0) {
            return validate;
        }
        Connection con = null;
        String oql = " where msgId = '" + msgId + "'";
        SendUserMsgInfo info = null;
        try {
            con = this.context.getConnection();
            ORMappingDAO dao = new ORMappingDAO(MsgConvert.SEND_MSG_TYPE, this.context.getBosContext(), con);
            info = (SendUserMsgInfo)dao.getValue(oql);
        }
        catch (DataAccessException e) {
            logger.error((Object)e);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
        Locale local = AppMsgUtil.getSenderLocaleFromMobileMessage(msg, this.context.getBosContext());
        if (info == null) {
            throw new ValidateException(ResourceBase.getString((String)MOBILERESOURCE, (String)"getMessageFrom_Fail", (Locale)local));
        }
        if (info.getContent() != null && info.getContent().equals("for.process") && info.getMsgType() == 1) {
            return false;
        }
        if (info.getAssignmentId() == null || info.getAssignmentId().trim().length() == 0) {
            throw new ValidateException(ResourceBase.getString((String)MOBILERESOURCE, (String)"messageIsNotWFAssign", (Locale)local));
        }
        if (info.isReplied()) {
            throw new ValidateException(ResourceBase.getString((String)MOBILERESOURCE, (String)"messageHasReturn", (Locale)local));
        }
        this.assignmentMap.put(msgId, info.getAssignmentId());
        return true;
    }

    @Override
    public KDMessage[] doResponse(KDMessage msg) {
        String ignoreSMSSuccessResponse;
        boolean success;
        ConfigurationItem sln;
        KDMessage response;
        block21: {
            logger.info((Object)("---mobile---WorkflowBIZ--msg---doing msg-\u5de5\u4f5c\u6d41\u6a21\u5757\u6b63\u5728\u5904\u7406\u8be5\u6d88\u606f-" + msg.getTitle()));
            response = new KDMessage();
            String approveContent = "";
            Locale local = AppMsgUtil.getSenderLocaleFromMobileMessage(msg, this.context.getBosContext());
            String lan = local.getLanguage();
            if ("l2".equalsIgnoreCase(lan)) {
                local = LocaleUtils.locale_zh_CN;
            }
            Configuration bosConfig = Configuration.getInstance();
            sln = bosConfig.getConfigItem("PortalInfo");
            if (msg.getSender() != null && "mp:mail".equals(msg.getSender().getDeviceName())) {
                String isAllowEMailAudit;
                if (!(sln == null || (isAllowEMailAudit = sln.getProperty("isAllowEMailAudit")) != null && isAllowEMailAudit.trim().equalsIgnoreCase("true"))) {
                    response.setTitle(ResourceBase.getString((String)MOBILERESOURCE, (String)"systemIsNotAllowEmailAudit", (Locale)local));
                    return new KDMessage[]{response};
                }
                approveContent = msg.getContent();
                int index = approveContent.toLowerCase().indexOf("<body");
                if (index > 0) {
                    approveContent = approveContent.substring(index);
                    String regEx = "<[^>]+>|</[^>]+>";
                    Pattern p = Pattern.compile(regEx);
                    Matcher m = p.matcher(approveContent);
                    approveContent = m.replaceAll("");
                    approveContent.trim();
                    if (approveContent.indexOf("&nbsp;") > 0) {
                        regEx = "&nbsp;";
                        p = Pattern.compile(regEx);
                        m = p.matcher(approveContent);
                        approveContent = m.replaceAll("");
                        approveContent.trim();
                    }
                    msg.setContent(approveContent);
                }
            } else {
                approveContent = msg.getTitle();
            }
            logger.info((Object)("WorkflowBIZ doResponse approveContent = " + approveContent));
            if (!this.formatMatch(approveContent)) {
                response.setTitle(ResourceBase.getString((String)MOBILERESOURCE, (String)"returnYOrN", (Locale)local));
                return new KDMessage[]{response};
            }
            String assignmentId = (String)this.assignmentMap.get(msg.getRelativeId());
            try {
                AssignmentInfo info = this.WFService.getAssignmentById(assignmentId);
                if (info.getState().getValue() == 4 || info.getState().getValue() == 8) {
                    response.setTitle("\u4efb\u52a1\u5df2\u7ecf\u88ab\u53d6\u6d88\u6216\u62d2\u7edd\uff0c\u8bf7\u767b\u5f55EAS\u5ba2\u6237\u7aef\u67e5\u770b\u8be6\u7ec6\u4fe1\u606f!");
                    return new KDMessage[]{response};
                }
                if (info.getState().getValue() == 16 || info.getState().getValue() == 32) {
                    response.setTitle("\u4efb\u52a1\u5df2\u5904\u7406\u8fc7,\u8bf7\u52ff\u91cd\u590d\u5904\u7406\uff0c\u8bf7\u767b\u5f55EAS\u5ba2\u6237\u7aef\u67e5\u770b\u8be6\u7ec6\u4fe1\u606f!");
                    return new KDMessage[]{response};
                }
            }
            catch (WfException e1) {
                logger.error((Object)("\u6839\u636e\u4efb\u52a1ID\u83b7\u53d6\u4efb\u52a1\u5bf9\u8c61\u5931\u8d25\uff1a" + e1.getMessage()));
                response.setTitle("\u83b7\u53d6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u767b\u5f55EAS\u5ba2\u6237\u7aef\u67e5\u770b\u8be6\u7ec6\u4fe1\u606f!");
                return new KDMessage[]{response};
            }
            logger.info((Object)("---mobile---WorkflowBIZ---assignmentId=" + assignmentId));
            success = false;
            if (assignmentId != null) {
                UserInfo info = null;
                try {
                    info = this.getUserInfo(msg);
                }
                catch (Exception e1) {
                    logger.info((Object)("errro:" + e1.getMessage()));
                }
                if (info != null && info.getUserid() != null && !info.getUserid().trim().equals("")) {
                    try {
                        success = this.submitAssignment(assignmentId, approveContent, info.getUserid());
                        if (success) {
                            this.setReplied(msg, response);
                            break block21;
                        }
                        response.setTitle(ResourceBase.getString((String)MOBILERESOURCE, (String)"processFail", (Locale)local));
                    }
                    catch (Exception e) {
                        response.setTitle(ResourceBase.getString((String)MOBILERESOURCE, (String)"processFail", (Locale)local));
                        logger.info((Object)("errro:" + e.getMessage()));
                    }
                } else {
                    response.setTitle(ResourceBase.getString((String)MOBILERESOURCE, (String)"cannotGetUser", (Locale)local));
                }
            } else {
                response.setTitle(ResourceBase.getString((String)MOBILERESOURCE, (String)"canntFindAssignFail", (Locale)local));
            }
        }
        if (success && msg.getSender() != null && "mp:sms".equals(msg.getSender().getDeviceName()) && sln != null && "true".equalsIgnoreCase(ignoreSMSSuccessResponse = sln.getProperty("ignoreSMSSuccessResponse"))) {
            return new KDMessage[0];
        }
        return new KDMessage[]{response};
    }

    @Override
    public boolean init(ServerContext context) {
        this.context = context;
        boolean success = true;
        try {
            Context ctx = context.getBosContext();
            this.WFService = (IEnactmentService)BOSObjectFactory.createBOSObject((Context)ctx, (String)EnactmentServiceProxy.class.getName());
            this.iMultiApprove = MultiApproveFactory.getLocalInstance((Context)ctx);
            logger.debug((Object)"\u5de5\u4f5c\u6d41\u6a21\u5757\u542f\u52a8");
        }
        catch (BOSException e) {
            success = false;
            logger.info((Object)e.getMessage());
        }
        return success;
    }

    @Override
    public void destroy() {
        this.iMultiApprove = null;
        this.WFService = null;
        logger.debug((Object)"\u5de5\u4f5c\u6d41\u6a21\u5757\u88ab\u9500\u6bc1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final UserInfo getUserInfo(KDMessage msg) throws Exception {
        UserInfo info = null;
        KDMessageAddress address = msg.getSender();
        if (address == null) {
            return null;
        }
        String address_detail = address.getDeviceName();
        String address_id = address.getDetail();
        if ("mp:sms".equals(address_detail)) {
            Connection con = null;
            try {
                con = this.context.getConnection();
                info = this.userDao.getUserInfoByMobile(address_id, con, true);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
            finally {
                DBHelper.cleanup(con);
            }
        } else if ("mp:mail".equals(address_detail)) {
            Connection con = null;
            try {
                con = this.context.getConnection();
                info = this.userDao.getUserInfoByEmail(address_id, con, true);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
            finally {
                DBHelper.cleanup(con);
            }
        } else if ("mp:im".equals(address_detail)) {
            Connection con = null;
            try {
                con = this.context.getConnection();
                info = this.userDao.getUserInfoByRtx(address_id, con, true);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
            finally {
                DBHelper.cleanup(con);
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setReplied(KDMessage msg, KDMessage response) {
        Locale local = AppMsgUtil.getSenderLocaleFromMobileMessage(msg, this.context.getBosContext());
        Connection con = null;
        try {
            con = this.context.getConnection();
            boolean statue = con.getAutoCommit();
            con.setAutoCommit(false);
            try {
                this.msgDao.setReplied(msg.getRelativeId(), con);
                con.commit();
            }
            catch (Exception ex) {
                con.rollback();
            }
            con.setAutoCommit(statue);
            response.setTitle(ResourceBase.getString((String)MOBILERESOURCE, (String)"AuditProcessSuccess", (Locale)local));
        }
        catch (Exception ex) {
            response.setTitle(ex.getMessage());
        }
        finally {
            DBHelper.cleanup(con);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean submitAssignment(String assignment, String title, String userid) throws Exception {
        boolean success = false;
        logger.info((Object)("---mobile---WorkflowBIZ--msg---\u4efb\u52a1ID:" + assignment + ", \n\u56de\u590d\u5185\u5bb9:" + title + ",\u7528\u6237ID\n" + userid));
        try {
            AssignmentInfo info;
            if (this.WFService != null) {
                info = this.WFService.getAssignmentById(assignment);
            } else {
                if (this.context == null) {
                    logger.info((Object)"\u83b7\u53d6\u5de5\u4f5c\u6d41\u63a5\u53e3IEnactmentService\u5931\u8d25");
                    return false;
                }
                if (!this.init(this.context)) {
                    logger.info((Object)"\u83b7\u53d6\u5de5\u4f5c\u6d41\u63a5\u53e3IEnactmentService\u5931\u8d25");
                    return false;
                }
                info = this.WFService.getAssignmentById(assignment);
            }
            if (info == null) {
                logger.info((Object)"\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u4efb\u52a1\u4fe1\u606f");
                return false;
            }
            ApproveContent approve = this.parseApproveContent(title, assignment);
            this.wrapperApproveContent(approve);
            ApproveResult result = approve.result;
            String opinion = approve.opinion;
            int handlerOpinion = approve.handleOpinion;
            String decision = approve.handleContent;
            String[] idsArray = info.getBizObjectIdArray();
            BOSUuid billId = BOSUuid.read((String)idsArray[0]);
            if (billId == null) return success;
            HashMap<IObjectPK, MultiApproveInfo> dataMap = new HashMap<IObjectPK, MultiApproveInfo>();
            MultiApproveInfo mutiApproveInfo = new MultiApproveInfo();
            mutiApproveInfo.setIsPass(result);
            logger.debug((Object)("result :" + result));
            mutiApproveInfo.setOpinion(opinion);
            logger.debug((Object)("opinion :" + opinion));
            mutiApproveInfo.setBillId(billId);
            logger.debug((Object)("billId :" + billId));
            mutiApproveInfo.setIsMailNotifyNext(true);
            mutiApproveInfo.setIsMobelNotifyNext(true);
            mutiApproveInfo.setAssignment(assignment);
            mutiApproveInfo.setHandlerOpinion(handlerOpinion);
            mutiApproveInfo.setHandlerContent(decision);
            com.kingdee.eas.base.permission.UserInfo creator = null;
            creator = UserFactory.getLocalInstance((Context)this.context.getBosContext()).getUserInfo((IObjectPK)new ObjectUuidPK(userid));
            if (creator == null) {
                creator = new com.kingdee.eas.base.permission.UserInfo();
                creator.setId(BOSUuid.read((String)userid));
            }
            mutiApproveInfo.setCreator(creator);
            Map extendedAttributes = this.WFService.getExtendedAttributesFromAssignment(assignment);
            String isMailNotifyNext = (String)extendedAttributes.get("isSendMail");
            String isMobelNotifyNext = (String)extendedAttributes.get("isSendSMS");
            logger.info((Object)("---mobile---WorkflowBIZ---isMailNotifyNext=" + isMailNotifyNext));
            logger.info((Object)("---mobile---WorkflowBIZ---isMobelNotifyNext=" + isMobelNotifyNext));
            if ("true".equalsIgnoreCase(isMailNotifyNext)) {
                mutiApproveInfo.setIsMailNotifyNext(true);
            } else {
                mutiApproveInfo.setIsMailNotifyNext(false);
            }
            if ("true".equalsIgnoreCase(isMobelNotifyNext)) {
                mutiApproveInfo.setIsMobelNotifyNext(true);
            } else {
                mutiApproveInfo.setIsMobelNotifyNext(false);
            }
            mutiApproveInfo.setAssignment(assignment);
            IObjectPK pk = this.iMultiApprove.addnew((CoreBaseInfo)mutiApproveInfo);
            dataMap.put(pk, mutiApproveInfo);
            this.WFService.acceptAssignment(assignment);
            SubmitAssignResult submitResult = this.WFService.submitAssignment(dataMap, userid, info);
            if (!submitResult.getStatus()) return false;
            return true;
        }
        catch (WfException e) {
            logger.error((Object)e.getMessage());
            return success;
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
            return success;
        }
        catch (UuidException e) {
            logger.error((Object)e.getMessage());
        }
        return success;
    }

    public void wrapperApproveContent(ApproveContent approve) {
        if (approve != null) {
            if (StringUtils.isEmpty((String)approve.opinion) && approve.result.equals((Object)ApproveResult.PASS)) {
                approve.opinion = "\u540c\u610f";
            }
            if (StringUtils.isEmpty((String)approve.opinion) && approve.result.equals((Object)ApproveResult.NOT_PASS)) {
                approve.opinion = "\u4e0d\u540c\u610f";
            }
        }
    }

    void setIMultiApprove(IMultiApprove approve) throws BOSException {
        this.iMultiApprove = approve;
    }

    void setORMEnactmentService(IEnactmentService service) throws BOSException {
        this.WFService = service;
    }

    private boolean formatMatch(String title) {
        boolean validate = false;
        if (title == null) {
            return validate;
        }
        if (title.trim().length() == 0) {
            return validate;
        }
        char c = title.trim().toLowerCase().charAt(0);
        if (c == 'y' || c == 'n' || c == '1' || c == '0' || c == '2') {
            validate = true;
        }
        return validate;
    }

    private ApproveContent parseApproveContent(String title, String assignmentId) throws WfException {
        String[] item;
        String[] items;
        title = title.trim();
        ApproveContent approve = new ApproveContent();
        char c = title.charAt(0);
        switch (c) {
            case '1': 
            case 'Y': 
            case 'y': {
                approve.result = ApproveResult.PASS;
                break;
            }
            case '0': 
            case '2': 
            case 'N': 
            case 'n': {
                approve.result = ApproveResult.NOT_PASS;
                break;
            }
            default: {
                approve.result = ApproveResult.NOT_PASS;
            }
        }
        if (title.length() == 1) {
            return approve;
        }
        title = title.substring(1).trim();
        c = title.charAt(0);
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                approve.handleOpinion = c - 48;
                title = title.substring(1).trim();
                break;
            }
            default: {
                approve.handleOpinion = 0;
            }
        }
        if (title.length() >= 255) {
            title = title.substring(0, 255);
        }
        approve.opinion = title;
        String decisions = this.WFService.getMultiApproveDecision(assignmentId);
        approve.handleContent = "";
        if (decisions != null && (items = StringUtils.split((String)decisions, (String)":")).length > approve.handleOpinion && (item = StringUtils.split((String)items[approve.handleOpinion], (String)";")).length > 1) {
            approve.handleContent = item[1];
        }
        return approve;
    }

    public static void main(String[] args) {
        String title = "<div>asdasd</div><ttt>asdsad</ttt>";
        String regEx = "<[^>]+>|</[^>]+>";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(title);
        title = m.replaceAll("");
        String s = m.replaceAll("");
        System.out.println(title);
    }

    private Locale getSenderLocale(KDMessage msg) {
        KDMessageAddress address = msg.getSender();
        return AppMsgUtil.getLocalByAddress(address, this.context.getBosContext());
    }

    public static class ApproveContent {
        public ApproveResult result;
        public int handleOpinion = 0;
        public String handleContent = "\u65e0";
        public String opinion;
    }
}

