/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.msg.dao.jdbc;

import com.kingdee.bos.message.common.util.Uuid;
import com.kingdee.eas.mobile.msg.BizModuleConfig;
import com.kingdee.eas.mobile.msg.BizModuleItem;
import com.kingdee.eas.mobile.msg.dao.BizConfigDao;
import com.kingdee.eas.mobile.msg.dao.jdbc.SqlProvider;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class DefaultBizConfigDao
implements BizConfigDao {
    private static final String SQL_ADD_AIS = SqlProvider.getSql("insertAisConfig");
    private static final String SQL_DEL_CMD_BY_AIS = SqlProvider.getSql("deleteCmdByAis");
    private static final String SQL_ADD_CMD = SqlProvider.getSql("insertCmdConfig");
    private static final String SQL_ADD_MODULE = SqlProvider.getSql("insertModuleConfig");
    private static final String SQL_FIND_MODULE = SqlProvider.getSql("findModuleByClassAndFunction");
    private static final String SQL_UPDATE_AIS = SqlProvider.getSql("updateAisConfig");
    private static final String SQL_FIND_AIS = SqlProvider.getSql("findSolutionByName");
    private static final String GET_SOLUTION_BY_AIS = SqlProvider.getSql("getSolutionByName");
    private static final String GET_CMD_BY_AIS = SqlProvider.getSql("getCommandsByAis");
    private static BizConfigDao ins = new DefaultBizConfigDao();
    private static Logger logger = Logger.getLogger(DefaultBizConfigDao.class);

    private DefaultBizConfigDao() {
    }

    public static synchronized BizConfigDao getInstance() {
        if (ins == null) {
            ins = new DefaultBizConfigDao();
        }
        return ins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveConfig(BizModuleConfig config, String ais, Connection con) throws SQLException {
        boolean success;
        block7: {
            block6: {
                success = false;
                if (DefaultBizConfigDao.hasAisExist(ais, con)) {
                    DefaultBizConfigDao.updateAisConfig(ais, config, con);
                    logger.debug((Object)"update ais config ok");
                } else {
                    DefaultBizConfigDao.inserAisConfig(ais, config, con);
                }
                DefaultBizConfigDao.deleteCmd(ais, con);
                ArrayList modules = config.getConfigedModules();
                int n = modules.size();
                if (n <= 0) break block6;
                PreparedStatement pstmt = null;
                PreparedStatement pstmt2 = null;
                try {
                    pstmt = con.prepareStatement(SQL_ADD_MODULE);
                    pstmt2 = con.prepareStatement(SQL_ADD_CMD);
                    for (int i = 0; i < n; ++i) {
                        BizModuleItem module = (BizModuleItem)modules.get(i);
                        if (!DefaultBizConfigDao.hasExist(module, con)) {
                            String uuid = Uuid.create().toString();
                            pstmt.setString(1, uuid);
                            pstmt.setInt(2, module.getBizKey());
                            pstmt.setString(3, module.getClassName());
                            pstmt.addBatch();
                            module.setBusiness_id(uuid);
                        }
                        int loaded = module.isLoaded() ? 1 : 0;
                        pstmt2.setString(1, Uuid.create().toString());
                        pstmt2.setString(2, ais);
                        pstmt2.setString(3, module.getBusiness_id());
                        pstmt2.setString(4, module.getCommand());
                        pstmt2.setInt(5, loaded);
                        pstmt2.addBatch();
                    }
                    pstmt.executeBatch();
                    pstmt2.executeBatch();
                    success = true;
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup((Statement)pstmt);
                    SQLUtils.cleanup(pstmt2);
                    throw throwable;
                }
                SQLUtils.cleanup((Statement)pstmt);
                SQLUtils.cleanup((Statement)pstmt2);
                break block7;
            }
            success = true;
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BizModuleConfig getConfig(String ais, Connection con) throws SQLException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        BizModuleConfig config = new BizModuleConfig();
        try {
            pstmt = con.prepareStatement(GET_SOLUTION_BY_AIS);
            pstmt.setString(1, ais);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                config.setHost(rs.getString(1));
                config.setPort(rs.getInt(2));
                config.setMsgTypes(rs.getInt(3));
            }
            rs.close();
            pstmt.close();
            if (config != null) {
                ArrayList<BizModuleItem> modules = new ArrayList<BizModuleItem>();
                pstmt = con.prepareStatement(GET_CMD_BY_AIS);
                pstmt.setString(1, ais);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    String command = rs.getString(1);
                    boolean isLoaded = rs.getInt(2) == 1;
                    int bizkey = rs.getInt(3);
                    String className = rs.getString(4);
                    String fbid = rs.getString(5);
                    BizModuleItem module = new BizModuleItem(command, className, bizkey);
                    module.setLoaded(isLoaded);
                    module.setBusiness_id(fbid);
                    modules.add(module);
                }
                config.setConfigedModules(modules);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, (Statement)pstmt);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean hasAisExist(String ais, Connection con) throws SQLException {
        ResultSet rs;
        PreparedStatement pstmt;
        block3: {
            boolean bl;
            pstmt = null;
            rs = null;
            try {
                pstmt = con.prepareStatement(SQL_FIND_AIS);
                pstmt.setString(1, ais);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block3;
                bl = true;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)pstmt);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
            return bl;
        }
        boolean bl = false;
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void updateAisConfig(String ais, BizModuleConfig config, Connection con) throws SQLException {
        String host = config.getHost();
        Integer port = new Integer(config.getPort());
        Integer channels = new Integer(config.getMsgTypes());
        Object[] objs = new Object[]{host, port, channels, ais};
        PreparedStatement pstmt = null;
        try {
            pstmt = con.prepareStatement(SQL_UPDATE_AIS);
            pstmt.setString(1, host);
            pstmt.setInt(2, config.getPort());
            pstmt.setInt(3, config.getMsgTypes());
            pstmt.setString(4, ais);
            pstmt.executeUpdate();
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void inserAisConfig(String ais, BizModuleConfig config, Connection con) throws SQLException {
        String uuid = Uuid.create().toString();
        String host = config.getHost();
        Integer port = new Integer(config.getPort());
        Integer channels = new Integer(config.getMsgTypes());
        Object[] objs = new Object[]{uuid, ais, host, port, channels};
        PreparedStatement pstmt = null;
        try {
            pstmt = con.prepareStatement(SQL_ADD_AIS);
            pstmt.setString(1, uuid);
            pstmt.setString(2, ais);
            pstmt.setString(3, host);
            pstmt.setInt(4, config.getPort());
            pstmt.setInt(5, config.getMsgTypes());
            pstmt.executeUpdate();
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    private static final void deleteCmd(String ais, Connection con) throws SQLException {
        PreparedStatement pstmt = null;
        try {
            pstmt = con.prepareStatement(SQL_DEL_CMD_BY_AIS);
            pstmt.setString(1, ais);
            pstmt.executeUpdate();
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void addCmd(String ais, BizModuleItem module, Connection con) throws SQLException {
        PreparedStatement pstmt = null;
        try {
            int loaded = module.isLoaded() ? 1 : 0;
            pstmt = con.prepareStatement(SQL_ADD_CMD);
            pstmt.setString(1, Uuid.create().toString());
            pstmt.setString(2, ais);
            pstmt.setString(3, module.getBusiness_id());
            pstmt.setString(4, module.getCommand());
            pstmt.setInt(5, loaded);
            pstmt.executeUpdate();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(pstmt);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)pstmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean hasExist(BizModuleItem module, Connection con) throws SQLException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        boolean isExist = false;
        try {
            pstmt = con.prepareStatement(SQL_FIND_MODULE);
            pstmt.setInt(1, module.getBizKey());
            pstmt.setString(2, module.getClassName());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                module.setBusiness_id(rs.getString(1));
                isExist = true;
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, (Statement)pstmt);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
        return isExist;
    }
}

