/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.msg.dao.jdbc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.message.common.KDMessage;
import com.kingdee.bos.message.common.KDMessageAttachment;
import com.kingdee.bos.message.common.KDMessageType;
import com.kingdee.bos.message.common.KDMsgCreator;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.mobile.UserInfo;
import com.kingdee.eas.mobile.dao.UserInfoDao;
import com.kingdee.eas.mobile.msg.BizModuleConfig;
import com.kingdee.eas.mobile.msg.SendUserMsgInfo;
import com.kingdee.eas.mobile.msg.dao.BizConfigDao;
import com.kingdee.eas.mobile.msg.dao.DaoFactory;
import com.kingdee.eas.mobile.msg.dao.SendUserMsgDao;
import com.kingdee.eas.mobile.msg.dao.jdbc.MsgConvert;
import com.kingdee.eas.mobile.msg.dao.jdbc.SqlProvider;
import com.kingdee.eas.mobile.msg.util.SysProperty;
import com.kingdee.eas.mobile.util.AppMsgUtil;
import com.kingdee.eas.mobile.util.MessageConstant;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.StringUtil;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class DefaultSendUserMsgDao
implements SendUserMsgDao {
    private static final String RESOURCE = "com.kingdee.eas.mobile.msg.ProcessQueryResource";
    private static final String ISSENDMOBILEBYWF = "com.kingdee.mobile.isSendMobileByWF";
    private static final String ISSENDEMAILEBYWF = "com.kingdee.mobile.isSendEMailByWF";
    static final String GET_NOTSENTD_MSGS = SqlProvider.getSql("getNotSentedMsgs");
    static final String INSERT_MSG = SqlProvider.getSql("insertMsg");
    static final String SET_MSG_REPLY = SqlProvider.getSql("setMsgReplied");
    static final String SET_MSG_SENTED = SqlProvider.getSql("setMsgSented");
    private static final Logger logger = Logger.getLogger(DefaultSendUserMsgDao.class);
    private static final KDMsgCreator helper = KDMsgCreator.create();
    private static UserInfo monitor = SysProperty.getMonitorUser();
    static final BizConfigDao configDao = DaoFactory.getBizConfigDao();
    static final UserInfoDao userDao = DaoFactory.getUserInfoDao();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(Message msg, Connection con) throws SQLException, BOSException {
        String ais = msg.getStringHeader("databaseCenter");
        BizModuleConfig config = null;
        try {
            config = configDao.getConfig(ais, con);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        if (config != null) {
            String receiver = msg.getStringHeader("receiver");
            String[] receivers = StringUtil.split((String)receiver, (String)";");
            ArrayList kdmsgs = new ArrayList();
            for (int i = 0; receivers != null && i < receivers.length; ++i) {
                String userid = receivers[i];
                UserInfo info = null;
                info = userid.equals(monitor.getUserid()) ? monitor : userDao.getUserInfo(userid, con, false);
                ArrayList msgs = this.generateSendUserMsgs(msg, info, config);
                if (msgs == null) continue;
                kdmsgs.addAll(msgs);
            }
            if (kdmsgs != null && kdmsgs.size() > 0) {
                PreparedStatement pstmt = null;
                try {
                    pstmt = con.prepareStatement(INSERT_MSG);
                    logger.info((Object)("\u8981\u4fdd\u5b58\u7684\u6d88\u606f\u5217\u8868\u5927\u5c0f" + kdmsgs.size()));
                    int n = kdmsgs.size();
                    for (int i = 0; i < n; ++i) {
                        SendUserMsgInfo info = (SendUserMsgInfo)kdmsgs.get(i);
                        DefaultSendUserMsgDao.saveMsgBatch(info, pstmt);
                    }
                    pstmt.executeBatch();
                }
                catch (Exception ex) {
                    logger.info((Object)("\u4fdd\u5b58mobile\u6d88\u606f\u5217\u8868\u5f02\u5e38" + ex.getMessage()));
                    ex.printStackTrace();
                }
                finally {
                    SQLUtils.cleanup((Statement)pstmt);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(KDMessage msg, String userid, boolean isSented, Connection con) throws SQLException {
        if (msg.getReceivers() == null || msg.getReceivers().length == 0) {
            return;
        }
        SendUserMsgInfo sendMsg = MsgConvert.convert(msg, msg.getReceivers()[0], userid, con);
        sendMsg.setSented(isSented);
        if (isSented) {
            sendMsg.setSendTime(new Timestamp(new Date().getTime()));
        }
        PreparedStatement pstmt = null;
        try {
            pstmt = con.prepareStatement(INSERT_MSG);
            DefaultSendUserMsgDao.saveMsgBatch(sendMsg, pstmt);
            pstmt.executeBatch();
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KDMessage[] getNotSented(Connection con, int maxCount) {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<KDMessage> temp = new ArrayList<KDMessage>(maxCount);
        long start = System.currentTimeMillis();
        logger.debug((Object)"getNotSentedMsgs");
        try {
            pstmt = con.prepareStatement(GET_NOTSENTD_MSGS);
            logger.debug((Object)GET_NOTSENTD_MSGS);
            rs = pstmt.executeQuery();
            int count = 0;
            while (rs.next() && count < maxCount) {
                try {
                    String msgId = rs.getString(1);
                    int priority = rs.getInt(2);
                    int revertible = rs.getInt(3);
                    String title = rs.getString(4);
                    String content = rs.getString(5);
                    String receiver = rs.getString(6);
                    int msgType = rs.getInt(7);
                    KDMessage msg = null;
                    switch (msgType) {
                        case 1: {
                            msg = helper.createMsgForSMS(receiver, title);
                            break;
                        }
                        case 2: {
                            msg = helper.createMsgForMail(receiver, title, content, new KDMessageAttachment[0]);
                            break;
                        }
                        case 3: {
                            msg = helper.createMsgForRtx(receiver, title, null);
                        }
                    }
                    if (msg == null) continue;
                    msg.setId(msgId);
                    if (revertible == 1) {
                        msg.setType(KDMessageType.REVERTIBLE);
                    }
                    temp.add(msg);
                }
                catch (SQLException sQLException) {}
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
        }
        finally {
            SQLUtils.cleanup(rs, (Statement)pstmt);
        }
        logger.info((Object)("Total Times:" + (System.currentTimeMillis() - start)));
        return temp.toArray(new KDMessage[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSented(KDMessage msg, Connection con) throws SQLException {
        String kdMsgId = msg.getId();
        PreparedStatement pstmt = null;
        try {
            pstmt = con.prepareStatement(SET_MSG_SENTED);
            pstmt.setTimestamp(1, new Timestamp(new Date().getTime()));
            pstmt.setString(2, kdMsgId);
            pstmt.executeUpdate();
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReplied(String kdMsgId, Connection con) throws SQLException {
        PreparedStatement pstmt = null;
        try {
            pstmt = con.prepareStatement(SET_MSG_REPLY);
            pstmt.setTimestamp(1, new Timestamp(new Date().getTime()));
            pstmt.setString(2, kdMsgId);
            pstmt.executeUpdate();
        }
        finally {
            SQLUtils.cleanup((Statement)pstmt);
        }
    }

    ArrayList generateSendUserMsgs(Message msg, UserInfo info, BizModuleConfig config) throws BOSException {
        SendUserMsgInfo sendmsg;
        if (!(info.getEmail() != null && !info.getEmail().trim().equals("") || info.getRtx() != null && !info.getRtx().trim().equals("") || info.getMobile() != null && !info.getMobile().trim().equals(""))) {
            return null;
        }
        String title = msg.getLocaleStringHeader("title", info.getMsgLocale());
        StringBuffer content = new StringBuffer(msg.getLocaleStringHeader("body", info.getMsgLocale()));
        String assignmentId = MessageConstant.getAssignmentId(msg);
        String userid = info.getUserid();
        if (!(title != null && title.trim().length() != 0 || content != null && content.toString().trim().length() != 0)) {
            return null;
        }
        ArrayList<SendUserMsgInfo> arr = new ArrayList<SendUserMsgInfo>();
        logger.debug((Object)("title:" + title));
        logger.debug((Object)("content:" + content));
        int msgType = msg.getIntHeader("type");
        boolean isRevertible = msgType == 10;
        boolean emailChannelOK = config.isEmailOK();
        boolean mobileChannelOK = config.isMobileOK();
        boolean rtxChannelOK = config.isRtxOK();
        int priority = msg.getIntHeader("priority");
        int mode = priority >= 20 ? info.getImportantMode() : info.getCommonMode();
        logger.debug((Object)("\u7528\u6237\u63a5\u6536\u4fe1\u606f\u65b9\u5f0f:" + mode + " \u7528\u6237ID:" + info.getUserid() + "\u7528\u6237\u624b\u673a:" + info.getMobile()));
        boolean byEmail = UserInfo.isByEmail(mode);
        boolean byMobile = UserInfo.isByMobile(mode);
        logger.debug((Object)("byEmail before" + byEmail));
        logger.debug((Object)("byMobile before" + byMobile));
        boolean byRtx = UserInfo.isByRtx(mode);
        boolean isSendMobile = msg.getBooleanheader(ISSENDMOBILEBYWF);
        boolean isSendEmail = msg.getBooleanheader(ISSENDEMAILEBYWF);
        byEmail = byEmail && isSendEmail;
        byMobile = byMobile && isSendMobile;
        String emailAddr = info.getEmail();
        String mobileAddr = info.getMobile();
        String rtxAddr = info.getRtx();
        logger.debug((Object)("byEmail" + byEmail));
        logger.debug((Object)("byMobile" + byMobile));
        if (emailChannelOK && byEmail && emailAddr != null && emailAddr.trim().length() > 0 && (title != null && title.trim().length() > 0 || content != null && content.toString().trim().length() > 0)) {
            Configuration bosConfig;
            ConfigurationItem sln;
            sendmsg = new SendUserMsgInfo();
            sendmsg.setAddress(emailAddr);
            sendmsg.setMsgType(2);
            boolean isRevertibleEmail = isRevertible;
            if (msg.getIntHeader("type") == 10 && (sln = (bosConfig = Configuration.getInstance()).getConfigItem("PortalInfo")) != null) {
                String isAllowEMailAudit = sln.getProperty("isAllowEMailAudit");
                if (isAllowEMailAudit == null || !isAllowEMailAudit.trim().equalsIgnoreCase("true")) {
                    isRevertibleEmail = false;
                }
                AppMsgUtil.appendOtherNotice(info.getMsgLocale(), content, sln);
            }
            arr.add(DefaultSendUserMsgDao.afterWork(sendmsg, title, content.toString(), priority, isRevertibleEmail, userid, assignmentId));
        }
        if (mobileChannelOK && byMobile && mobileAddr != null && mobileAddr.trim().length() > 0 && title != null && title.trim().length() > 0) {
            sendmsg = new SendUserMsgInfo();
            sendmsg.setAddress(mobileAddr);
            sendmsg.setMsgType(1);
            if (msg.getIntHeader("type") == 10) {
                title = title + ResourceBase.getString((String)RESOURCE, (String)"MOBILE_AUDIT_TIP", (Locale)info.getMsgLocale());
            }
            arr.add(DefaultSendUserMsgDao.afterWork(sendmsg, title, content.toString(), priority, isRevertible, userid, assignmentId));
        }
        if (rtxChannelOK && byRtx && rtxAddr != null && rtxAddr.trim().length() > 0 && title != null && title.trim().length() > 0) {
            sendmsg = new SendUserMsgInfo();
            sendmsg.setAddress(rtxAddr);
            sendmsg.setMsgType(3);
            arr.add(DefaultSendUserMsgDao.afterWork(sendmsg, title, content.toString(), priority, isRevertible, userid, assignmentId));
        }
        logger.debug((Object)("\u4ea7\u751f\u6d88\u606f\u6570\u76ee:" + arr.size()));
        logger.debug((Object)("\u81ea\u52a8\u751f\u6210\u7684\u6d88\u606f\u5217\u8868\u5927\u5c0f" + arr.size() + "\u5217\u8868\u5185\u5bb9\uff1a" + arr.toString()));
        return arr;
    }

    private static final SendUserMsgInfo afterWork(SendUserMsgInfo msgInfo, String title, String content, int priority, boolean isRevertible, String userid, String assignmentid) {
        BOSUuid id = BOSUuid.create((BOSObjectType)MsgConvert.SEND_MSG_TYPE);
        msgInfo.setId(id);
        msgInfo.setUserid(userid);
        msgInfo.setMsgId(Uuid.create().toString());
        msgInfo.setPriority(priority);
        msgInfo.setRevertible(isRevertible);
        msgInfo.setAssignmentId(assignmentid);
        msgInfo.setTitle(title);
        msgInfo.setContent(content);
        logger.info((Object)"\u5f53\u524d\u6267\u884c\uff1aDefaultSendMoMsgDao.afterWork");
        if (msgInfo.getCreateTime() == null) {
            msgInfo.setCreateTime(new Timestamp(new Date().getTime()));
        }
        return msgInfo;
    }

    private static final void saveMsgBatch(SendUserMsgInfo info, PreparedStatement pstmt) throws SQLException {
        logger.info((Object)"\u5f53\u524d\u6267\u884c\uff1aDefaultSendMoMsgDao.saveMsgBatch");
        pstmt.setString(1, info.getId().toString());
        pstmt.setString(2, info.getUserid());
        pstmt.setString(3, info.getMsgId());
        pstmt.setInt(4, info.getPriority());
        pstmt.setBoolean(5, info.isRevertible());
        pstmt.setString(6, info.getTitle());
        String content = info.getContent();
        if (content.length() == 0) {
            content = null;
        }
        pstmt.setString(7, content);
        pstmt.setString(8, info.getAddress());
        pstmt.setInt(9, info.getMsgType());
        pstmt.setTimestamp(10, info.getCreateTime());
        pstmt.setTimestamp(11, info.getSendTime());
        pstmt.setBoolean(12, info.isSented());
        pstmt.setString(13, info.getAssignmentId());
        pstmt.setString(14, info.getSrcMsgId());
        pstmt.setString(15, info.getRootMsgID());
        pstmt.addBatch();
    }
}

