/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile.msg.dao.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class SqlProvider {
    private static HashMap sqls = new HashMap();
    public static boolean debug = true;
    private static final String SQL_DEF_FILE = "com/kingdee/eas/mobile/msg/dao/jdbc/SqlSentence.data";
    private static final String SQLNODE = "sql";
    private static final String IDATTR = "id";
    private static final Logger logger = Logger.getLogger(SqlProvider.class);

    public static final String getSql(String key) {
        if (sqls.get(key) == null) {
            throw new RuntimeException("SQL  id " + key + " is undefined !");
        }
        return (String)sqls.get(key);
    }

    public static void printAllSql() {
        for (String string : sqls.keySet()) {
        }
    }

    public static String parasSql(String sql, Object[] objs) {
        if (!debug) {
            return sql;
        }
        int offset = 0;
        int length = sql.length();
        StringBuffer buf = new StringBuffer();
        for (int charPos = 0; offset < objs.length && charPos < length; ++charPos) {
            char iChar = sql.charAt(charPos);
            if (iChar != '?' && iChar != ' ') {
                buf.append(iChar);
                continue;
            }
            Object obj = objs[offset];
            if (obj instanceof String) {
                buf.append("'" + obj.toString() + "'");
            } else {
                buf.append(obj);
            }
            ++offset;
        }
        return buf.toString();
    }

    private static final void loadSql() {
        InputStream ins = SqlProvider.class.getClassLoader().getResourceAsStream(SQL_DEF_FILE);
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        try {
            doc = builder.build(ins);
        }
        catch (JDOMException e) {
            logger.error((Object)"Parse XML File 'com/kingdee/eas/mobile/msg/dao/jdbc/SqlSentence.data Error", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"Parse XML File 'com/kingdee/eas/mobile/msg/dao/jdbc/SqlSentence.data IO Error");
        }
        if (doc == null) {
            return;
        }
        Element root = doc.getRootElement();
        List childs = root.getChildren(SQLNODE);
        int n = childs.size();
        for (int i = 0; i < n; ++i) {
            Element e = (Element)childs.get(i);
            String id = e.getAttributeValue(IDATTR);
            String sqlTxt = e.getText().trim();
            sqls.put(id, sqlTxt);
        }
    }

    public static void main(String[] args) {
        SqlProvider.printAllSql();
        String s = SqlProvider.getSql("insertAisConfig");
        Object[] objs = new Object[]{"12345", "ais", "192.168.19.106", new Integer(5100), new Integer(7)};
        System.out.println(SqlProvider.parasSql(s, objs));
    }

    static {
        SqlProvider.loadSql();
    }
}

