/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.base.license;

import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.LicenseUserInfo;
import com.kingdee.eas.base.license.client.LicenseController;
import com.kingdee.eas.base.reportmeta.base.license.EXTLicenseException;
import com.kingdee.eas.base.reportmeta.base.license.ILicenseChecker;
import com.kingdee.eas.common.client.SysContext;
import org.apache.log4j.Logger;

public class ReportCenterLicenseClientChecker
implements ILicenseChecker {
    private String _moduleName;
    private boolean _hadChecked;
    private static Logger _log = Logger.getLogger(ReportCenterLicenseClientChecker.class);

    public ReportCenterLicenseClientChecker(String moduleName) {
        this._moduleName = moduleName;
    }

    public boolean checkLicense() throws EXTLicenseException {
        if (!this._hadChecked) {
            LicenseController licController = LicenseController.getInstance();
            LicenseUserInfo userInfo = (LicenseUserInfo)SysContext.getSysContext().getProperty((Object)"License.UserInfo");
            try {
                int flag = licController.requestLicense(userInfo, this._moduleName);
                switch (flag) {
                    case 4: {
                        throw EXTLicenseException.REQUEST_INVALID_EXCEPTION;
                    }
                    case 2: {
                        throw EXTLicenseException.REQUEST_NO_SURPLUS_EXCEPTION;
                    }
                    case 1: {
                        return true;
                    }
                }
            }
            catch (LicenseException e) {
                _log.error((Object)"EXT: \u5ba2\u6237\u7aef Check License\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                EXTLicenseException.wrap((Exception)((Object)e));
            }
            this._hadChecked = true;
        }
        return false;
    }

    public boolean releaseLicense() throws EXTLicenseException {
        if (this._hadChecked) {
            LicenseController licController = LicenseController.getInstance();
            String sessionID = SysContext.getSysContext().getSessionID();
            try {
                licController.releaseLicense(sessionID, this._moduleName);
            }
            catch (LicenseException e) {
                _log.error((Object)"EXT: \u5ba2\u6237\u7aef\u91ca\u653eLicense\u5931\u8d25", (Throwable)e);
                throw EXTLicenseException.wrap((Exception)((Object)e));
            }
            this._hadChecked = false;
        }
        return false;
    }

    public void setModuleName(String moduleName) {
        this._moduleName = moduleName;
    }
}

