/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlreport.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.STConverter;
import com.kingdee.bos.ctrl.ext.fulfil.ExecutorUtil;
import com.kingdee.bos.ctrl.ext.fulfil.SnapReportControlModel;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.util.file.KDFException;
import com.kingdee.bos.ctrl.kdf.util.kdfsax.KDFSAXException;
import com.kingdee.bos.ctrl.kds.io.kds.BookToKDSBook;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.service.job.core.JobLog;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.reportmeta.ctrlreport.AttemperProxyFactory;
import com.kingdee.eas.base.reportmeta.ctrlreport.AttemperProxyInfo;
import com.kingdee.eas.base.reportmeta.ctrlreport.ByteContentInfo;
import com.kingdee.eas.base.reportmeta.ctrlreport.IAttemperProxy;
import com.kingdee.eas.base.reportmeta.ctrlreport.IReportAttemper;
import com.kingdee.eas.base.reportmeta.ctrlreport.ReportAttemperFactory;
import com.kingdee.eas.base.reportmeta.ctrlreport.ReportAttemperInfo;
import com.kingdee.eas.base.reportmeta.ctrlreport.ReportSnapInfo;
import com.kingdee.eas.base.reportmeta.ctrlreport.app.AbstractReportAttemperControllerBean;
import com.kingdee.eas.base.reportmeta.ctrlreport.bo.PermissionBO;
import com.kingdee.eas.base.reportmeta.ctrlreport.bo.ReportAttemperBO;
import com.kingdee.eas.base.reportmeta.ctrlreport.bo.ReportSnapBO;
import com.kingdee.eas.base.reportmeta.ctrlreport.bo.SendMailBO;
import com.kingdee.eas.base.reportmeta.ctrlreport.data.PermissionKind;
import com.kingdee.eas.base.reportmeta.ctrlreport.email.Attachment;
import com.kingdee.eas.base.reportmeta.ctrlreport.email.MailInfo;
import com.kingdee.eas.base.reportmeta.ctrlreport.email.SendMailInfo;
import com.kingdee.eas.base.reportmeta.ctrlreport.email.SmtpSender;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.base.reportmeta.ctrlreport.util.ExtStringUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.factory.FacadeFactory;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.ExtContextUtils;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.RunReportParam;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.WebParamAdapter;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgSwitchFacadeFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.org.TransportOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;
import sun.misc.BASE64Decoder;

public class ReportAttemperControllerBean
extends AbstractReportAttemperControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.reportmeta.ctrlreport.app.ReportAttemperControllerBean");

    protected boolean _release(Context ctx, String id, String strLocal) throws BOSException {
        boolean isSaveHyplink;
        HashMap mapInfo = null;
        Book book = null;
        ArrayList proxyList = null;
        String freportid = null;
        String ffilterxml = null;
        String fsnaptype = null;
        HashMap mapCustomParam = null;
        try {
            mapInfo = ReportAttemperBO.getReportAttemperInfoByID(ctx, id, strLocal);
            if (mapInfo.isEmpty()) {
                String fjobprocessdefid = CtrlReportUtil.getObjectString(mapInfo.get("fjobprocessdefid"));
                this.writeErrorLog(ctx, fjobprocessdefid, "\u8c03\u5ea6\u4fe1\u606f\u5df2\u5220\u9664", "\u8c03\u5ea6\u4fe1\u606f\u5df2\u5220\u9664", "\u8be5\u8c03\u5ea6\u5df2\u7ecf\u4f5c\u5e9f\uff0c\u8bf7\u624b\u5de5\u7981\u7528", null);
                return false;
            }
            freportid = CtrlReportUtil.getObjectString(mapInfo.get("freportid"));
            ffilterxml = CtrlReportUtil.getObjectString(mapInfo.get("ffilterxml"));
            fsnaptype = CtrlReportUtil.getObjectString(mapInfo.get("fsnaptype"));
            boolean bl = isSaveHyplink = ((Number)mapInfo.get("fsavehyplink")).intValue() == 1;
            if (fsnaptype.equals("")) {
                fsnaptype = "-1";
            }
            mapCustomParam = RunReportParam.setExecuteParam(null, ffilterxml);
            proxyList = ReportAttemperBO.getAttemperProxyList(ctx, id, strLocal);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            String fjobprocessdefid = CtrlReportUtil.getObjectString(mapInfo.get("fjobprocessdefid"));
            this.writeErrorLog(ctx, fjobprocessdefid, ex.getMessage(), "\u8c03\u5ea6\u5931\u8d25", "\u8c03\u5ea6\u5931\u8d25", ex);
            this.sendMail(ctx, book, mapInfo, false, "", "");
            return false;
        }
        SnapReportControlModel controlModel = new SnapReportControlModel();
        controlModel.setSaveHyplink(isSaveHyplink);
        Iterator it = proxyList.iterator();
        while (it.hasNext()) {
            String userName = "";
            String orgName = "";
            try {
                String fsavetype;
                HashMap proxyMap = (HashMap)it.next();
                String userID = CtrlReportUtil.getObjectString(proxyMap.get("fuserid"));
                userName = CtrlReportUtil.getObjectString(proxyMap.get("user_name"));
                String orgID = CtrlReportUtil.getObjectString(proxyMap.get("forgid"));
                orgName = CtrlReportUtil.getObjectString(proxyMap.get("orgname"));
                boolean isPermission = PermissionBO.hasDataPermissionByReportId(ctx, userID, orgID, freportid, PermissionKind.VIEW);
                String fjobprocessdefid = CtrlReportUtil.getObjectString(mapInfo.get("fjobprocessdefid"));
                String reportname = CtrlReportUtil.getObjectString(mapInfo.get("reportname"));
                if (!isPermission) {
                    String errMsg = "\u7528\u6237:" + userID + "\uff0c " + userName + "\r\n\u7ec4\u7ec7\uff1a" + orgID + "\uff0c " + orgName + "\uff0c\u6ca1\u6709\u67e5\u770b\u62a5\u8868\u7684\u6743\u9650\uff1a" + reportname;
                    this.writeErrorLog(ctx, fjobprocessdefid, errMsg, "\u8c03\u5ea6\u5931\u8d25", "\u8c03\u5ea6\u5931\u8d25", null);
                    continue;
                }
                HashMap exitsMap = null;
                Date reportDate = new Date();
                String currentSnapDate = CtrlReportUtil.formatDateTime(reportDate);
                int iSnapType = Integer.parseInt(fsnaptype);
                String snapFlag = ReportSnapBO.getSnapFlagByType(iSnapType, currentSnapDate);
                if (iSnapType != -1 && iSnapType != 0 && (exitsMap = ReportSnapBO.existSameTypeSnap(null, null)) != null && (fsavetype = CtrlReportUtil.getObjectString(mapInfo.get("fsavetype"))).equals("1")) {
                    String errMsg = "\u7ec4\u7ec7\uff1a" + orgID + "\uff0c " + orgName + "\uff0c\u5feb\u7167\u5b58\u5728\uff0c\u6267\u884c\u65f6\u5ffd\u7565\uff1a" + reportname;
                    this.writeErrorLog(ctx, fjobprocessdefid, errMsg, "\u8c03\u5ea6\u5931\u8d25", "\u8c03\u5ea6\u5931\u8d25", null);
                    continue;
                }
                HashMap mapSwitchOrg = OrgSwitchFacadeFactory.getLocalInstance((Context)ctx).getSwitchOrgs(orgID);
                HashMap mapSystemParam = this.putSystemParam(mapSwitchOrg, userID, userName);
                mapCustomParam.putAll(mapSystemParam);
                book = this.execute(ctx, freportid, mapCustomParam);
                byte[] data = ExecutorUtil.generateShapShot((Book)book, (SnapReportControlModel)controlModel);
                this.saveSnap(ctx, mapInfo, data, strLocal, exitsMap, reportDate, snapFlag);
                this.sendMail(ctx, book, mapInfo, true, userName, orgName);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                String fjobprocessdefid = CtrlReportUtil.getObjectString(mapInfo.get("fjobprocessdefid"));
                this.writeErrorLog(ctx, fjobprocessdefid, ex.getMessage(), "\u8c03\u5ea6\u5931\u8d25", "\u8c03\u5ea6\u5931\u8d25", ex);
                this.sendMail(ctx, book, mapInfo, false, userName, orgName);
                return false;
            }
        }
        return true;
    }

    private HashMap putSystemParam(HashMap mapSwitchOrg, String userID, String userName) {
        String systemTimeMillis = "-1";
        HashMap mapDesignParma = new HashMap();
        if (null != mapSwitchOrg.get(OrgType.Admin)) {
            AdminOrgUnitInfo adminInfo = (AdminOrgUnitInfo)mapSwitchOrg.get(OrgType.Admin);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentAdminUnitID", adminInfo.getId());
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentAdminUnitName", adminInfo.getName());
        } else {
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentAdminUnitID", systemTimeMillis);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentAdminUnitName", systemTimeMillis);
        }
        if (null != mapSwitchOrg.get(OrgType.CostCenter)) {
            CostCenterOrgUnitInfo costCenterInfo = (CostCenterOrgUnitInfo)mapSwitchOrg.get(OrgType.CostCenter);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentCostUnitID", costCenterInfo.getId());
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentCostUnitName", costCenterInfo.getName());
        } else {
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentCostUnitID", systemTimeMillis);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentCostUnitName", systemTimeMillis);
        }
        if (null != mapSwitchOrg.get(OrgType.ControlUnit)) {
            CtrlUnitInfo cuInfo = (CtrlUnitInfo)mapSwitchOrg.get(OrgType.ControlUnit);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentCtrlUnitID", cuInfo.getId());
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentCtrlUnitName", cuInfo.getName());
        } else {
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentCtrlUnitID", systemTimeMillis);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentCtrlUnitName", systemTimeMillis);
        }
        if (null != mapSwitchOrg.get(OrgType.Company)) {
            CompanyOrgUnitInfo fiInfo = (CompanyOrgUnitInfo)mapSwitchOrg.get(OrgType.Company);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentFIUnitID", fiInfo.getId());
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentFIUnitName", fiInfo.getName());
        } else {
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentFIUnitID", systemTimeMillis);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentFIUnitName", systemTimeMillis);
        }
        if (null != mapSwitchOrg.get("CurOU")) {
            FullOrgUnitInfo ouInfo = (FullOrgUnitInfo)mapSwitchOrg.get("CurOU");
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentOrgUnitID", ouInfo.getId());
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentOrgUnitName", ouInfo.getName());
        } else {
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentOrgUnitID", systemTimeMillis);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentOrgUnitName", systemTimeMillis);
        }
        if (null != mapSwitchOrg.get(OrgType.ProfitCenter)) {
            ProfitCenterOrgUnitInfo profitCenterInfo = (ProfitCenterOrgUnitInfo)mapSwitchOrg.get(OrgType.ProfitCenter);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentProfitUnitID", profitCenterInfo.getId());
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentProfitUnitName", profitCenterInfo.getName());
        } else {
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentProfitUnitID", systemTimeMillis);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentProfitUnitName", systemTimeMillis);
        }
        if (null != mapSwitchOrg.get(OrgType.Purchase)) {
            PurchaseOrgUnitInfo purchaseOrgInfo = (PurchaseOrgUnitInfo)mapSwitchOrg.get(OrgType.Purchase);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentPurchaseUnitID", purchaseOrgInfo.getId());
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentPurchaseUnitName", purchaseOrgInfo.getName());
        } else {
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentPurchaseUnitID", systemTimeMillis);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentPurchaseUnitName", systemTimeMillis);
        }
        if (null != mapSwitchOrg.get(OrgType.Sale)) {
            SaleOrgUnitInfo saleOrgInfo = (SaleOrgUnitInfo)mapSwitchOrg.get(OrgType.Sale);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentSaleUnitID", saleOrgInfo.getId());
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentSaleUnitName", saleOrgInfo.getName());
        } else {
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentSaleUnitID", systemTimeMillis);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentSaleUnitName", systemTimeMillis);
        }
        if (null != mapSwitchOrg.get(OrgType.Storage)) {
            StorageOrgUnitInfo storageOrgInfo = (StorageOrgUnitInfo)mapSwitchOrg.get(OrgType.Storage);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentStorageUnitID", storageOrgInfo.getId());
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentStorageUnitName", storageOrgInfo.getName());
        } else {
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentStorageUnitID", systemTimeMillis);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentStorageUnitName", systemTimeMillis);
        }
        RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentUserInfoID", userID);
        RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentUserInfoName", userName);
        RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentUserPersonID", systemTimeMillis);
        RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentUserPersonName", systemTimeMillis);
        if (null != mapSwitchOrg.get(OrgType.HRO)) {
            HROrgUnitInfo hrOrgInfo = (HROrgUnitInfo)mapSwitchOrg.get(OrgType.HRO);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentHRUnitID", hrOrgInfo.getId());
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentHRUnitName", hrOrgInfo.getName());
        } else {
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentHRUnitID", systemTimeMillis);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentHRUnitName", systemTimeMillis);
        }
        if (null != mapSwitchOrg.get(OrgType.Transport)) {
            TransportOrgUnitInfo transportOrgInfo = (TransportOrgUnitInfo)mapSwitchOrg.get(OrgType.Transport);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentTransportUnitID", transportOrgInfo.getId());
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentTransportUnitName", transportOrgInfo.getName());
        } else {
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentTransportUnitID", systemTimeMillis);
            RunReportParam.putParamsMap(mapDesignParma, "ExtRptCurrentTransportUnitName", systemTimeMillis);
        }
        return mapDesignParma;
    }

    private void writeErrorLog(Context ctx, String fjobprocessdefid, String description, String reason, String advice, Throwable e) {
        String fjobinstid = "";
        try {
            HashMap map = ReportAttemperBO.getJobInstInfo(ctx, fjobprocessdefid);
            fjobinstid = CtrlReportUtil.getObjectString(map.get("fjobinstid"));
            if (!fjobinstid.equals("")) {
                JobLog jobLog = new JobLog(JobLog.Type.Error, description, reason, advice, e, null);
                jobLog.asyncSave(ctx, fjobinstid);
            }
        }
        catch (Exception e1) {
            logger.error((Object)e1);
        }
    }

    private Book execute(Context ctx, String reportID, HashMap mapDesignParam) throws IOException, KDFException, KDFSAXException, Exception {
        WebParamAdapter wpa = new WebParamAdapter(ctx, reportID);
        wpa.setSchedule(true);
        wpa.executeSchedule(mapDesignParam);
        Book book = wpa.getBook();
        return book;
    }

    private void saveSnap(Context ctx, HashMap mapInfo, byte[] data, String strLocal, HashMap exitsMap, Date reportDate, String snapFlag) throws BOSException, EASBizException, SQLException {
        LanguageInfo li;
        int i;
        int z;
        LanguageCollection lc;
        String freportid = CtrlReportUtil.getObjectString(mapInfo.get("freportid"));
        String reportname = CtrlReportUtil.getObjectString(mapInfo.get("reportname"));
        String fsystemid = CtrlReportUtil.getObjectString(mapInfo.get("fsystemid"));
        String forgid = CtrlReportUtil.getObjectString(mapInfo.get("forgid"));
        ReportSnapInfo snapInfo = new ReportSnapInfo();
        if (exitsMap != null) {
            snapInfo.setId(BOSUuid.read((String)CtrlReportUtil.getObjectString(exitsMap.get("fid"))));
        }
        snapInfo.setReportID(BOSUuid.read((String)freportid));
        snapInfo.setSystemID(fsystemid);
        snapInfo.setOrgID(forgid);
        snapInfo.setReportTime(new Timestamp(reportDate.getTime()));
        snapInfo.setSnapFlag(snapFlag);
        if (exitsMap == null) {
            int intCount = ReportSnapBO.getReportSnapInfoCount(ctx, freportid, fsystemid, forgid);
            String snapname = reportname;
            if (intCount > 0) {
                boolean flagExist;
                while (flagExist = ReportSnapBO.isexist(ctx, null, fsystemid, snapname = reportname + intCount, strLocal, forgid)) {
                    ++intCount;
                }
            }
            HashMap<String, String> mapSnapName = new HashMap<String, String>();
            mapSnapName.put("l1", "");
            mapSnapName.put("l2", STConverter.tc2sc((String)snapname));
            mapSnapName.put("l3", STConverter.sc2tc((String)snapname));
            lc = ExtContextUtils.getMetaDataLoader(ctx).getSolution().getLanguages();
            z = lc.size();
            for (i = 0; i < z; ++i) {
                li = lc.get(i);
                String alias = (String)mapSnapName.get(li.getLocale().toString());
                snapInfo.setName(alias, li.getLocale());
            }
        }
        String ftitle = CtrlReportUtil.getObjectString(mapInfo.get("ftitle"));
        String fmemo = CtrlReportUtil.formatDateTime(reportDate) + " \u81ea\u52a8\u8c03\u5ea6\uff1a" + ftitle + " \u751f\u6210\uff01";
        HashMap<String, String> mapMemo = new HashMap<String, String>();
        mapMemo.put("l1", "");
        mapMemo.put("l2", STConverter.tc2sc((String)fmemo));
        mapMemo.put("l3", STConverter.sc2tc((String)fmemo));
        lc = ExtContextUtils.getMetaDataLoader(ctx).getSolution().getLanguages();
        z = lc.size();
        for (i = 0; i < z; ++i) {
            li = lc.get(i);
            String memo = (String)mapMemo.get(li.getLocale().toString());
            snapInfo.setMemo(memo, li.getLocale());
        }
        ByteContentInfo byteInfo = new ByteContentInfo();
        byteInfo.setId(snapInfo.getId());
        byteInfo.setContent(data);
        byteInfo.setLength(data.length);
        if (null != snapInfo.getId()) {
            ReportSnapBO.update(ctx, snapInfo, byteInfo);
        } else {
            ReportSnapBO.insert(ctx, snapInfo, byteInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] exportToXsl(Context ctx, Book book, String fjobprocessdefid) {
        ByteArrayOutputStream os = null;
        byte[] data = null;
        try {
            KDSBook kdsbook = BookToKDSBook.traslate((Book)book, null);
            ExportManager em = new ExportManager();
            em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_TRUE, (Object)"TRUE");
            em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_FALSE, (Object)"FALSE");
            em.setExporterParmeter(ExporterParameter.EXPORT_FORMAT, (Object)"true");
            em.setExporterParmeter(ExporterParameter.EXPORT_STYLE, (Object)"true");
            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"false");
            em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"false");
            em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
            os = new ByteArrayOutputStream(102400);
            em.exportToExcelStream(kdsbook, (OutputStream)os);
            data = os.toByteArray();
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.writeErrorLog(ctx, fjobprocessdefid, e.getMessage(), "\u5bfc\u51faEXCEL\u5931\u8d25", "\u5bfc\u51faEXCEL\u5931\u8d25", e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
        }
        return data;
    }

    private void sendMail(Context ctx, Book book, HashMap mapInfo, boolean isSuccess, String userName, String orgName) {
        String femail = CtrlReportUtil.getObjectString(mapInfo.get("femail"));
        if (femail.equals("")) {
            return;
        }
        String fmsgsendtype = CtrlReportUtil.getObjectString(mapInfo.get("fmsgsendtype"));
        if (fmsgsendtype.equals("1") && !isSuccess) {
            return;
        }
        if (fmsgsendtype.equals("2") && isSuccess) {
            return;
        }
        String fsendmail = CtrlReportUtil.getObjectString(mapInfo.get("fsendmail"));
        if (fsendmail.equals("")) {
            return;
        }
        String strResult = "\u6210\u529f";
        if (!isSuccess) {
            strResult = "\u5931\u8d25";
        }
        femail = ExtStringUtil.replace(femail, "\r", "");
        femail = ExtStringUtil.replace(femail, "\n", "");
        femail = ExtStringUtil.replace(femail, "\uff0c", ";");
        femail = ExtStringUtil.replace(femail, ",", ";");
        femail = ExtStringUtil.replace(femail, "\uff1b", ";");
        String fjobprocessdefid = CtrlReportUtil.getObjectString(mapInfo.get("fjobprocessdefid"));
        try {
            byte[] data;
            SendMailInfo sendMailInfo = SendMailBO.getSendMailInfoFromCache(ctx, fsendmail);
            String mailHost = sendMailInfo.getMailHost().trim();
            String mailUser = sendMailInfo.getMailUser().trim();
            String mailAddress = sendMailInfo.getMailAddress();
            String[] toAddress = femail.split(";");
            String mailPassword = new String(new BASE64Decoder().decodeBuffer(sendMailInfo.getMailPassword()));
            MailInfo mailInfo = new MailInfo();
            mailInfo.setSmtpServer(mailHost);
            mailInfo.setSmtpPort(25);
            mailInfo.setMailUserName(mailUser);
            mailInfo.setMailPassword(mailPassword);
            mailInfo.setMailTo(toAddress);
            mailInfo.setMailFrom(mailAddress);
            mailInfo.setMailShowTo(femail);
            mailInfo.setMailShowFrom(mailAddress);
            String reportname = CtrlReportUtil.getObjectString(mapInfo.get("reportname"));
            mailInfo.setMailSubject("\u6269\u5c55\u62a5\u8868\u81ea\u52a8\u8c03\u5ea6\uff1a" + reportname);
            String ftitle = CtrlReportUtil.getObjectString(mapInfo.get("ftitle"));
            String content = "\u6267\u884c\u8c03\u5ea6 " + strResult + "\uff0c\u90ae\u4ef6\u5185\u5bb9\u6765\u81ea\u4e8e\u81ea\u52a8\u8c03\u5ea6\u7684\u6267\u884c\u7ed3\u679c\r\n";
            content = content + "\u8c03\u5ea6\u540d\u79f0\uff1a" + ftitle + "\r\n";
            content = content + "\u62a5\u8868\u540d\u79f0\uff1a" + reportname + "\r\n";
            content = content + "\u8c03\u5ea6\u4eba\u5458\uff1a" + userName + "\r\n";
            content = content + "\u8c03\u5ea6\u673a\u6784\uff1a" + orgName + "\r\n";
            mailInfo.setMailBody(content);
            String fistakefile = CtrlReportUtil.getObjectString(mapInfo.get("fistakefile"));
            if (fistakefile.equals("1") && isSuccess && (data = this.exportToXsl(ctx, book, fjobprocessdefid)) != null) {
                Attachment attach1 = new Attachment(reportname + ".xls", "application/vnd.ms-excel", data);
                mailInfo.setAttachments(new Attachment[]{attach1});
            }
            SmtpSender.sendMail(mailInfo, 0);
            logger.error((Object)"send mail finish");
        }
        catch (Exception ex) {
            logger.error((Object)"ex");
            this.writeErrorLog(ctx, fjobprocessdefid, ex.getMessage(), "\u90ae\u4ef6\u53d1\u9001\u5931\u8d25", "\u90ae\u4ef6\u53d1\u9001\u5931\u8d25", ex);
        }
    }

    public RptParams refreshCache(Context ctx, RptParams param) {
        try {
            SendMailBO.cacheSendMail(ctx);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return new RptParams();
    }

    public RptParams testLinkMail(Context ctx, RptParams param) {
        RptParams params_r = new RptParams();
        SendMailInfo vo = (SendMailInfo)param.getObject("SendMailInfo");
        try {
            String to = vo.getMailAddress();
            String[] toAddress = new String[]{to};
            MailInfo mailInfo = new MailInfo();
            mailInfo.setSmtpServer(vo.getMailHost());
            mailInfo.setSmtpPort(25);
            mailInfo.setMailUserName(vo.getMailUser());
            mailInfo.setMailPassword(vo.getMailPassword());
            mailInfo.setMailTo(toAddress);
            mailInfo.setMailFrom(to);
            mailInfo.setMailShowTo(to);
            mailInfo.setMailShowFrom(to);
            mailInfo.setMailSubject("\u6269\u5c55\u62a5\u8868\u90ae\u4ef6 \u6d4b\u8bd5\u6d88\u606f");
            mailInfo.setMailBody("\u5728\u6d4b\u8bd5\u60a8\u7684 POP3 \u5e10\u6237\u8bbe\u7f6e\u65f6\uff0c\u6269\u5c55\u62a5\u8868\u7684\u5e10\u6237\u7ba1\u7406\u5668\u5c06\u4f1a\u81ea\u52a8\u53d1\u751f\u8be5\u7535\u5b50\u90ae\u4ef6\uff01");
            boolean isSendSuc = SmtpSender.sendMail(mailInfo, 0);
            if (isSendSuc) {
                params_r.setString("Message", "\u9a8c\u8bc1\u901a\u8fc7\uff0c\u90ae\u4ef6\u5df2\u6210\u529f\u53d1\u9001\u5230 " + to);
            } else {
                params_r.setString("Message", "\u6d4b\u8bd5\u4e0d\u901a\u8fc7");
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            params_r.setString("Message", "\u6d4b\u8bd5\u4e0d\u901a\u8fc7\uff1a" + ex.getMessage());
        }
        return params_r;
    }

    public RptParams insert(Context ctx, RptParams param) {
        ReportAttemperInfo attemperInfo = (ReportAttemperInfo)param.getObject("ReportAttemperInfo");
        AttemperProxyInfo[] proxyInfos = (AttemperProxyInfo[])param.getObject("AttemperProxyInfos");
        RptParams params_r = new RptParams();
        try {
            IReportAttemper factory = ReportAttemperFactory.getLocalInstance(ctx);
            IObjectPK newPk = factory.addnew(attemperInfo);
            String attemperID = newPk.toString();
            BOSUuid buAttemperID = BOSUuid.read((String)attemperID);
            for (int i = 0; i < proxyInfos.length; ++i) {
                AttemperProxyInfo proxyInfo = proxyInfos[i];
                proxyInfo.setAttemperID(buAttemperID);
                IAttemperProxy factoryProxy = AttemperProxyFactory.getLocalInstance(ctx);
                factoryProxy.addnew(proxyInfo);
            }
            params_r.setString("Flag", attemperID);
        }
        catch (Error er) {
            logger.error((Object)"insert:", (Throwable)er);
            params_r.setObject("error", (Object)er);
        }
        catch (Exception e) {
            logger.error((Object)"insert:", (Throwable)e);
            params_r.setObject("exception", (Object)e);
        }
        return params_r;
    }

    public RptParams update(Context ctx, RptParams param) {
        ReportAttemperInfo attemperInfo = (ReportAttemperInfo)param.getObject("ReportAttemperInfo");
        AttemperProxyInfo[] proxyInfos = (AttemperProxyInfo[])param.getObject("AttemperProxyInfos");
        RptParams params_r = new RptParams();
        try {
            IReportAttemper factory = ReportAttemperFactory.getLocalInstance(ctx);
            BOSUuid bAtttetmpID = attemperInfo.getId();
            String attempID = bAtttetmpID.toString();
            ObjectUuidPK pK = new ObjectUuidPK("id", bAtttetmpID);
            factory.update((IObjectPK)pK, attemperInfo);
            RptParams pr = new RptParams();
            ArrayList<String> queryValue = new ArrayList<String>();
            queryValue.add(attempID);
            String sql = "delete T_RM_AttemperProxy where FAttemperID = ?";
            pr.setString("sql", sql);
            pr.setObject("lstValue", queryValue);
            pr.setString("MethodName", "maintainRecord");
            FacadeFactory.commonExecuteRequired(ctx, pr);
            for (int i = 0; i < proxyInfos.length; ++i) {
                AttemperProxyInfo proxyInfo = proxyInfos[i];
                IAttemperProxy factoryProxy = AttemperProxyFactory.getLocalInstance(ctx);
                factoryProxy.addnew(proxyInfo);
            }
        }
        catch (Error er) {
            logger.error((Object)"insert:", (Throwable)er);
            params_r.setObject("error", (Object)er);
        }
        catch (Exception e) {
            logger.error((Object)"insert:", (Throwable)e);
            params_r.setObject("exception", (Object)e);
        }
        return params_r;
    }

    public RptParams delete(Context ctx, RptParams param) {
        ReportAttemperInfo[] attemperInfos = (ReportAttemperInfo[])param.getObject("ReportAttemperInfos");
        RptParams params_r = new RptParams();
        try {
            for (int i = 0; i < attemperInfos.length; ++i) {
                ReportAttemperInfo attemperInfo = attemperInfos[i];
                BOSUuid bid = attemperInfo.getId();
                ObjectUuidPK pK = new ObjectUuidPK("id", bid);
                IReportAttemper factory = ReportAttemperFactory.getLocalInstance(ctx);
                factory.delete((IObjectPK)pK);
                IAttemperProxy factoryProxy = AttemperProxyFactory.getLocalInstance(ctx);
                factoryProxy.delete((IObjectPK)pK);
                String jobProcessDefID = CtrlReportUtil.getObjectString(attemperInfo.getJobProcessDefID());
                if (jobProcessDefID.equals("")) continue;
                RptParams pr = new RptParams();
                ArrayList<String> queryValue = new ArrayList<String>();
                queryValue.add(jobProcessDefID);
                String sql = "delete T_JOB_TRIGGER where fjobdefid = ?";
                pr.setString("sql", sql);
                pr.setObject("lstValue", queryValue);
                pr.setString("MethodName", "maintainRecord");
                FacadeFactory.commonExecuteRequired(ctx, pr);
                pr.clear();
                sql = "delete T_JOB_DEF where fjobdefid = ?";
                pr.setString("sql", sql);
                pr.setObject("lstValue", queryValue);
                pr.setString("MethodName", "maintainRecord");
                FacadeFactory.commonExecuteRequired(ctx, pr);
            }
        }
        catch (Error er) {
            logger.error((Object)"insert:", (Throwable)er);
            params_r.setObject("error", (Object)er);
        }
        catch (Exception e) {
            logger.error((Object)"insert:", (Throwable)e);
            params_r.setObject("exception", (Object)e);
        }
        return params_r;
    }
}

