/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlreport.bo;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.IMainMenuItem;
import com.kingdee.eas.base.permission.MainMenuItemCollection;
import com.kingdee.eas.base.permission.MainMenuItemFactory;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.uiframe.MainFunctionMenuFactory;
import com.kingdee.eas.base.uiframe.MenuCacheFactory;
import org.apache.log4j.Logger;

public class MainMenuItemBO {
    private static final Logger logger = Logger.getLogger(MainMenuItemBO.class);
    MainMenuItemCollection menuItemCollection;
    IMainMenuItem menu = null;

    public MainMenuItemBO(Context ctx) {
        try {
            this.menu = ctx != null ? MainMenuItemFactory.getLocalInstance((Context)ctx) : MainMenuItemFactory.getRemoteInstance();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public static String getMenuPathText(Context ctx, String menuId) {
        StringBuffer sbNumber = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        try {
            IMainMenuItem menu = null;
            menu = ctx != null ? MainMenuItemFactory.getLocalInstance((Context)ctx) : MainMenuItemFactory.getRemoteInstance();
            ObjectUuidPK menuPk = new ObjectUuidPK("id", new MainMenuItemInfo().getBOSType());
            menuPk.setKeyValue("id", (Object)menuId);
            while (true) {
                MainMenuItemInfo menuItem = menu.getMainMenuItemInfo((IObjectPK)menuPk);
                sbNumber.insert(0, "/" + menuItem.getNumber());
                sb.insert(0, "/" + menuItem.getName());
                menuItem = menuItem.getParent();
                if (menuItem != null) {
                    menuPk.setKeyValue("id", (Object)menuItem.getId().toString());
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception:", (Throwable)e);
        }
        return sb.toString();
    }

    public MainMenuItemInfo getMainMenuItemInfoByID(String id) {
        MainMenuItemInfo menuItem = null;
        try {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.EQUALS));
            entityViewInfo.setFilter(filterInfo);
            MainMenuItemCollection menuItemCollection = this.menu.getMainMenuItemCollection(entityViewInfo);
            if (menuItemCollection != null && !menuItemCollection.isEmpty()) {
                MainMenuItemInfo[] infoes = new MainMenuItemInfo[menuItemCollection.size()];
                int length = infoes.length;
                for (int i = 0; i < length; ++i) {
                    menuItem = menuItemCollection.get(i);
                }
            }
            return menuItem;
        }
        catch (Exception e) {
            logger.error((Object)"getMainMenuItemInfo Exception:", (Throwable)e);
            return menuItem;
        }
    }

    public MainMenuItemInfo getMainMenuItemInfo(String longNumber) {
        MainMenuItemInfo menuItem = null;
        try {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("longNumber", (Object)longNumber, CompareType.EQUALS));
            entityViewInfo.setFilter(filterInfo);
            MainMenuItemCollection menuItemCollection = this.menu.getMainMenuItemCollection(entityViewInfo);
            if (menuItemCollection != null && !menuItemCollection.isEmpty()) {
                MainMenuItemInfo[] infoes = new MainMenuItemInfo[menuItemCollection.size()];
                int length = infoes.length;
                for (int i = 0; i < length; ++i) {
                    menuItem = menuItemCollection.get(i);
                }
            }
            return menuItem;
        }
        catch (Exception e) {
            logger.error((Object)"getMainMenuItemInfo Exception:", (Throwable)e);
            return menuItem;
        }
    }

    public MainMenuItemCollection getMainMenuCollection(String longNumber, int level) {
        MainMenuItemCollection menuItemCollection = null;
        try {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longNumber + "!%"), CompareType.LIKE));
            filterInfo.getFilterItems().add(new FilterItemInfo("level", (Object)String.valueOf(level + 1), CompareType.EQUALS));
            filterInfo.setMaskString("(#0 and #1)");
            entityViewInfo.setFilter(filterInfo);
            menuItemCollection = this.menu.getMainMenuItemCollection(entityViewInfo);
            if (menuItemCollection == null || menuItemCollection.isEmpty()) {
                return null;
            }
            return menuItemCollection;
        }
        catch (Exception e) {
            logger.error((Object)"getMainMenuCollection Exception:", (Throwable)e);
            return menuItemCollection;
        }
    }

    public static String getDeployName(String str) {
        int n;
        if (str.length() > 0 && (n = str.indexOf("@@")) != -1) {
            str = str.substring(n + 2);
        }
        return str;
    }

    public static String getDeployNumber(String str) {
        int n;
        if (str.length() > 0 && (n = str.indexOf("@@")) != -1) {
            str = str.startsWith("/") ? str.substring(1, n) : str.substring(0, n);
        }
        return str;
    }

    public static final void refreshMenuCache() {
        try {
            MainFunctionMenuFactory.getRemoteInstance().updateMenuCache("");
            MenuCacheFactory.getRemoteInstance().updateAllMenuCache();
        }
        catch (Exception ex) {
            logger.error((Object)"\u66f4\u65b0\u83dc\u5355\u7f13\u5b58", (Throwable)ex);
        }
        catch (Throwable t) {
            logger.error((Object)"\u66f4\u65b0\u83dc\u5355\u7f13\u5b58", t);
        }
    }
}

