/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlreport.sql;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CtrlReportUtil;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class CollectWhere {
    public static final String type_string = "String";
    public static final String type_number = "number";
    public static final String type_date = "date";
    public static final String type_time = "time";
    public static final String type_datetime = "datetime";

    public static final void putComponentValueCache(HashMap cache, KDPanel coreUI) {
        Component[] cts = coreUI.getComponents();
        if (null != cts && cts.length > 0) {
            for (Component c : cts) {
                Object value;
                if (c instanceof KDTextField) {
                    value = ((KDTextField)c).getText();
                    cache.put(c.getName(), value);
                }
                if (c instanceof KDDatePicker) {
                    value = ((KDDatePicker)c).getValue();
                    cache.put(c.getName(), value);
                }
                if (c instanceof KDComboBox) {
                    int value2 = ((KDComboBox)c).getSelectedIndex();
                    cache.put(c.getName(), String.valueOf(value2));
                }
                if (c instanceof KDRadioButton) {
                    boolean value3 = ((KDRadioButton)c).isSelected();
                    cache.put(c.getName(), String.valueOf(value3));
                }
                if (!(c instanceof KDPanel)) continue;
                CollectWhere.putComponentValueCache(cache, (KDPanel)c);
            }
        }
    }

    public static final void getComponentValueCache(HashMap cache, KDPanel coreUI) {
        Component[] cts = coreUI.getComponents();
        if (null != cts && cts.length > 0) {
            for (Component c : cts) {
                String value;
                if (c instanceof KDTextField && cache.containsKey(c.getName())) {
                    value = CtrlReportUtil.getObjectString(cache.get(c.getName()));
                    ((KDTextField)c).setText(value);
                }
                if (c instanceof KDDatePicker && cache.containsKey(c.getName())) {
                    Date date = null;
                    KDDatePicker kDDatePicker = (KDDatePicker)c;
                    Object value2 = cache.get(c.getName());
                    if (value2 instanceof Date) {
                        date = (Date)value2;
                    }
                    kDDatePicker.setValue((Object)date);
                }
                if (c instanceof KDComboBox && cache.containsKey(c.getName())) {
                    value = cache.get(c.getName());
                    ((KDComboBox)c).setSelectedIndex(Integer.parseInt(CtrlReportUtil.getObjectString(value)));
                }
                if (c instanceof KDRadioButton && cache.containsKey(c.getName())) {
                    value = cache.get(c.getName());
                    boolean bool = new Boolean(CtrlReportUtil.getObjectString(value));
                    ((KDRadioButton)c).setSelected(bool);
                }
                if (!(c instanceof KDPanel)) continue;
                CollectWhere.getComponentValueCache(cache, (KDPanel)c);
            }
        }
    }

    public static final void setWhere(StringBuffer sbSQL, HashMap map, String key, String field, String operate, String type) {
        Object obj = map.get(key);
        if (obj != null) {
            if (type.equalsIgnoreCase(type_string)) {
                String value = CtrlReportUtil.getObjectString(obj);
                if (value.equals("")) {
                    return;
                }
                if (operate.equalsIgnoreCase("like")) {
                    sbSQL.append(" and ").append(field).append(" ").append(operate).append(" '%").append(value).append("%'");
                } else {
                    sbSQL.append(" and ").append(field).append(" ").append(operate).append(" '").append(value).append("'");
                }
            } else if (type.equalsIgnoreCase(type_number)) {
                String value = CtrlReportUtil.getObjectString(obj);
                if (value.equals("")) {
                    return;
                }
                sbSQL.append("and ").append(field).append(" ").append(operate).append(" ").append(value);
            } else if (type.equalsIgnoreCase(type_date)) {
                String dateString = null;
                if (obj instanceof Date) {
                    Date date = (Date)obj;
                    if (date != null) {
                        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd");
                        dateString = dateformat.format(date);
                        dateString = dateString.substring(0, 10);
                    }
                } else {
                    dateString = CtrlReportUtil.getObjectString(obj);
                }
                if (dateString != null && !dateString.equals("")) {
                    sbSQL.append(" and TO_CHAR(").append(field).append(",'yyyy-MM-dd') ").append(operate).append(" '").append(dateString).append("'");
                }
            } else if (type.equalsIgnoreCase(type_time) || type.equalsIgnoreCase(type_datetime)) {
                // empty if block
            }
        }
    }

    public static final void setWhere(StringBuffer sbSQL, HashMap map, String key, String[] fields, String operate, String type) {
        Object obj;
        String field = null;
        if (fields.length == 1) {
            field = fields[0];
        }
        if ((obj = map.get(key)) != null) {
            if (type.equalsIgnoreCase(type_string)) {
                String value = CtrlReportUtil.getObjectString(obj);
                if (value.equals("")) {
                    return;
                }
                if (operate.equalsIgnoreCase("like")) {
                    sbSQL.append(" and ").append(field).append(" ").append(operate).append(" '%").append(value).append("%'");
                } else {
                    sbSQL.append(" and ").append(field).append(" ").append(operate).append(" '").append(value).append("'");
                }
            } else if (type.equalsIgnoreCase(type_number)) {
                String value = CtrlReportUtil.getObjectString(obj);
                if (value.equals("")) {
                    return;
                }
                sbSQL.append("and ").append(field).append(" ").append(operate).append(" ").append(value);
            } else if (type.equalsIgnoreCase(type_date)) {
                String dateString = null;
                if (obj instanceof Date) {
                    Date date = (Date)obj;
                    if (date != null) {
                        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd");
                        dateString = dateformat.format(date);
                        dateString = dateString.substring(0, 10);
                    }
                } else {
                    dateString = CtrlReportUtil.getObjectString(obj);
                }
                sbSQL.append(" and (");
                int len = fields.length;
                for (int i = 0; i < len; ++i) {
                    sbSQL.append("TO_CHAR(").append(fields[i]).append(",'yyyy-MM-dd') ").append(operate).append(" '").append(dateString).append("'");
                    if (i >= len - 1) continue;
                    sbSQL.append(" or ");
                }
                sbSQL.append(")");
            } else if (type.equalsIgnoreCase(type_time) || type.equalsIgnoreCase(type_datetime)) {
                // empty if block
            }
        }
    }
}

