/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlsqldesign.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.datacenter.DataCenterDBType;
import com.kingdee.bos.ctrl.common.datacenter.DataCenterInfo;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.data.modal.query.IQuery;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.eas.base.reportmeta.ctrlreport.ReportFacadeFactory;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.base.reportmeta.ctrlreport.util.ExtStringUtil;
import com.kingdee.eas.base.reportmeta.ctrlreport.util.MessageUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.data.InOutputParamVO;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.data.JavaModel;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.data.ProcedureModel;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.data.ProcedureParamData;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.exception.CtrlReportException;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.factory.FacadeFactory;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.BindParam;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.CtrlDesignCommonQuery;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.CtrlDesignKsqlQuery;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.CtrlDesignKsqlSolver;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.CtrlDesignUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.ExtDBUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.SqlWhereParser;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.param.IJavaDataSet;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Window;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class CtrlDesignDataExecutor {
    public static final Logger log = LogUtil.getPackageLogger(CtrlDesignDataExecutor.class);

    public static HashMap execute(Context ctx, CtrlDesignQueryModel model, HashMap mapDesignParam, HashMap logMap, int start, int rows, boolean isRun, Window parent) throws CtrlReportException {
        CtrlDesignCommonQuery commonQuery;
        String customType;
        if (logMap == null) {
            logMap = new HashMap<String, String>();
        }
        logMap.clear();
        if (mapDesignParam == null) {
            mapDesignParam = new HashMap();
        }
        if ((customType = CtrlReportUtil.getObjectString((commonQuery = model.getCommonQuery()).getProperties().get(CtrlDesignUtil.CustomType))).equals(String.valueOf(2))) {
            return CtrlDesignDataExecutor.callProcedure(ctx, model, mapDesignParam, logMap, start, rows);
        }
        if (customType.equals(String.valueOf(3)) || customType.equals(String.valueOf(7)) || customType.equals(String.valueOf(8))) {
            return CtrlDesignDataExecutor.executeJavaCode(ctx, model, mapDesignParam, logMap, start, rows, parent);
        }
        IQuery query = model.getQuery();
        String sql = null;
        try {
            sql = !StringUtils.isEmpty((String)model.getFirstSql()) ? model.getFirstSql() : (customType.equals(String.valueOf(5)) ? model.getQuery().getContent() : CtrlDesignQueryModel.makeSQL(ctx, model));
            sql = sql.trim();
            if (sql.endsWith(";")) {
                sql = sql.substring(0, sql.length() - 1);
            }
            while (sql.indexOf("?") != -1) {
                String realName = SqlWhereParser.getRealParamNameMacro(sql);
                if (!realName.equals("")) {
                    if (mapDesignParam.containsKey(realName)) {
                        DesignParameter p = (DesignParameter)((Object)mapDesignParam.get(realName));
                        String value = CtrlReportUtil.getObjectString(p.getCurentValue());
                        if (value.equals("")) {
                            throw new CtrlReportException("\u5b8f\u66ff\u6362\u7684\u53c2\u6570\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8bbe\u7f6e\u53c2\u6570\u9ed8\u8ba4\u503c\uff1a" + realName);
                        }
                        sql = ExtStringUtil.replaceFirst(sql, "?" + realName, value);
                        continue;
                    }
                    throw new CtrlReportException("\u6ca1\u6709\u627e\u5230\u5b8f\u66ff\u6362\u7684\u53c2\u6570\uff1a" + realName);
                }
                sql = ExtStringUtil.replaceFirst(sql, "?", "0x1x2x3x4x");
            }
            sql = ExtStringUtil.replace(sql, "0x1x2x3x4x", "?");
        }
        catch (BOSException e1) {
            throw new CtrlReportException(MessageUtil.getMsgInfo("label258") + e1.getMessage());
        }
        boolean isDialect = false;
        String sqllc = sql.toLowerCase();
        if (sqllc.startsWith("/*dialect*/")) {
            isDialect = true;
        }
        String sqlNoRN = null;
        sqlNoRN = ExtStringUtil.replace(sqllc, "\r", " ");
        sqlNoRN = ExtStringUtil.replace(sqlNoRN, "\n", " ");
        sqlNoRN = CtrlReportUtil.trimStr(sqlNoRN);
        if (!isRun) {
            if (sqlNoRN.indexOf("insert into ") != -1) {
                throw new CtrlReportException(MessageUtil.getMsgInfo("label243"));
            }
            if (sqlNoRN.startsWith("update ")) {
                throw new CtrlReportException(MessageUtil.getMsgInfo("label244"));
            }
        }
        int dbType = -1;
        if (!isDialect) {
            CtrlDesignKsqlQuery ksqlQuery;
            String outDB;
            int intYear = 10000;
            int intHour = 24;
            HashMap<String, String> dateTypeMap = new HashMap<String, String>();
            String sqlNoSpace = CtrlReportUtil.removeSpace(sqllc);
            try {
                Iterator it = mapDesignParam.keySet().iterator();
                while (it.hasNext()) {
                    String name = it.next().toString();
                    DesignParameter p = (DesignParameter)((Object)mapDesignParam.get(name));
                    String value = CtrlReportUtil.getObjectString(p.getCurentValue());
                    value = CtrlReportUtil.strFilterSQL(value);
                    p.setCurentValue(value);
                    boolean isDateTime = false;
                    int dataType = p.getDesignDataType().intValue();
                    if (dataType == 2) {
                        String msg;
                        boolean isDateToDateTime = false;
                        if (sqlNoSpace.indexOf("{d'@" + name.toLowerCase() + "'}") != -1) {
                            msg = "\u8b66\u544a\uff1a\u65e5\u671f\u7c7b\u578b\u7684\u53c2\u6570\uff0c\u63a8\u8350\u4f7f\u7528{TS '@" + name + "'}\uff0c\u4e0d\u63a8\u8350{D '@" + name + "'}";
                            MiscUtil.log((int)4, (String)msg);
                            log.debug((Object)msg);
                        } else if (sqlNoSpace.indexOf("{t'@" + name.toLowerCase() + "'}") != -1) {
                            msg = "\u8b66\u544a\uff1a\u65e5\u671f\u7c7b\u578b\u7684\u53c2\u6570\uff0c\u63a8\u8350\u4f7f\u7528{TS '@" + name + "'}\uff0c\u4e0d\u63a8\u8350{T '@" + name + "'}";
                            MiscUtil.log((int)4, (String)msg);
                            log.debug((Object)msg);
                        } else if (sqlNoSpace.indexOf("{ts'@" + name.toLowerCase() + "'}") != -1) {
                            isDateToDateTime = true;
                        }
                        isDateTime = true;
                        if (value.equals("")) {
                            value = --intYear + "-12-31";
                            if (isDateToDateTime) {
                                value = value + " " + "01:02:03";
                            }
                            p.setCurentValue(value);
                            dateTypeMap.put(name, value);
                        } else if (isDateToDateTime) {
                            value = value + " " + "01:02:03";
                            p.setCurentValue(value);
                        }
                    } else if (dataType == 4) {
                        if (sqlNoSpace.indexOf("{d'@" + name.toLowerCase() + "'}") != -1 || sqlNoSpace.indexOf("{t'@" + name.toLowerCase() + "'}") != -1) {
                            String msg = "\u8b66\u544a\uff1a\u65f6\u95f4\u6233\u7c7b\u578b\u7684\u53c2\u6570\uff0c\u8bf7\u4f7f\u7528 {TS '@" + name + "'}\uff0c\u4e0d\u63a8\u8350{D '@" + name + "'}";
                            MiscUtil.log((int)4, (String)msg);
                            log.debug((Object)msg);
                        }
                        isDateTime = true;
                        if (value.equals("")) {
                            value = --intYear + "-12-31 " + "01:02:03";
                            p.setCurentValue(value);
                            dateTypeMap.put(name, value);
                        }
                    } else if (dataType == 5) {
                        if (sqlNoSpace.indexOf("{d'@" + name.toLowerCase() + "'}") != -1 || sqlNoSpace.indexOf("{ts'@" + name.toLowerCase() + "'}") != -1) {
                            String msg = "\u8b66\u544a\uff1a\u65f6\u95f4\u7c7b\u578b\u7684\u53c2\u6570\uff0c\u8bf7\u4f7f\u7528 {T '@\u53c2\u6570\u540d\u79f0'} \u7684\u8bed\u6cd5";
                            MiscUtil.log((int)4, (String)msg);
                            log.debug((Object)msg);
                        }
                        isDateTime = true;
                        if (value.equals("")) {
                            value = --intHour + ":04:04";
                            p.setCurentValue(value);
                            dateTypeMap.put(name, value);
                        }
                    }
                    if (!isDateTime) continue;
                    String oldvalue = "'@" + name + "'";
                    String newValue = "'" + value + "'";
                    sql = ExtStringUtil.replace(sql, oldvalue, newValue);
                }
            }
            catch (Exception ex) {
                throw CtrlReportException.makeException(MessageUtil.getMsgInfo("label251") + ex.getMessage(), ex);
            }
            String[] arr = CtrlDesignDataExecutor.getDBType(ctx, query);
            dbType = Integer.parseInt(arr[0]);
            try {
                sql = CtrlDesignKsqlSolver.solve(sql, mapDesignParam, dateTypeMap, true);
            }
            catch (CtrlReportException e) {
                throw e;
            }
            catch (Exception e) {
                throw CtrlReportException.makeException(MessageUtil.getMsgInfo("label184") + e.getMessage(), e);
            }
            sql = SqlWhereParser.parseKSQLTime(sql, dbType);
            if (!isRun) {
                sql = CtrlDesignDataExecutor.buildDialectTopNSQL(Pattern.compile("select\\s+top\\s+\\d+\\s+"), sql, " select top " + (dbType == DataCenterDBType.DB2.intValue() ? (rows <= 0 ? 1 : rows) : rows) + " ", Pattern.compile("\\s*select\\s+"));
            }
            if (!(outDB = CtrlReportUtil.getObjectString((ksqlQuery = (CtrlDesignKsqlQuery)query).getOutDB())).equals("")) {
                try {
                    sql = "/*dialect*/" + TransUtil.Translate((String)sql, (int)dbType);
                }
                catch (SqlTranslateException e) {
                    throw CtrlReportException.makeException(MessageUtil.getMsgInfo("label284") + e.getMessage(), e);
                }
            }
        } else {
            String[] arr = CtrlDesignDataExecutor.getDBType(ctx, query);
            dbType = Integer.parseInt(arr[0]);
            HashMap<String, String> warnMap = new HashMap<String, String>();
            warnMap.put("sqlNoRN", sqlNoRN);
            sql = BindParam.replaceVariantDialect(sql, mapDesignParam, dbType, warnMap);
            String warnMsg = CtrlReportUtil.getObjectString(warnMap.get("warnMsg"));
            if (null == ctx && !warnMsg.equals("") && !isRun) {
                MessageUtil.showInfo(warnMsg, false);
            }
            if (dbType == DataCenterDBType.ORACLE.intValue()) {
                sql = CtrlDesignDataExecutor.buildDialectTopNSQL(Pattern.compile("\\s+rownum\\s*<{1}={0,1}\\s*\\d+\\s*"), sql, " where rownum<=" + rows + " and ", Pattern.compile("\\s+where\\s+"));
                if (sql.endsWith(" and ")) {
                    sql = sql.substring(0, sql.lastIndexOf(" and "));
                }
            } else if (dbType == DataCenterDBType.SQLSERVER.intValue()) {
                sql = CtrlDesignDataExecutor.buildDialectTopNSQL(Pattern.compile("select\\s+top\\s+\\d+\\s+"), sql, " select top " + rows + " ", Pattern.compile("\\s*select\\s+"));
            } else if (dbType == DataCenterDBType.DB2.intValue()) {
                sql = CtrlDesignDataExecutor.buildDialectTopNSQL(Pattern.compile("\\s+fetch\\s+first\\s+\\d+\\s+rows\\s+only\\s*"), sql, " fetch first " + (rows <= 0 ? 1 : rows) + " rows only ", Pattern.compile("\\s*\\z"));
            }
        }
        logMap.put("sql", sql);
        logMap.put("dbType", String.valueOf(dbType));
        MiscUtil.log((int)4, (String)sql);
        RptParams pr = new RptParams();
        pr.setString("MethodName", "getDBPageSizeInfoBySQL");
        pr.setString("sql", sql);
        pr.setInt("start", start);
        pr.setInt("rows", rows);
        CtrlDesignDataExecutor.setOutDBToPR(pr, query);
        RptParams ps_r = null;
        try {
            long startTime = CtrlReportUtil.getSystemTime();
            ps_r = FacadeFactory.commonExecuteNever(ctx, pr);
            logMap.put("useTime", CtrlReportUtil.getSystemTime() - startTime + " " + MessageUtil.getMsgInfo("label256"));
        }
        catch (BOSException e) {
            String excMsg = "";
            Throwable t = e.getCause();
            excMsg = null != t ? CtrlReportUtil.getObjectString(t.getMessage()) : e.getMessage();
            String msg1 = MessageUtil.getMsgInfo("label185");
            throw CtrlReportException.makeException(msg1 + "\r\n" + excMsg, e);
        }
        IRowSet irs = (IRowSet)ps_r.getObject("object");
        HashMap<String, IRowSet> mapResult = new HashMap<String, IRowSet>();
        mapResult.put("6xx8xxRowset", irs);
        return mapResult;
    }

    private static String buildDialectTopNSQL(Pattern topNFinder, String sql, String topNReplaceMement, Pattern insertPlaceFinder) {
        String lowerCaseSQL = sql.toLowerCase();
        StringBuffer sb = new StringBuffer();
        Matcher m = topNFinder.matcher(lowerCaseSQL);
        boolean found = false;
        int lastEnd = 0;
        while (m.find()) {
            found = true;
            m.group();
            sb.append(sql.substring(lastEnd, m.start()));
            sb.append(topNReplaceMement);
            lastEnd = m.end();
        }
        if (found) {
            sb.append(sql.substring(lastEnd));
        }
        if (!found) {
            m = insertPlaceFinder.matcher(lowerCaseSQL);
            while (m.find()) {
                m.group();
                found = true;
                sb.append(sql.substring(lastEnd, m.start()));
                sb.append(topNReplaceMement);
                lastEnd = m.end();
            }
            if (!found) {
                sb.append(sql);
            } else {
                sb.append(sql.substring(lastEnd));
            }
        }
        sql = sb.toString();
        sb = new StringBuffer();
        found = false;
        lastEnd = 0;
        Pattern distinctFinder = Pattern.compile("\\s*select\\s+top\\s+\\d+\\s+distinct\\s+");
        m = distinctFinder.matcher(lowerCaseSQL);
        Pattern numberFinder = Pattern.compile("\\s+\\d+\\s+");
        while (m.find()) {
            found = true;
            String group = m.group();
            Matcher t = numberFinder.matcher(group);
            t.find();
            sb.append(sql.substring(lastEnd, m.start()));
            sb.append(" select distinct top " + t.group() + " ");
            lastEnd = m.end();
        }
        if (!found) {
            sb.append(sql);
        } else {
            sb.append(sql.substring(lastEnd));
        }
        sql = sb.toString();
        return sql;
    }

    public static IRowSet preview(CtrlDesignQueryModel model, HashMap mapDesignParam, HashMap logMap) throws Exception {
        HashMap mapResult = CtrlDesignDataExecutor.execute(null, model, mapDesignParam, logMap, 0, 0, false, null);
        IRowSet irs = (IRowSet)mapResult.get("6xx8xxRowset");
        return irs;
    }

    public static String[] getDBType(Context ctx, IQuery query) throws CtrlReportException {
        String[] arr = new String[2];
        int ret = CtrlDesignDataExecutor.getOutDBType(ctx, query);
        if (ret != -1) {
            DataCenterDBType dbType = DataCenterDBType.getDBType((int)ret);
            arr[0] = String.valueOf(dbType.intValue());
            arr[1] = dbType.getName();
        } else {
            int dbType = ExtDBUtil.getDBType(ctx);
            arr[0] = String.valueOf(dbType);
            if (dbType == 1) {
                arr[1] = "DB2";
            } else if (dbType == 2) {
                arr[1] = "Oracle";
            } else if (dbType == 3) {
                arr[1] = "SqlServer";
            }
        }
        return arr;
    }

    private static int getOutDBType(Context ctx, IQuery query) throws CtrlReportException {
        int ret = -1;
        CtrlDesignKsqlQuery ksqlQuery = (CtrlDesignKsqlQuery)query;
        String outDB = CtrlReportUtil.getObjectString(ksqlQuery.getOutDB());
        if (outDB.equals("")) {
            return ret;
        }
        RptParams pr = new RptParams();
        pr.setString("MethodName", "getDataCenterVo");
        pr.setObject("outDB", (Object)outDB);
        try {
            RptParams ps_r = FacadeFactory.commonExecuteNever(ctx, pr);
            Object obj = ps_r.getObject("getDataCenterVo");
            if (obj == null) {
                throw new CtrlReportException(outDB + "\uff1a" + MessageUtil.getMsgInfo("label283"));
            }
            DataCenterInfo vo = (DataCenterInfo)obj;
            return vo.getDbType();
        }
        catch (Exception e) {
            throw CtrlReportException.makeException(MessageUtil.getMsgInfo("label283"), e);
        }
    }

    private static final void setOutDBToPR(RptParams pr, IQuery query) {
        CtrlDesignKsqlQuery ksqlQuery = (CtrlDesignKsqlQuery)query;
        String outDB = CtrlReportUtil.getObjectString(ksqlQuery.getOutDB());
        if (!outDB.equals("")) {
            pr.setObject("outDB", (Object)outDB);
        }
    }

    public static IRowSet execute(String outDB, String sql, HashMap logMap, int start, int rows) throws ParserException, BOSException {
        RptParams pr = new RptParams();
        pr.setString("MethodName", "getDBPageSizeInfoBySQL");
        pr.setString("sql", sql);
        pr.setInt("start", start);
        pr.setInt("rows", rows);
        pr.setObject("outDB", (Object)outDB);
        logMap.clear();
        logMap.put("sql", sql);
        long startTime = CtrlReportUtil.getSystemTime();
        RptParams ps_r = ReportFacadeFactory.getRemoteInstance().commonExecuteNever(pr);
        logMap.put("useTime", CtrlReportUtil.getSystemTime() - startTime + " " + MessageUtil.getMsgInfo("label256"));
        IRowSet irs = (IRowSet)ps_r.getObject("object");
        return irs;
    }

    public static HashMap callProcedure(Context ctx, CtrlDesignQueryModel model, HashMap mapDesignParam, HashMap logMap, int start, int rows) throws CtrlReportException {
        ProcedureModel pm = model.getCommonQuery().getProcedureModel();
        ArrayList<InOutputParamVO> procedureVOList = new ArrayList<InOutputParamVO>();
        StringBuffer logProcedureParam = new StringBuffer();
        ArrayList paramList = pm.getParamList();
        if (paramList != null && !paramList.isEmpty()) {
            int size = paramList.size();
            for (int i = 0; i < size; ++i) {
                ProcedureParamData pmd = (ProcedureParamData)paramList.get(i);
                String name = pmd.getName();
                int ioType = pmd.getIoType().intValue();
                int dataType = pmd.getDataType().intValue();
                Object objValue = null;
                if (ioType == 0) {
                    objValue = CtrlDesignDataExecutor.getProcedureValue(pmd, mapDesignParam);
                }
                InOutputParamVO vo = new InOutputParamVO();
                vo.setName(name);
                vo.setIoType(ioType);
                vo.setDataType(dataType);
                vo.setValue(objValue);
                procedureVOList.add(vo);
                logProcedureParam.append("\u5b58\u50a8\u8fc7\u7a0b\u53c2\u6570:").append(name).append(", value =").append(objValue);
                logProcedureParam.append(", ioType = ").append(pmd.getIoType()).append(", DataType = ").append(pmd.getDataType()).append("\r\n");
            }
        }
        String resultNumberName = null;
        resultNumberName = pm.getDbType() == 2 ? pm.getResultCursor() : String.valueOf(pm.getResultNumber());
        RptParams pr = new RptParams();
        pr.setString("MethodName", "callProcedure");
        pr.setString("procedureName", pm.getName());
        pr.setInt("dbType", pm.getDbType());
        pr.setString("resultNumberName", resultNumberName);
        pr.setObject("paramList", procedureVOList);
        pr.setInt("start", start);
        pr.setInt("rows", rows);
        CtrlDesignDataExecutor.setOutDBToPR(pr, model.getQuery());
        RptParams ps_r = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("start call storeProcedure: " + pm.getName()));
                String paramLog = logProcedureParam.toString();
                log.debug((Object)("\r\n" + paramLog));
            }
            MiscUtil.log((int)4, (String)("start call storeProcedure: " + pm.getName()));
            MiscUtil.log((int)4, (String)("\r\n" + logProcedureParam.toString()));
            long startTime = CtrlReportUtil.getSystemTime();
            ps_r = FacadeFactory.commonExecuteNever(ctx, pr);
            logMap.put("useTime", CtrlReportUtil.getSystemTime() - startTime + " " + MessageUtil.getMsgInfo("label256"));
        }
        catch (BOSException e) {
            String excMsg = "";
            Throwable t = e.getCause();
            excMsg = null != t ? CtrlReportUtil.getObjectString(t.getMessage()) : e.getMessage();
            throw CtrlReportException.makeException("\u6267\u884c\u5b58\u50a8\u8fc7\u7a0b\u5931\u8d25:\r\n" + excMsg, e);
        }
        HashMap mapResult = (HashMap)ps_r.getObject("object");
        return mapResult;
    }

    private static HashMap executeJavaCode(Context ctx, CtrlDesignQueryModel model, HashMap mapDesignParam, HashMap logMap, int start, int rows, Window parent) throws CtrlReportException {
        HashMap<String, Object> toJavaMap = new HashMap<String, Object>();
        toJavaMap.put("CtrlDesignQueryModel", model);
        StringBuffer logParamSystem = new StringBuffer();
        StringBuffer logParamCustom = new StringBuffer();
        Iterator it = mapDesignParam.keySet().iterator();
        while (it.hasNext()) {
            String name = it.next().toString();
            DesignParameter p = (DesignParameter)((Object)mapDesignParam.get(name));
            toJavaMap.put(p.getName(), CtrlReportUtil.getObjectString(p.getCurentValue()));
            if (name.startsWith("ExtRpt")) {
                logParamSystem.append("\u5185\u7f6e\u53c2\u6570:").append(p.getName()).append(", value = ").append(p.getCurentValue()).append(", type = ").append(p.getDesignDataType()).append("\r\n");
                continue;
            }
            logParamCustom.append("\u5b9a\u5236\u53c2\u6570:").append(p.getName()).append(", value = ").append(p.getCurentValue()).append(", type = ").append(p.getDesignDataType()).append("\r\n");
        }
        StringBuffer logParam = new StringBuffer();
        logParam.append("\r\n").append(logParamCustom).append(logParamSystem);
        if (log.isDebugEnabled()) {
            String paramLog = logParam.toString();
            log.debug((Object)paramLog);
        }
        MiscUtil.log((int)4, (String)logParam.toString());
        JavaModel jm = model.getCommonQuery().getJavaModel();
        int interfaceType = jm.getInterfaceType();
        int executeType = jm.getExecuteType();
        IJavaDataSet iJavaDataSet = null;
        String customSQL = "";
        IRowSet irs = null;
        if (executeType == 0) {
            String strFullName = jm.getFullname();
            if (strFullName.equals("")) {
                throw new CtrlReportException(MessageUtil.getMsgInfo("label349"));
            }
            try {
                iJavaDataSet = (IJavaDataSet)Class.forName(strFullName).newInstance();
                iJavaDataSet.setFilterParam(toJavaMap);
                iJavaDataSet.setContext(ctx);
                if (interfaceType == 0) {
                    customSQL = iJavaDataSet.getCustomSQL(parent);
                }
            }
            catch (Exception e) {
                throw CtrlReportException.makeException(MessageUtil.getMsgInfo("label350") + e.getMessage(), e);
            }
            catch (Throwable t) {
                throw CtrlReportException.makeException(MessageUtil.getMsgInfo("label350") + t.getMessage(), t);
            }
        }
        String[] arr = CtrlDesignDataExecutor.getDBType(ctx, model.getQuery());
        int dbType = Integer.parseInt(arr[0]);
        logMap.put("sql", customSQL);
        logMap.put("dbType", String.valueOf(dbType));
        MiscUtil.log((int)4, (String)customSQL);
        if (interfaceType == 0) {
            RptParams pr = new RptParams();
            pr.setString("MethodName", "getDBPageSizeInfoBySQL");
            pr.setString("sql", customSQL);
            pr.setInt("start", start);
            pr.setInt("rows", rows);
            CtrlDesignDataExecutor.setOutDBToPR(pr, model.getQuery());
            RptParams ps_r = null;
            try {
                long startTime = CtrlReportUtil.getSystemTime();
                ps_r = FacadeFactory.commonExecuteNever(ctx, pr);
                logMap.put("useTime", CtrlReportUtil.getSystemTime() - startTime + " " + MessageUtil.getMsgInfo("label256"));
            }
            catch (BOSException e) {
                String excMsg = "";
                Throwable t = e.getCause();
                if (null != t) {
                    excMsg = CtrlReportUtil.getObjectString(t.getMessage());
                }
                String msg1 = MessageUtil.getMsgInfo("label185");
                throw CtrlReportException.makeException(msg1 + "\r\n" + excMsg, e);
            }
            irs = (IRowSet)ps_r.getObject("object");
        } else {
            CtrlDesignKsqlQuery ksqlQuery = (CtrlDesignKsqlQuery)model.getQuery();
            String outDB = CtrlReportUtil.getObjectString(ksqlQuery.getOutDB());
            try {
                IRowSet[] iRowSets = iJavaDataSet.getCustomRowSet(parent, outDB);
                irs = iRowSets[0];
            }
            catch (Exception e) {
                String excMsg = "";
                Throwable t = e.getCause();
                if (null != t) {
                    excMsg = CtrlReportUtil.getObjectString(t.getMessage());
                }
                String msg1 = MessageUtil.getMsgInfo("label351");
                throw CtrlReportException.makeException(msg1 + "\r\n" + excMsg, e);
            }
        }
        HashMap<String, Object> mapResult = new HashMap<String, Object>();
        mapResult.put("6xx8xxRowset", irs);
        StringBuffer logProcedureParam = new StringBuffer();
        try {
            Map mapFromJava = iJavaDataSet.getOutputParam();
            ArrayList paramList = jm.getParamList();
            if (paramList != null && !paramList.isEmpty()) {
                int size = paramList.size();
                for (int i = 0; i < size; ++i) {
                    ProcedureParamData pmd = (ProcedureParamData)paramList.get(i);
                    String name = pmd.getName();
                    String value = CtrlReportUtil.getObjectString(mapFromJava.get(name));
                    InOutputParamVO vo = new InOutputParamVO();
                    vo.setName(name);
                    vo.setDataType(pmd.getDataType().intValue());
                    vo.setValue(value);
                    mapResult.put(name, vo);
                    logProcedureParam.append("\u8f93\u51fa\u53c2\u6570:").append(name).append(", value =").append(value);
                    logProcedureParam.append(", DataType = ").append(pmd.getDataType()).append("\r\n");
                }
            }
            String paramLog = logProcedureParam.toString();
            log.debug((Object)("\r\n" + paramLog));
            MiscUtil.log((int)4, (String)("\r\n" + logProcedureParam.toString()));
        }
        catch (Throwable t) {
            log.debug((Object)"\u53d6\u8f93\u51fa\u53c2\u6570\u9519\u8bef", t);
            MiscUtil.log((Throwable)t);
        }
        return mapResult;
    }

    private static Object getProcedureValue(ProcedureParamData pmd, HashMap mapDesignParam) throws CtrlReportException {
        String bindFilterParamName = CtrlReportUtil.getObjectString(pmd.getBindFilterParamName());
        int dataType = pmd.getDataType().intValue();
        String value = null;
        if (bindFilterParamName.equals("") || !mapDesignParam.containsKey(bindFilterParamName)) {
            value = pmd.getDefaultValue();
            log.debug((Object)("\u8b66\u544a\uff1a\u6ca1\u6709\u7ed1\u5b9a\u8fc7\u6ee4\u53c2\u6570\uff0c\u53d6\u9ed8\u8ba4\u503c  " + bindFilterParamName));
            MiscUtil.log((int)4, (String)("\u8b66\u544a\uff1a\u6ca1\u6709\u7ed1\u5b9a\u8fc7\u6ee4\u53c2\u6570\uff0c\u53d6\u9ed8\u8ba4\u503c  " + bindFilterParamName));
        } else {
            DesignParameter p = (DesignParameter)((Object)mapDesignParam.get(bindFilterParamName));
            value = CtrlReportUtil.getObjectString(p.getCurentValue());
            if (value.equals("")) {
                value = pmd.getDefaultValue();
            }
        }
        try {
            switch (dataType) {
                case 0: {
                    return value;
                }
                case 1: {
                    return new Integer(value);
                }
                case 2: {
                    return new BigDecimal(value);
                }
                case 3: {
                    long longDate = CtrlReportUtil.sdf_yyyy_MM_dd.parse(value).getTime();
                    return new Date(longDate);
                }
                case 4: {
                    return new Timestamp(CtrlReportUtil.getDateLong(value));
                }
                case 5: {
                    return new Time(CtrlReportUtil.getTimeLong(value));
                }
            }
            return null;
        }
        catch (Exception e) {
            String msg = "\u5b58\u50a8\u8fc7\u7a0b\u7684\u8f93\u5165\u53c2\u6570\u6570\u636e\u7c7b\u578b\u9519\u8bef\r\n\u53c2\u6570\u540d\u79f0\uff1a" + pmd.getName() + "\r\n\u6570\u636e\u7c7b\u578b\uff1a" + pmd.getDataType() + "\r\n\u8fc7\u6ee4\u503c\uff1a" + value + "\r\n\u9519\u8bef\u6d88\u606f\uff1a" + e.getMessage();
            throw CtrlReportException.makeException(msg, e);
        }
    }
}

