/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.ctrlsqldesign.model;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.explorer.model.base.ConstructURL;
import com.kingdee.bos.ctrl.kdf.util.file.KDFException;
import com.kingdee.bos.ctrl.kdf.util.kdfsax.KDFSAXException;
import com.kingdee.bos.ctrl.kds.exec.ExecutionContext;
import com.kingdee.bos.ctrl.kds.exec.ExtExecutor;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSetManager;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSetType;
import com.kingdee.bos.ctrl.kds.expans.model.data.ParameterImpl;
import com.kingdee.bos.ctrl.kds.io.BookIOUtil;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.UserObject;
import com.kingdee.bos.ctrl.kds.model.struct.filter.AlgorithmUtil;
import com.kingdee.bos.ctrl.kds.model.util.ExtURL;
import com.kingdee.bos.ctrl.kds.model.util.IConstructURL;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.eas.base.reportmeta.base.license.EXTLicenseException;
import com.kingdee.eas.base.reportmeta.base.license.EXTLicenseService;
import com.kingdee.eas.base.reportmeta.base.license.ILicenseChecker;
import com.kingdee.eas.base.reportmeta.base.license.LicenseCheckerFactory;
import com.kingdee.eas.base.reportmeta.base.license.ReportCenterLicenseSrvChecker;
import com.kingdee.eas.base.reportmeta.ctrlreport.DefineReportInfo;
import com.kingdee.eas.base.reportmeta.ctrlreport.bo.DefineReportBO;
import com.kingdee.eas.base.reportmeta.ctrlreport.bo.PermissionBO;
import com.kingdee.eas.base.reportmeta.ctrlreport.data.PermissionKind;
import com.kingdee.eas.base.reportmeta.ctrlreport.datasetfactory.DataSetBaseFactory;
import com.kingdee.eas.base.reportmeta.ctrlreport.datasetfactory.ExtDataSetEnumFactory;
import com.kingdee.eas.base.reportmeta.ctrlreport.datasetfactory.ExtDataSetKSQLFactory;
import com.kingdee.eas.base.reportmeta.ctrlreport.datasetfactory.ExtDataSetTextFactory;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.data.CacheObject;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.data.DesignDataType;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.data.IInputCtrl;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.data.InputState;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.data.InputType;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.data.SystemVarType;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.exception.CtrlReportException;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.CtrlDesignUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.ExtContextUtils;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.ExtDBUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.OrgRangeManage;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.RunReportParam;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.SqlDSModelDrill;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class WebParamAdapter {
    private static final Logger logger = Logger.getLogger(WebParamAdapter.class);
    public static final String T_FilterComponent = "FilterComponent";
    public static final String T_FilterItem = "FilterItem";
    public static final String T_ListItem = "ListItem";
    public static final String A_type = "type";
    public static final String A_name = "name";
    public static final String A_dataType = "dataType";
    public static final String A_caption = "caption";
    public static final String A_required = "required";
    public static final String A_defaultValue = "defaultValue";
    public static final String A_defalutAlias = "defaultAlais";
    public static final String A_isAllowEdit = "isAllowEdit";
    public static final String A_isReadOnly = "isReadOnly";
    public static final String A_isAllowMultipleSelected = "isAllowMultipleSelected";
    public static final String A_value = "value";
    public static final String A_valueColumn = "valueColumn";
    public static final String A_displayColumn = "displayColumn";
    public static final String A_fullname = "fullname";
    public static final String A_errMsg = "errMsg";
    public static final String BIContext = "BIContext";
    public static final String CurrentReportDBModel = "CurrentReportDBModel";
    public static final String isLimitRecord = "isLimitRecord";
    public static final String isLimitComplete = "isLimitComplete";
    public static final String datasetParent = "datasetParent";
    public static final String CacheObject = "CacheObject";
    private String reportID;
    private String reportName;
    private String userName;
    private String systemID;
    private String orgID;
    private String sourceReportOrgID;
    private Context ctx;
    Book book;
    ArrayList reportDBModel = new ArrayList();
    ArrayList allUnionParam = new ArrayList();
    boolean isSchedule = false;
    protected ILicenseChecker _licenseChecker;
    private boolean _isChecked;
    private boolean _isTree;
    private Map _sqlDbMap;
    private boolean _initSqlDbMap;

    public WebParamAdapter(Context ctx, String reportID) {
        this.ctx = ctx;
        this.reportID = reportID;
        ExtContextUtils.setContext(ctx);
    }

    public WebParamAdapter(Context ctx, String reportName, String systemID, String orgID) {
        this.ctx = ctx;
        this.reportName = reportName;
        this.systemID = systemID;
        this.orgID = orgID;
        ExtContextUtils.setContext(ctx);
    }

    public void setSchedule(boolean isSchedule) {
        this.isSchedule = isSchedule;
    }

    public String getReportParamXmlString() throws Exception {
        this.book = this.refreshBook();
        try {
            this.cacheDbSourceModel();
        }
        catch (Exception e) {
            logger.error((Object)"getReportParamXmlString.cacheDbSourceModel", (Throwable)e);
            throw e;
        }
        Element rootElement = new Element(T_FilterComponent);
        Iterator itr = this.allUnionParam.iterator();
        while (itr.hasNext()) {
            Element itemElement = this.makeFilterItem((DesignParameter)((Object)itr.next()));
            if (null == itemElement) continue;
            rootElement.addContent(itemElement);
        }
        XMLOutputter outter = new XMLOutputter("\t", true, "UTF-8");
        String xmlstr = outter.outputString(rootElement);
        return xmlstr;
    }

    public void execute(Map mapBIParam, Map mapBIAlias) throws IOException, KDFException, KDFSAXException, Exception {
        this.book = this.refreshBook();
        this.cacheDbSourceModel();
        ArrayList paramList = new ArrayList();
        for (DesignParameter dp : this.allUnionParam) {
            String paramName = dp.getName();
            String value = "";
            DesignDataType ddt = dp.getDesignDataType();
            String dataType = String.valueOf(ddt.intValue());
            String alias = "";
            if (mapBIParam.containsKey(paramName)) {
                value = CtrlReportUtil.getObjectString(mapBIParam.get(paramName));
                alias = CtrlReportUtil.getObjectString(mapBIAlias.get(paramName));
                if (ddt.equals(DesignDataType.DATETIME)) {
                    if (!dp.isAllowNull()) {
                        throw new Exception("\u4e0d\u652f\u6301\u65e5\u671f\u65f6\u95f4\u8fc7\u6ee4\u53c2\u6570\u7c7b\u578b\uff1a" + dp.getAlias(Locale.CHINA));
                    }
                    value = "";
                }
                if (ddt.equals(DesignDataType.TIME)) {
                    if (!dp.isAllowNull()) {
                        throw new Exception("\u4e0d\u652f\u6301\u65f6\u95f4\u8fc7\u6ee4\u53c2\u6570\u7c7b\u578b\uff1a" + dp.getAlias(Locale.CHINA));
                    }
                    value = "";
                }
                if (dataType.equals(String.valueOf(2)) && !this.isSchedule && !value.equals("")) {
                    try {
                        Date curr = CtrlReportUtil.sdf_yyyy_MM_dd.parse(value);
                        value = CtrlReportUtil.formatDate(curr);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(A_name, paramName);
            map.put(A_value, value);
            map.put("valueAlias", alias);
            map.put(A_dataType, dataType);
            paramList.add(map);
            HashMap<String, String> mapValueAlias = new HashMap<String, String>();
            mapValueAlias.put(A_name, paramName + "_text");
            mapValueAlias.put("valueAlias", alias);
            mapValueAlias.put(A_dataType, String.valueOf(0));
            if (null != alias && alias.length() > 0) {
                mapValueAlias.put(A_value, alias);
            } else {
                mapValueAlias.put(A_value, null);
            }
            paramList.add(mapValueAlias);
        }
        String parameterXmlString = CtrlDesignUtil.toFilterSolutionXml(paramList);
        HashMap mapDesignParam = RunReportParam.setExecuteParam(this.reportDBModel, parameterXmlString);
        RunReportParam.putServerDefalutListParamsMap(this.ctx, mapDesignParam);
        this.runExt(mapDesignParam);
        Sheet sheet = this.book.getActiveSheet();
        UserObject colTreePos = sheet.getUserObject("COLUMN_INLINED_TREE_POSITION");
        UserObject rowTreePos = sheet.getUserObject("ROW_INLINED_TREE_POSITION");
        if (!this._isTree) {
            this._isTree = colTreePos != null ^ rowTreePos != null;
        }
    }

    public void execute3G(String xmlString) throws Exception {
        this.book = this.refreshBook();
        this.cacheDbSourceModel();
        HashMap mapDesignParam = RunReportParam.setExecuteParam(this.reportDBModel, xmlString);
        RunReportParam.putServerDefalutListParamsMap(this.ctx, mapDesignParam);
        this.runExt(mapDesignParam);
    }

    public void execute(Map map) throws Exception {
        this.book = this.refreshBook();
        this.cacheDbSourceModel();
        HashMap sysPs = new HashMap();
        RunReportParam.putServerDefalutListParamsMap(this.ctx, sysPs);
        for (String name : sysPs.keySet()) {
            DesignParameter dp = (DesignParameter)((Object)sysPs.get(name));
            String value = dp.getCurentValue();
            int dataType = dp.getDesignDataType().intValue();
            ParameterImpl p = new ParameterImpl();
            p.setName(name);
            p.setAlias(dp.getAlias());
            p.setValue(RunReportParam.getVariant(value, dataType));
            p.setDataType(dataType);
            map.put(name, p);
        }
        ExecutionContext extCtx = this.book.getDataSetManager().getExecutionContext();
        if (extCtx != null) {
            extCtx.registerDataSetCacheObject((Object)BIContext, (Object)this.ctx);
            extCtx.registerDataSetCacheObject((Object)CurrentReportDBModel, (Object)this.reportDBModel);
            CacheObject co = new CacheObject();
            co.setSourceReportOrgID(this.sourceReportOrgID);
            extCtx.registerDataSetCacheObject((Object)CacheObject, (Object)CacheObject);
        }
        ExtURL.setConstructURL((IConstructURL)new ConstructURL(this.ctx));
        HashMap<ExtDataSetType, DataSetBaseFactory> mapFactories = new HashMap<ExtDataSetType, DataSetBaseFactory>();
        mapFactories.put(ExtDataSetType.TXT, new ExtDataSetTextFactory());
        mapFactories.put(ExtDataSetType.SQL_KSQL, ExtDataSetKSQLFactory.getInstance());
        mapFactories.put(ExtDataSetType.SQL_ENUM, ExtDataSetEnumFactory.getInstance());
        this.book.getDeps().setCalcDescription(this.ctx.getClientHostIP(), this.ctx.getUserName(), this.reportName);
        ExtExecutor.exec((Book)this.book, mapFactories, (Map)map, null);
        Sheet sheet = this.book.getActiveSheet();
        UserObject colTreePos = sheet.getUserObject("COLUMN_INLINED_TREE_POSITION");
        UserObject rowTreePos = sheet.getUserObject("ROW_INLINED_TREE_POSITION");
        if (!this._isTree) {
            this._isTree = colTreePos != null ^ rowTreePos != null;
        }
    }

    public void executeSchedule(HashMap mapDesignParam) throws IOException, KDFException, KDFSAXException, Exception {
        this.book = this.refreshBook();
        this.cacheDbSourceModel();
        this.runExt(mapDesignParam);
    }

    public void executeBook(HashMap mapDesignParam) throws IOException, KDFException, KDFSAXException, Exception {
        this.book = this.beforeExecuteBook();
        this.cacheDbSourceModel();
        this.runExt(mapDesignParam);
    }

    private void runExt(HashMap mapDesignParam) throws Exception {
        HashMap<ExtDataSetType, DataSetBaseFactory> mapFactories = new HashMap<ExtDataSetType, DataSetBaseFactory>();
        mapFactories.put(ExtDataSetType.TXT, new ExtDataSetTextFactory());
        mapFactories.put(ExtDataSetType.SQL_KSQL, ExtDataSetKSQLFactory.getInstance());
        mapFactories.put(ExtDataSetType.SQL_ENUM, ExtDataSetEnumFactory.getInstance());
        HashMap<String, ParameterImpl> mapParameterImpl = new HashMap<String, ParameterImpl>();
        for (String name : mapDesignParam.keySet()) {
            DesignParameter dp = (DesignParameter)((Object)mapDesignParam.get(name));
            String value = dp.getCurentValue();
            String dataType = String.valueOf(dp.getDesignDataType().intValue());
            ParameterImpl p = new ParameterImpl();
            p.setName(name);
            p.setValue(RunReportParam.getVariant(value, Integer.parseInt(dataType)));
            p.setDataType(Integer.parseInt(dataType));
            mapParameterImpl.put(name, p);
        }
        ExecutionContext extCtx = this.book.getDataSetManager().getExecutionContext();
        if (extCtx != null) {
            extCtx.registerDataSetCacheObject((Object)BIContext, (Object)this.ctx);
            extCtx.registerDataSetCacheObject((Object)CurrentReportDBModel, (Object)this.reportDBModel);
            CacheObject co = new CacheObject();
            co.setSourceReportOrgID(this.sourceReportOrgID);
            extCtx.registerDataSetCacheObject((Object)CacheObject, (Object)CacheObject);
        }
        ExtURL.setConstructURL((IConstructURL)new ConstructURL(this.ctx));
        this.book.getDeps().setCalcDescription(this.ctx.getClientHostIP(), this.ctx.getUserName(), this.reportName);
        ExtExecutor.exec((Book)this.book, mapFactories, mapParameterImpl, null);
    }

    private Book beforeExecuteBook() throws IOException, KDFException, KDFSAXException, Exception {
        DefineReportInfo info = null;
        info = this.systemID == null ? DefineReportBO.getReportInfo(this.ctx, this.reportID) : DefineReportBO.getReportInfo(this.ctx, this.systemID, this.reportName, this.orgID);
        if (null == info) {
            throw new Exception("\u62a5\u8868\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u7ec4\u7ec7\u9694\u79bb\u6216\u8005\u5b50\u7cfb\u7edf\u8def\u5f84\u3001\u540d\u79f0\u662f\u5426\u6539\u53d8");
        }
        this.reportID = info.getId().toString();
        this.systemID = info.getSystemID();
        this.reportName = info.getName();
        this.orgID = info.getOrgID().toString();
        byte[] bContent = info.getContent();
        int stdProduct = info.getIsStdProduct();
        if (stdProduct == 1) {
            boolean isStdProduct = BookIOUtil.hasValidCoupon((byte[])bContent, (boolean)true);
            if (!isStdProduct) {
                throw new Exception("\u5f53\u524d\u6807\u8bc6\u4e3a\u6807\u51c6\u4ea7\u54c1\u7684\u62a5\u8868\uff0c\u52a0\u5bc6\u4fe1\u606f\u5df2\u7ecf\u7834\u574f,\u8bf7\u91cd\u65b0\u5bfc\u5165\u6807\u51c6\u62a5\u8868");
            }
            if (!this._isChecked) {
                String className = info.getMenuUi();
                if (!StringUtil.isEmptyString((String)className)) {
                    ReportCenterLicenseSrvChecker licenseChecker = new ReportCenterLicenseSrvChecker(className, this.ctx);
                    licenseChecker.checkLicense();
                }
                this._isChecked = true;
            }
        } else if (!this._isChecked) {
            ILicenseChecker licChecker = this.getLicenseChecker(info);
            if (licChecker instanceof ReportCenterLicenseSrvChecker) {
                EXTLicenseService licSrsv = new EXTLicenseService(this.ctx);
                try {
                    if ((licSrsv.sysLicenseModuleType() & 2) == 0) {
                        throw new Exception("\u6ca1\u6709EAS\u3010\u62a5\u8868\u4e2d\u5fc3\u3011\u6a21\u5757\u7684License;\u8bf7\u5148\u8d2d\u4e70\u3010\u62a5\u8868\u4e2d\u5fc3\u3011\u6a21\u5757\u3002");
                    }
                }
                catch (EXTLicenseException e) {
                    logger.info((Object)"\u62a5\u8868\u4e2d\u5fc3\u68c0\u67e5License\u5931\u8d25", (Throwable)e);
                    throw new Exception("\u68c0\u67e5License\u5931\u8d25");
                }
            }
            licChecker.checkLicense();
            this._isChecked = true;
        }
        this.sourceReportOrgID = info.getOrgID().toString();
        Book book = BookIOUtil.unpack((byte[])info.getContent());
        if (null == book) {
            throw new Exception("unpack\u6a21\u677f\u4e3a\u7a7a");
        }
        return book;
    }

    private Book refreshBook() throws Exception {
        String orgId;
        DefineReportInfo info = null;
        info = this.systemID == null ? DefineReportBO.getReportInfo(this.ctx, this.reportID) : DefineReportBO.getReportInfo(this.ctx, this.systemID, this.reportName, this.orgID);
        if (null == info) {
            throw new Exception("\u62a5\u8868\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u7ec4\u7ec7\u9694\u79bb\u6216\u8005\u5b50\u7cfb\u7edf\u8def\u5f84\u3001\u540d\u79f0\u662f\u5426\u6539\u53d8");
        }
        this.reportID = info.getId().toString();
        this.systemID = info.getSystemID();
        this.reportName = info.getName();
        this.orgID = info.getOrgID().toString();
        String userId = this.ctx.getCaller().toString();
        boolean isPermission = PermissionBO.hasDataPermissionByReportId(this.ctx, userId, orgId = ContextUtil.getCurrentOrgUnit((Context)this.ctx).getId().toString(), this.reportID, PermissionKind.VIEW);
        if (!isPermission) {
            throw new Exception("\u6ca1\u6709\u67e5\u770b\u62a5\u8868\u7684\u6743\u9650");
        }
        String easPath = CtrlReportUtil.getObjectString(info.getMenuID());
        String bIPath = CtrlReportUtil.getObjectString(info.getBIPath());
        String portletID = CtrlReportUtil.getObjectString(info.getPortletID());
        if (easPath.equals("") && bIPath.equals("") && portletID.equals("")) {
            throw new Exception("\u62a5\u8868\u5df2\u7ecf\u64a4\u9500\u53d1\u5e03");
        }
        byte[] bContent = info.getContent();
        int stdProduct = info.getIsStdProduct();
        if (stdProduct == 1) {
            boolean isStdProduct = BookIOUtil.hasValidCoupon((byte[])bContent, (boolean)true);
            if (!isStdProduct) {
                throw new Exception("\u5f53\u524d\u6807\u8bc6\u4e3a\u6807\u51c6\u4ea7\u54c1\u7684\u62a5\u8868\uff0c\u52a0\u5bc6\u4fe1\u606f\u5df2\u7ecf\u7834\u574f,\u8bf7\u91cd\u65b0\u5bfc\u5165\u6807\u51c6\u62a5\u8868");
            }
            if (!this._isChecked) {
                String className = info.getMenuUi();
                if (!StringUtil.isEmptyString((String)className)) {
                    ReportCenterLicenseSrvChecker licenseChecker = new ReportCenterLicenseSrvChecker(className, this.ctx);
                    licenseChecker.checkLicense();
                }
                this._isChecked = true;
            }
        } else if (!this._isChecked) {
            ILicenseChecker licChecker = this.getLicenseChecker(info);
            if (licChecker instanceof ReportCenterLicenseSrvChecker) {
                EXTLicenseService licSrsv = new EXTLicenseService(this.ctx);
                try {
                    if ((licSrsv.sysLicenseModuleType() & 2) == 0) {
                        throw new Exception("\u6ca1\u6709EAS\u3010\u62a5\u8868\u4e2d\u5fc3\u3011\u6a21\u5757\u7684License\uff1b\u8bf7\u5148\u8d2d\u4e70\n\u3010\u62a5\u8868\u4e2d\u5fc3\u3011\u6a21\u5757\u3002");
                    }
                }
                catch (EXTLicenseException e) {
                    logger.info((Object)"\u62a5\u8868\u4e2d\u5fc3\u68c0\u67e5License\u5931\u8d25", (Throwable)e);
                    throw new Exception("\u68c0\u67e5License\u5931\u8d25");
                }
            }
            licChecker.checkLicense();
            this._isChecked = true;
        }
        this.sourceReportOrgID = info.getOrgID().toString();
        Book book = BookIOUtil.unpack((byte[])info.getContent());
        if (null == book) {
            throw new Exception("unpack\u6a21\u677f\u4e3a\u7a7a");
        }
        return book;
    }

    private ILicenseChecker getLicenseChecker(DefineReportInfo entity) {
        if (this._licenseChecker == null) {
            this._licenseChecker = LicenseCheckerFactory.getLicenseChecker(entity, this.ctx);
        }
        return this._licenseChecker;
    }

    private Element makeFilterItem(DesignParameter p) throws CtrlReportException, Exception {
        String defaultAlias;
        String defaultValue;
        InputType inputType = p.getInputType();
        if (inputType.equals(InputType.Separator) || inputType.equals(InputType.EMPTY)) {
            return null;
        }
        Element filterItemElement = new Element(T_FilterItem);
        IInputCtrl inputCtrl = p.getInputCtrl();
        filterItemElement.setAttribute(A_isReadOnly, Boolean.toString(p.getInputState() != InputState.READONLY));
        if (inputType.equals(InputType.INPUT) || inputType.equals(InputType.DATE) || inputType.equals(InputType.Spinner)) {
            DesignDataType ddt = p.getDesignDataType();
            String defalutValue = CtrlReportUtil.getObjectString(p.getDefaultValue());
            String msg = "";
            filterItemElement.setAttribute(A_type, "input");
            if (inputType.equals(InputType.DATE)) {
                filterItemElement.setAttribute(A_dataType, "date");
                if (ddt.equals(DesignDataType.DATE)) {
                    defalutValue = RunReportParam.getDateValue(this.ctx, ddt, defalutValue);
                } else if (ddt.equals(DesignDataType.DATETIME)) {
                    msg = "\u4e0d\u652f\u6301\u65e5\u671f\u65f6\u95f4\u7c7b\u578b)";
                    defalutValue = "";
                } else if (ddt.equals(DesignDataType.TIME)) {
                    msg = "\u4e0d\u652f\u6301\u65f6\u95f4\u7c7b\u578b)";
                    defalutValue = "";
                }
            } else {
                filterItemElement.setAttribute(A_dataType, "string");
            }
            if (!msg.equals("")) {
                msg = "(" + msg;
            }
            filterItemElement.setAttribute(A_name, p.getName());
            filterItemElement.setAttribute(A_caption, CtrlReportUtil.getObjectString(p.getAlias(Locale.CHINA)) + msg);
            filterItemElement.setAttribute(A_required, Boolean.toString(!p.isAllowNull()));
            filterItemElement.setAttribute(A_defaultValue, defalutValue);
            filterItemElement.setAttribute(A_defalutAlias, defalutValue);
        }
        if (inputType.equals(InputType.ALONE_CHECKBOX)) {
            filterItemElement.setAttribute(A_type, "list");
            filterItemElement.setAttribute(A_name, p.getName());
            filterItemElement.setAttribute(A_caption, p.getAlias(Locale.CHINA));
            filterItemElement.setAttribute(A_required, Boolean.toString(!p.isAllowNull()));
            defaultValue = CtrlReportUtil.getObjectString(p.getDefaultValue());
            defaultAlias = CtrlReportUtil.getObjectString(p.getDefaultAlias());
            filterItemElement.setAttribute(A_defaultValue, defaultValue);
            filterItemElement.setAttribute(A_defalutAlias, defaultAlias);
            inputCtrl = p.getInputCtrl();
            if (null != inputCtrl) {
                filterItemElement.setAttribute(A_isAllowMultipleSelected, "false");
                DefObj defSelected = inputCtrl.getDefValue();
                WebParamAdapter.makeParameterListItem(filterItemElement, defSelected);
                if (defaultValue.equals(String.valueOf(1))) {
                    filterItemElement.setAttribute(A_defaultValue, defSelected.getName());
                    filterItemElement.setAttribute(A_defalutAlias, defSelected.getAlias());
                }
                DefObj defNoSelected = inputCtrl.getDefDisplay();
                WebParamAdapter.makeParameterListItem(filterItemElement, defNoSelected);
                if (defaultValue.equals(String.valueOf(2))) {
                    filterItemElement.setAttribute(A_defaultValue, defNoSelected.getName());
                    filterItemElement.setAttribute(A_defalutAlias, defNoSelected.getAlias());
                }
            }
        }
        if (inputType.equals(InputType.LIST) || inputType.equals(InputType.CHECKBOX)) {
            filterItemElement.setAttribute(A_type, "list");
            filterItemElement.setAttribute(A_name, p.getName());
            filterItemElement.setAttribute(A_caption, p.getAlias(Locale.CHINA));
            filterItemElement.setAttribute(A_required, Boolean.toString(!p.isAllowNull()));
            defaultValue = CtrlReportUtil.getObjectString(p.getDefaultValue());
            defaultAlias = CtrlReportUtil.getObjectString(p.getDefaultAlias());
            filterItemElement.setAttribute(A_defaultValue, defaultValue);
            filterItemElement.setAttribute(A_defalutAlias, defaultAlias);
            inputCtrl = p.getInputCtrl();
            if (null != inputCtrl) {
                if (inputType.equals(InputType.LIST)) {
                    filterItemElement.setAttribute(A_isAllowMultipleSelected, "false");
                } else {
                    filterItemElement.setAttribute(A_isAllowMultipleSelected, "true");
                }
                int bind = inputCtrl.getDataBind();
                if (bind == 0) {
                    boolean isKSQL;
                    String displayKey = "alias";
                    String valueKey = A_value;
                    String tableFlag = inputCtrl.getDataSetType();
                    boolean bl = isKSQL = !tableFlag.equals("6");
                    if (isKSQL) {
                        displayKey = inputCtrl.getDefDisplay().getName();
                        valueKey = inputCtrl.getDefValue().getName();
                    }
                    DefObj def = inputCtrl.getDefDbsource();
                    String fid = def.getName();
                    if (isKSQL) {
                        String dbsourcename = def.getAlias();
                        String systemid = CtrlReportUtil.getObjectString(def.getProperty("systemID"));
                        if (!systemid.equals("")) {
                            fid = fid + "\\" + systemid + "\\" + dbsourcename;
                        }
                    }
                    ArrayList lst = this.getBizDataList(isKSQL, fid);
                    for (HashMap mapitem : lst) {
                        DefObj defItem = new DefObj();
                        defItem.setName(CtrlReportUtil.getObjectString(mapitem.get(valueKey.toLowerCase())));
                        defItem.setAlias(CtrlReportUtil.getObjectString(mapitem.get(displayKey.toLowerCase())));
                        WebParamAdapter.makeParameterListItem(filterItemElement, defItem);
                    }
                } else if (bind == 1) {
                    ArrayList selfList = inputCtrl.getSelfList();
                    for (DefObj defItem : selfList) {
                        WebParamAdapter.makeParameterListItem(filterItemElement, defItem);
                    }
                }
            }
        }
        if (inputType.equals(InputType.F7LIST)) {
            inputCtrl = p.getInputCtrl();
            int bind = inputCtrl.getDataBind();
            if (bind == 5) {
                filterItemElement.setAttribute(A_errMsg, p.getAlias(Locale.CHINA) + " \u662f\u4ee3\u7801\u5b9a\u5236\u7684F7\u63a7\u4ef6\uff0c\u4e0d\u80fd\u8f6c\u6362\uff01");
            }
            filterItemElement.setAttribute(A_type, "sql");
            filterItemElement.setAttribute(A_name, p.getName());
            filterItemElement.setAttribute(A_caption, p.getAlias(Locale.CHINA));
            filterItemElement.setAttribute(A_required, Boolean.toString(!p.isAllowNull()));
            filterItemElement.setAttribute(A_defaultValue, CtrlReportUtil.getObjectString(p.getDefaultValue()));
            filterItemElement.setAttribute(A_defalutAlias, CtrlReportUtil.getObjectString(p.getDefaultAlias()));
            if (null != inputCtrl) {
                filterItemElement.setAttribute(A_isAllowMultipleSelected, Boolean.toString(inputCtrl.isAllowMultipleSelected()));
                filterItemElement.setAttribute(A_valueColumn, RunReportParam.getRealFieldName(inputCtrl.getDefValue()));
                filterItemElement.setAttribute(A_displayColumn, RunReportParam.getRealFieldName(inputCtrl.getDefDisplay()));
                if (inputCtrl.isAllowMultipleSelected()) {
                    filterItemElement.setAttribute("rowLimit", inputCtrl.getRowLimit());
                }
                DefObj def = inputCtrl.getDefDbsource();
                String fid = def.getName();
                if (bind == 4) {
                    String dbsourcename = def.getAlias();
                    String systemid = CtrlReportUtil.getObjectString(def.getProperty("systemID"));
                    if (!systemid.equals("")) {
                        fid = fid + "\\" + systemid + "\\" + dbsourcename;
                    }
                }
                filterItemElement.setAttribute(A_fullname, fid);
            }
        }
        return filterItemElement;
    }

    private static final void makeParameterListItem(Element fatherEle, DefObj def) {
        Element element = new Element(T_ListItem);
        element.setAttribute(A_caption, CtrlReportUtil.getObjectString(def.getAlias()));
        element.setAttribute(A_value, def.getName());
        fatherEle.addContent(element);
    }

    public String getF7Data(String fullName, String displayColumn, String valueColumn) throws Exception {
        Element listItemElement = new Element(T_ListItem);
        String value = valueColumn;
        String display = displayColumn;
        ArrayList lst = new ArrayList();
        if (fullName.equals(String.valueOf(SystemVarType.ExtRptCurrentBizOrg.intValue()))) {
            lst = OrgRangeManage.getOrgRangeDataList(this.ctx, this.ctx.getCaller().toString());
        } else if (fullName.indexOf(".") == -1 || fullName.indexOf("\\") > -1) {
            lst = this.getBizDataList(true, fullName);
        } else if (!CtrlReportUtil.getObjectString(valueColumn).equals("")) {
            IRowSet rs = null;
            MetaDataPK queryPK = new MetaDataPK(fullName);
            IQueryExecutor queryExecutor = QueryExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)queryPK);
            rs = queryExecutor.executeQuery(0, Integer.MAX_VALUE);
            lst = ExtDBUtil.setDataToList((ResultSet)rs);
        } else {
            lst = this.getBizDataList(false, fullName);
            value = A_value;
            display = "alias";
        }
        value = value.toLowerCase();
        display = display.toLowerCase();
        for (HashMap mapitem : lst) {
            DefObj defItem = new DefObj();
            defItem.setName(CtrlReportUtil.getObjectString(mapitem.get(value)));
            defItem.setAlias(CtrlReportUtil.getObjectString(mapitem.get(display)));
            WebParamAdapter.makeParameterListItem(listItemElement, defItem);
        }
        XMLOutputter outter = new XMLOutputter("\t", true, "UTF-8");
        String xmlstr = outter.outputString(listItemElement);
        return xmlstr;
    }

    private ArrayList getBizDataList(boolean isKSQL, String dbsourceid) throws Exception {
        String orgID = this.orgID;
        if (StringUtil.isEmptyString((String)orgID)) {
            DefineReportInfo info = null;
            info = this.systemID == null ? DefineReportBO.getReportInfo(this.ctx, this.reportID) : DefineReportBO.getReportInfo(this.ctx, this.systemID, this.reportName, orgID);
            if (null == info) {
                throw new Exception("\u62a5\u8868\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u7ec4\u7ec7\u9694\u79bb\u6216\u8005\u5b50\u7cfb\u7edf\u8def\u5f84\u3001\u540d\u79f0\u662f\u5426\u6539\u53d8");
            }
            orgID = info.getOrgID().toString();
        }
        String orgName = ContextUtil.getCurrentOrgUnit((Context)this.ctx).getName().toString();
        return RunReportParam.getBizDataList(this.ctx, isKSQL, dbsourceid, orgID, orgName, this._sqlDbMap);
    }

    private boolean cacheDbSourceModel() throws Exception {
        ExtDataSetManager dm = this.book.getDataSetManager();
        int dsSize = dm.size();
        ExtDataSet[] datasets = new ExtDataSet[dsSize];
        if (!this._initSqlDbMap) {
            this._sqlDbMap = new HashMap(10);
        }
        for (int i = 0; i < dsSize; ++i) {
            Map map;
            datasets[i] = dm.getAt(i);
            if (this._initSqlDbMap || StringUtil.isEmptyString((String)datasets[i].getMeta()) || (map = (Map)SqlDSModelDrill.split(datasets[i].getMeta())[1]) == null || map.isEmpty()) continue;
            this._sqlDbMap.putAll(map);
        }
        this._initSqlDbMap = true;
        return RunReportParam.cacheDbSourceModel(this.ctx, datasets, this.reportDBModel, this.allUnionParam, null, this.sourceReportOrgID, ContextUtil.getCurrentOrgUnit((Context)this.ctx).getId().toString());
    }

    public Book getBook() {
        return this.book;
    }

    public Sheet getPartSheet(int row1, int row2) {
        Sheet sheet = this.book.getActiveSheet();
        if (this._isTree) {
            return sheet;
        }
        Sheet.ICellsIterator itor = sheet.getCellsIterator(0, 0, sheet.getMaxRowIndex(), sheet.getMaxColIndex(), false, false);
        while (itor.hasNext()) {
            Cell cll = itor.next();
            cll.getText();
        }
        boolean isSecurity = SheetBaseMath.isSecuritySheet((Sheet)sheet);
        if (isSecurity) {
            AlgorithmUtil.delHideRowsAndCols((int[])sheet.getSecHidedRows(), (int[])sheet.getSecHidedCols(), (Sheet)sheet);
            sheet.clearHiddenRowsNCols();
        }
        return sheet;
    }

    public String getReportID() {
        return this.reportID;
    }

    public boolean isTree() {
        return this._isTree;
    }

    public void setTree(boolean istree) {
        this._isTree = istree;
    }
}

