/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.snapshot.dispatch.codingrule.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.base.reportmeta.snapshot.dispatch.codingrule.pojo.MaxSerialInfo;
import com.kingdee.eas.base.reportmeta.snapshot.dispatch.codingrule.server.ICodingRuleDAO;
import com.kingdee.eas.base.reportmeta.snapshot.dispatch.codingrule.server.impl.CodingRuleDAOImpl;
import com.kingdee.eas.base.reportmeta.snapshot.dispatch.codingrule.util.CodingRuleUtil;
import com.kingdee.eas.base.reportmeta.snapshot.dispatch.pojo.DispatchSysVariable;
import com.kingdee.eas.base.reportmeta.snapshot.dispatch.util.DispatchCommonUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CodingRuleNumGenerator {
    private Context _ctx;
    private StringBuffer _errorMsg;
    private String _curLocale;
    private List _dispList;
    private HashMap _mapSystemParam;
    private MaxSerialInfo _maxSeialInfo;
    private ICodingRuleDAO _dao;

    public CodingRuleNumGenerator(Context ctx, String curLocale, List dispList, HashMap mapSystemParam) {
        this._ctx = ctx;
        this._errorMsg = new StringBuffer();
        this._curLocale = curLocale;
        this._dispList = dispList;
        this._mapSystemParam = mapSystemParam;
        this._dao = new CodingRuleDAOImpl();
    }

    public synchronized String generateNameBaseCodingRule() throws IllegalArgumentException, SecurityException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, BOSException {
        StringBuffer name = new StringBuffer();
        for (int i = 0; i < this._dispList.size(); ++i) {
            Map _dispatchMap = (Map)this._dispList.get(i);
            int type = ((Number)_dispatchMap.get("ftype")).intValue();
            String attribute = (String)_dispatchMap.get("fattributevalue");
            String prefix = (String)_dispatchMap.get("fprefix");
            String suffix = (String)_dispatchMap.get("fsuffix");
            String seperator = (String)_dispatchMap.get("fseparator");
            String entryCodeRuleId = (String)_dispatchMap.get("entryid");
            if (!StringUtil.isEmptyString((String)prefix)) {
                name.append(prefix);
            }
            switch (type) {
                case 0: {
                    name.append(attribute);
                    break;
                }
                case 1: {
                    String sysVar = this.getSysVariable(attribute);
                    if (StringUtil.isEmptyString((String)sysVar)) break;
                    name.append(sysVar);
                    break;
                }
                case 2: {
                    name.append(DispatchCommonUtil.getFormatedDate(attribute));
                    break;
                }
                case 3: {
                    String num = this.getSequenceNum(attribute, entryCodeRuleId);
                    if (this._errorMsg.length() > 0) break;
                    name.append(num);
                    break;
                }
            }
            if (!StringUtil.isEmptyString((String)suffix)) {
                name.append(suffix);
            }
            if (StringUtil.isEmptyString((String)seperator)) continue;
            name.append(seperator);
        }
        return name.toString();
    }

    public synchronized String getSysVariable(String attribute) {
        String key = DispatchSysVariable.getSysVariableValue(attribute);
        DesignParameter dp = (DesignParameter)((Object)this._mapSystemParam.get(key));
        String sysVariable = attribute;
        if (dp != null) {
            sysVariable = dp.getCurentValue();
        }
        return sysVariable;
    }

    public synchronized long generateSequenceNumber(String attribute, String entryCodeRuleId) throws BOSException {
        long step;
        long initial;
        this._maxSeialInfo = this._dao.getMaxSerialInfo(this._ctx, entryCodeRuleId);
        String[] sequence = attribute.split("-");
        long length = Long.parseLong(sequence[0]);
        if (!this.validate(length, initial = Long.parseLong(sequence[1]), step = Long.parseLong(sequence[2]))) {
            return 0L;
        }
        if (this._maxSeialInfo == null) {
            this._maxSeialInfo = new MaxSerialInfo();
            this._maxSeialInfo.setFirstCreate(true);
            this._maxSeialInfo.setCodingRuleEntryId(entryCodeRuleId);
            this._maxSeialInfo.setSerialNumber(initial);
            return initial;
        }
        this._maxSeialInfo.setFirstCreate(false);
        this._maxSeialInfo.setCodingRuleEntryId(entryCodeRuleId);
        long curNum = this._maxSeialInfo.getSerialNumber();
        long num = curNum + step;
        this._maxSeialInfo.setSerialNumber(num);
        return num;
    }

    public synchronized String getSequenceNum(String attribute, String entryCodeRuleId) throws BOSException {
        long num = this.generateSequenceNumber(attribute, entryCodeRuleId);
        String[] sequence = attribute.split("-");
        long length = Long.parseLong(sequence[0]);
        return CodingRuleUtil.getSequenceNum(num, length);
    }

    private boolean validate(long length, long initial, long step) {
        if (this._maxSeialInfo == null) {
            return CodingRuleUtil.validateNumber(initial, length, this._errorMsg);
        }
        long serialNum = this._maxSeialInfo.getSerialNumber();
        return CodingRuleUtil.validateNumber(serialNum + step, length, this._errorMsg);
    }

    public Context get_ctx() {
        return this._ctx;
    }

    public void set_ctx(Context ctx) {
        this._ctx = ctx;
    }

    public StringBuffer get_errorMsg() {
        return this._errorMsg;
    }

    public void set_errorMsg(StringBuffer errorMsg) {
        this._errorMsg = errorMsg;
    }

    public String get_curLocale() {
        return this._curLocale;
    }

    public void set_curLocale(String curLocale) {
        this._curLocale = curLocale;
    }

    public List get_dispList() {
        return this._dispList;
    }

    public void set_dispList(List dispList) {
        this._dispList = dispList;
    }

    public HashMap get_mapSystemParam() {
        return this._mapSystemParam;
    }

    public void set_mapSystemParam(HashMap mapSystemParam) {
        this._mapSystemParam = mapSystemParam;
    }

    public MaxSerialInfo get_maxSeialInfo() {
        return this._maxSeialInfo;
    }

    public void set_maxSeialInfo(MaxSerialInfo maxSeialInfo) {
        this._maxSeialInfo = maxSeialInfo;
    }

    public ICodingRuleDAO get_dao() {
        return this._dao;
    }

    public void set_dao(ICodingRuleDAO dao) {
        this._dao = dao;
    }
}

