/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.snapshot.manage.server.mailbox.impl;

import com.kingdee.bos.ctrl.extcommon.server.DbUtil;
import com.kingdee.bos.ctrl.extcommon.server.ServerUtil;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.reportmeta.snapshot.manage.exception.IllegalParameterException;
import com.kingdee.eas.base.reportmeta.snapshot.manage.exception.ShortcutMailboxException;
import com.kingdee.eas.base.reportmeta.snapshot.manage.pojo.PhantomSnapshot;
import com.kingdee.eas.base.reportmeta.snapshot.manage.pojo.ShortcutMailReadState;
import com.kingdee.eas.base.reportmeta.snapshot.manage.pojo.so.ReportGroupItem;
import com.kingdee.eas.base.reportmeta.snapshot.manage.server.mailbox.ISSMailboxDAO;
import com.kingdee.eas.base.reportmeta.sumreport.util.EASUtil;
import com.kingdee.eas.base.reportmeta.sumreport.util.MixUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class SSMailboxDAO
implements ISSMailboxDAO {
    private String _userID = EASUtil.getCurrentUserID(ServerUtil.getContext());

    public int getUnReadCount() throws ShortcutMailboxException {
        IRowSet rs;
        block4: {
            int n;
            StringBuffer sqlBuf = new StringBuffer("Select count(fid) as FRowCount from T_EXT_SSSHORTCUTSBOX where Faddressee = ? AND Fread = ?");
            rs = null;
            try {
                rs = DbUtil.executeQuery((String)sqlBuf.toString(), (Object[])new Object[]{this._userID, ShortcutMailReadState.UNREAD_OBJ});
                if (!rs.next()) break block4;
                n = rs.getInt("FRowCount");
            }
            catch (SQLException e) {
                try {
                    throw ShortcutMailboxException.wrap(e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs);
            return n;
        }
        SQLUtils.cleanup((ResultSet)rs);
        return 0;
    }

    public List queryReportGroupItems(String reportID) throws ShortcutMailboxException {
        ArrayList<PhantomSnapshot> arrayList;
        StringBuffer buf = new StringBuffer();
        buf.append("Select top ").append(6);
        buf.append(" S.Fid,S.Fname,S.Fcreatorid,S.Fcreatetime,S.FsourceType,S.Freportperiod,S.Fweekbegin,S.Fbegindate,S.Fenddate,");
        buf.append("U.Fname_l2 As UserName, S.Freportid, S.FSharetime,S.FSnapshotID,S.Fread,S.FsenderID From T_ext_ssshortcutsbox S");
        buf.append(" LEFT OUTER JOIN T_pm_user U On S.FsenderID = U.Fid WHERE S.Faddressee = ? and S.FReportid = ? ");
        buf.append(" Order by S.fShareTime desc");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((String)buf.toString(), (Object[])new Object[]{this._userID, reportID});
            ArrayList<PhantomSnapshot> lst = new ArrayList<PhantomSnapshot>(rs.size());
            while (rs.next()) {
                PhantomSnapshot item = new PhantomSnapshot();
                item.setId(rs.getString("fid"));
                item.setName(rs.getString("fname"));
                item.setCreatorID(rs.getString("fcreatorid"));
                item.setCreateTime(rs.getTimestamp("fcreatetime"));
                item.setReportPeriod(rs.getInt("freportperiod"));
                item.setBeginDate(rs.getTimestamp("fbegindate"));
                item.setEndDate(rs.getTimestamp("fenddate"));
                item.setWeekBegin(rs.getInt("fweekbegin"));
                item.setSourceType(rs.getInt("fsourceType"));
                item.setSnapshotId(rs.getString("fsnapshotid"));
                item.setReportId(rs.getString("freportid"));
                item.setSenderName(rs.getString("username"));
                item.setSendTime(rs.getTimestamp("fsharetime"));
                item.setReadState(rs.getInt("fread"));
                item.setSender(rs.getString("fsenderid"));
                item.setFake(true);
                lst.add(item);
            }
            arrayList = lst;
        }
        catch (SQLException e) {
            try {
                throw ShortcutMailboxException.wrap(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return arrayList;
    }

    public List queryReportGroups() throws ShortcutMailboxException {
        ArrayList<ReportGroupItem> arrayList;
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("SELECT distinct sc.freportid, max(sc.FShareTime)as ShareTime , d.fname_l2 as name, min(sc.fread) as mixRead ");
        sqlBuf.append(" FROM T_ext_ssshortcutsbox sc LEFT OUTER JOIN T_RM_DefineReport d on sc.freportid = d.fid");
        sqlBuf.append(" WHERE  sc.Faddressee = ? ");
        sqlBuf.append(" group by sc.freportid,d.fname_l2 order by shareTime desc ");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((String)sqlBuf.toString(), (Object[])new Object[]{this._userID});
            ArrayList<ReportGroupItem> lst = new ArrayList<ReportGroupItem>(rs.size());
            while (rs.next()) {
                ReportGroupItem item = new ReportGroupItem();
                item.setId(rs.getString("freportid"));
                item.setName(rs.getString("name"));
                item.setHasUnread(rs.getInt("mixRead") == 0);
                lst.add(item);
            }
            arrayList = lst;
        }
        catch (SQLException e) {
            try {
                throw ShortcutMailboxException.wrap(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return arrayList;
    }

    public void updateReadStatus(String[] mailIds, int readStatus) throws ShortcutMailboxException {
        if (mailIds == null || mailIds.length == 0) {
            return;
        }
        StringBuffer sqlBuf = new StringBuffer("Update T_ext_SSshortcutsbox set fread = ? where fid in (");
        for (int i = 0; i < mailIds.length; ++i) {
            sqlBuf.append("?,");
        }
        sqlBuf.setCharAt(sqlBuf.length() - 1, ')');
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(ShortcutMailReadState.getObj(readStatus));
        params.addAll(Arrays.asList((Object[])mailIds));
        try {
            DbUtil.executeUpdate((String)sqlBuf.toString(), (Object[])params.toArray());
        }
        catch (SQLException e) {
            throw ShortcutMailboxException.wrap(e);
        }
    }

    public void updateReadStatusByReportID(String[] reportIDs, int readStatus) throws ShortcutMailboxException {
        if (reportIDs == null || reportIDs.length == 0) {
            return;
        }
        StringBuffer sqlBuf = new StringBuffer("Update T_ext_SSshortcutsbox set fread = ? where faddressee = ? AND freportid in (");
        for (int i = 0; i < reportIDs.length; ++i) {
            sqlBuf.append("?,");
        }
        sqlBuf.setCharAt(sqlBuf.length() - 1, ')');
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(ShortcutMailReadState.getObj(readStatus));
        params.add(this._userID);
        params.addAll(Arrays.asList((Object[])reportIDs));
        try {
            DbUtil.executeUpdate((String)sqlBuf.toString(), (Object[])params.toArray());
        }
        catch (SQLException e) {
            throw ShortcutMailboxException.wrap(e);
        }
    }

    public void delSnapshotMails(String[] mailIDs) throws ShortcutMailboxException {
        if (mailIDs == null || mailIDs.length == 0) {
            throw new IllegalParameterException("mailIDs\u53c2\u6570\u4e0d\u5e94\u8be5\u4e3aNULL,\u6216\u8005\u5143\u7d20\u4e2a\u6570\u4e3a0");
        }
        StringBuffer delBuf = new StringBuffer("Delete From T_ext_ssshortcutsbox Where Fid IN (");
        for (int i = 0; i < mailIDs.length; ++i) {
            delBuf.append("?,");
        }
        delBuf.setCharAt(delBuf.length() - 1, ')');
        try {
            DbUtil.executeUpdate((String)delBuf.toString(), (Object[])mailIDs);
        }
        catch (SQLException e) {
            throw ShortcutMailboxException.wrap(e);
        }
    }

    public void delSnapshotMailsByReportID(String[] reportIDs) throws ShortcutMailboxException {
        if (reportIDs == null || reportIDs.length == 0) {
            throw new IllegalParameterException("reportIDs\u53c2\u6570\u4e0d\u5e94\u8be5\u4e3aNULL,\u6216\u8005\u5143\u7d20\u4e2a\u6570\u4e3a0");
        }
        StringBuffer delBuf = new StringBuffer("Delete From T_ext_ssshortcutsbox Where Faddressee = ? And FReportID IN (");
        for (int i = 0; i < reportIDs.length; ++i) {
            delBuf.append("?,");
        }
        delBuf.setCharAt(delBuf.length() - 1, ')');
        try {
            ArrayList<String> params = new ArrayList<String>();
            params.add(this._userID);
            params.addAll(Arrays.asList((Object[])reportIDs));
            DbUtil.executeUpdate((String)delBuf.toString(), (Object[])params.toArray());
        }
        catch (SQLException e) {
            throw ShortcutMailboxException.wrap(e);
        }
    }

    public void insertSnapshotMails(List phantoms) throws ShortcutMailboxException {
        try {
            String[] sqls = new String[phantoms.size()];
            int size = phantoms.size();
            for (int i = 0; i < size; ++i) {
                sqls[i] = this.getSnapshotMailInsertSQL((PhantomSnapshot)phantoms.get(i));
            }
            DbUtil.executeBatchUpdate((String[])sqls);
        }
        catch (SQLException e) {
            throw ShortcutMailboxException.wrap(e);
        }
    }

    private String getSnapshotMailInsertSQL(PhantomSnapshot ps) {
        StringBuffer sqlBuf = new StringBuffer("Insert Into T_ext_ssshortcutsbox ( fid, Fread,FSENDERID, FShareTime,");
        sqlBuf.append("fcreatetime, fsourcetype, freportperiod,");
        if (ps.getReportPeriod() != -1) {
            sqlBuf.append("fweekbegin, fbegindate, fenddate,");
        }
        sqlBuf.append(" Faddressee,fcreatorid,forgid,fsnapshotid,freportid, fname");
        sqlBuf.append(")values(");
        sqlBuf.append('\'').append(ps.getId()).append("',");
        sqlBuf.append(0).append(",");
        sqlBuf.append('\'').append(ps.getSender()).append("',");
        sqlBuf.append("{ts'").append(MixUtil.getDateFromTimestamp(ps.getSendTime())).append("'},");
        sqlBuf.append("{ts'").append(MixUtil.getDateFromTimestamp(ps.getCreateTime())).append("'},");
        sqlBuf.append(ps.getSourceType()).append(",");
        sqlBuf.append(ps.getReportPeriod()).append(",");
        if (ps.getReportPeriod() != -1) {
            sqlBuf.append(ps.getWeekBegin()).append(",");
            sqlBuf.append("{ts'").append(MixUtil.getDateFromTimestamp(ps.getBeginDate())).append("'},");
            sqlBuf.append("{ts'").append(MixUtil.getDateFromTimestamp(ps.getEndDate())).append("'},");
        }
        sqlBuf.append('\'').append(ps.getUserId()).append("',");
        sqlBuf.append('\'').append(ps.getCreatorID()).append("',");
        sqlBuf.append('\'').append(ps.getOrgID()).append("',");
        sqlBuf.append('\'').append(ps.getSnapshotId()).append("',");
        sqlBuf.append('\'').append(ps.getReportId()).append("',");
        sqlBuf.append('\'').append(ps.getName()).append("'");
        sqlBuf.append(")");
        return sqlBuf.toString();
    }

    public List queryReportGroupItemsNotLimited(String reportID) throws ShortcutMailboxException {
        ArrayList<PhantomSnapshot> arrayList;
        StringBuffer buf = new StringBuffer();
        buf.append("Select ");
        buf.append(" S.Fid,S.Fname,S.Fcreatorid,S.Fcreatetime,S.FsourceType,S.Freportperiod,S.Fweekbegin,S.Fbegindate,S.Fenddate,");
        buf.append("U.Fname_l2 As UserName, S.Freportid, S.FSharetime,S.FSnapshotID,S.Fread,S.FsenderID From T_ext_ssshortcutsbox S");
        buf.append(" LEFT OUTER JOIN T_pm_user U On S.FsenderID = U.Fid WHERE S.Faddressee = ? and S.FReportid = ? ");
        buf.append(" Order by S.fShareTime desc");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((String)buf.toString(), (Object[])new Object[]{this._userID, reportID});
            ArrayList<PhantomSnapshot> lst = new ArrayList<PhantomSnapshot>(rs.size());
            while (rs.next()) {
                PhantomSnapshot item = new PhantomSnapshot();
                item.setId(rs.getString("fid"));
                item.setName(rs.getString("fname"));
                item.setCreatorID(rs.getString("fcreatorid"));
                item.setCreateTime(rs.getTimestamp("fcreatetime"));
                item.setReportPeriod(rs.getInt("freportperiod"));
                item.setBeginDate(rs.getTimestamp("fbegindate"));
                item.setEndDate(rs.getTimestamp("fenddate"));
                item.setWeekBegin(rs.getInt("fweekbegin"));
                item.setSourceType(rs.getInt("fsourceType"));
                item.setSnapshotId(rs.getString("fsnapshotid"));
                item.setReportId(rs.getString("freportid"));
                item.setSenderName(rs.getString("username"));
                item.setSendTime(rs.getTimestamp("fsharetime"));
                item.setReadState(rs.getInt("fread"));
                item.setSender(rs.getString("fsenderid"));
                item.setFake(true);
                lst.add(item);
            }
            arrayList = lst;
        }
        catch (SQLException e) {
            try {
                throw ShortcutMailboxException.wrap(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return arrayList;
    }
}

