/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.sumreport.model;

import com.kingdee.bos.ctrl.kds.impl.facade.tip.AbstractTipPanel;
import com.kingdee.bos.ctrl.kds.impl.facade.tip.DefaultTipPanel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;

public class InfoMessagePanel
extends AbstractTipPanel
implements TimingTarget {
    private String tipString;
    public static final String TIP_STRING = "\u8bf7\u8bbe\u7f6e\u5c55\u793a\u4fe1\u606f";
    private Image image = InfoMessagePanel.createDefaultCloseImage(false);
    private Image mouseOnImage = InfoMessagePanel.createDefaultCloseImage(true);
    private URL url;
    private Dimension prefer;
    private Animator animator;
    private Component _targetPanel;
    private boolean isMouseIn = false;
    private Color background = new Color(255, 252, 193);
    private Color mouseOn = new Color(0, 0, 120);
    private Color textColor = new Color(255, 255, 255);
    private Popup closeTip;
    private Window w;
    private KDPanel _board;
    private int derection = 1;

    public InfoMessagePanel(String tipString, Component targetPanel, KDPanel board) {
        this.url = DefaultTipPanel.class.getResource("tip.wav");
        this.animator = new Animator(300, (TimingTarget)this);
        this.tipString = null != tipString ? tipString : TIP_STRING;
        this._targetPanel = targetPanel;
        this._board = board;
        this.prefer = new Dimension(targetPanel.getPreferredSize().width, 0);
        this.init();
        this.initListeners();
    }

    public void setBackGroundColor(Color color) {
        this.background = color;
    }

    public void setTipString(String message) {
        this.tipString = message;
    }

    private void init() {
    }

    private void initListeners() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int x = InfoMessagePanel.this.getWidth();
                if (x - e.getX() < 30 && e.getButton() == 1) {
                    InfoMessagePanel.this.hideTip();
                    InfoMessagePanel.this.setPreferredSize(new Dimension(0, 0));
                }
            }

            public void mouseEntered(MouseEvent e) {
                InfoMessagePanel.this.isMouseIn = true;
                InfoMessagePanel.this.repaint();
            }

            public void mouseExited(MouseEvent e) {
                InfoMessagePanel.this.isMouseIn = false;
                InfoMessagePanel.this.repaint();
                if (InfoMessagePanel.this.closeTip != null) {
                    InfoMessagePanel.this.closeTip.hide();
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){
            Cursor cur = Cursor.getPredefinedCursor(12);
            Cursor def = Cursor.getDefaultCursor();

            public void mouseMoved(MouseEvent e) {
                int x = InfoMessagePanel.this.getWidth();
                if (x - e.getX() < 30) {
                    InfoMessagePanel.this.setCursor(this.cur);
                    InfoMessagePanel.this.showCloseTip(true, e.getPoint());
                } else {
                    InfoMessagePanel.this.setCursor(this.def);
                    SwingUtilities.convertPointToScreen(e.getPoint(), (Component)((Object)InfoMessagePanel.this));
                    InfoMessagePanel.this.showCloseTip(false, e.getPoint());
                }
            }
        });
    }

    public void setPreferredSize(Dimension d) {
        this.prefer = d;
    }

    public Dimension getPreferredSize() {
        return this.prefer;
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        Composite c = g2.getComposite();
        if (!this.isMouseIn) {
            g2.setColor(this.background);
        } else {
            g2.setColor(this.mouseOn);
        }
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (!this.isMouseIn) {
            g2.setColor(Color.black);
        } else {
            g2.setColor(this.textColor);
        }
        g2.drawString(this.tipString, 10, 15);
        if (!this.isMouseIn) {
            g2.drawImage(this.image, this.getWidth() - 15, 4, null);
        } else {
            g2.drawImage(this.mouseOnImage, this.getWidth() - 15, 4, null);
        }
        g2.setComposite(c);
    }

    public synchronized void hideTip() {
        if (this.getHeight() > 0) {
            this.animator.stop();
            this.derection = -1;
            this.animator.setStartDirection(Animator.Direction.FORWARD);
            this.animator.start();
            if (this.closeTip != null) {
                this.closeTip.hide();
            }
            this.playSound();
        }
    }

    public synchronized void showTip() {
        if (this.getHeight() == 0) {
            this.animator.stop();
            this.derection = 1;
            this.animator.setStartDirection(Animator.Direction.FORWARD);
            this.animator.start();
            this.playSound();
        }
    }

    public URL getTipSoundURL() {
        return this.url;
    }

    public void timingEvent(float fraction) {
        this.prefer = new Dimension(this._board.getWidth(), (int)(10.0f * (1.0f + (float)this.derection * fraction)));
        Dimension d = this._board.getSize();
        this._board.setPreferredSize(new Dimension(d.width, d.height + this.getPreferredSize().height));
        if (this._targetPanel instanceof JComponent) {
            ((JComponent)this._targetPanel).revalidate();
        }
    }

    public synchronized void hideTipNOAnimate() {
        this.hideTip();
        this.setPreferredSize(new Dimension(0, 0));
        if (this._targetPanel instanceof JComponent) {
            ((JComponent)this._targetPanel).revalidate();
        }
    }

    public void begin() {
    }

    public void end() {
    }

    public void repeat() {
    }

    public static BufferedImage createDefaultCloseImage(boolean isMouseOn) {
        BufferedImage image = new BufferedImage(20, 20, 2);
        Graphics2D g2 = image.createGraphics();
        g2.setColor(new Color(255, 255, 255, 0));
        g2.setClip(new Rectangle(20, 20));
        g2.fillRect(0, 0, 20, 20);
        if (isMouseOn) {
            g2.setColor(Color.WHITE);
        } else {
            g2.setColor(Color.BLACK);
        }
        GeneralPath path = new GeneralPath();
        path.moveTo(0.0f, 2.0f);
        path.lineTo(2.0f, 0.0f);
        path.lineTo(12.0f, 10.0f);
        path.lineTo(10.0f, 12.0f);
        path.closePath();
        g2.setClip(path);
        g2.fill(path);
        path = new GeneralPath();
        path.moveTo(0.0f, 10.0f);
        path.lineTo(2.0f, 12.0f);
        path.lineTo(12.0f, 2.0f);
        path.lineTo(10.0f, 0.0f);
        path.closePath();
        g2.setClip(path);
        g2.fill(path);
        g2.dispose();
        return image;
    }

    private void showCloseTip(boolean show, Point p) {
        JToolTip tip = new JToolTip();
        tip.setTipText("\u5173\u95ed\u63d0\u793a\u6761");
        if (this.w == null) {
            this.w = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        }
        if (show) {
            if (this.closeTip != null) {
                this.closeTip.hide();
            }
            SwingUtilities.convertPointToScreen(p, (Component)((Object)this));
            this.closeTip = PopupFactory.getSharedInstance().getPopup(this.w, tip, p.x - 65, p.y - 30);
            this.closeTip.show();
        } else if (this.closeTip != null) {
            this.closeTip.hide();
        }
    }
}

