/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.sumreport.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.ORMRPCServiceLocator;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.eas.base.reportmeta.sumreport.data.BaseDataInfo;
import com.kingdee.eas.base.reportmeta.sumreport.data.SumRangeInfo;
import com.kingdee.eas.base.reportmeta.sumreport.data.SumUnitInfo;
import com.kingdee.eas.base.reportmeta.sumreport.data.SumUnitOrgInfo;
import com.kingdee.eas.base.reportmeta.sumreport.exceptions.SumRangeException;
import com.kingdee.eas.base.reportmeta.sumreport.model.InfoException;
import com.kingdee.eas.base.reportmeta.sumreport.server.ISumRangeBOFacade;
import com.kingdee.eas.base.reportmeta.sumreport.server.impl.SumRangeBOFacade;
import com.kingdee.eas.base.reportmeta.sumreport.service.inf.ISumUnitService;
import com.kingdee.eas.base.reportmeta.sumreport.util.EASUtil;
import com.kingdee.eas.base.reportmeta.sumreport.util.MixUtil;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class SumUnitService
implements ISumUnitService {
    private ISumRangeBOFacade _facade;

    private ISumRangeBOFacade getFacade() throws SumRangeException {
        if (this._facade == null) {
            String rpcUrl = ORMRPCServiceLocator.getCurrentServiceURL();
            try {
                this._facade = (ISumRangeBOFacade)BOSObjectFactory.createRemoteObject((String)rpcUrl, (String)SumRangeBOFacade.class.getName(), ISumRangeBOFacade.class);
            }
            catch (BOSException e) {
                throw SumRangeException.wrap("Initial summary task facade error.", (Exception)((Object)e));
            }
        }
        return this._facade;
    }

    public void newSumUnit(SumUnitInfo info) throws SumRangeException, InfoException {
        this.getFacade().insertSumUnit(info);
    }

    public void updateSumUnit(SumUnitInfo oVo, SumUnitInfo nVo) throws SumRangeException, InfoException {
        nVo.setLastUpdateTime(new Timestamp(new Date().getTime()));
        if (this.getFacade().isExistUnitName(nVo.getId(), nVo.getName(), EASUtil.gelLoginLocal(), oVo.getSumRangeID())) {
            throw new InfoException("\u5df2\u5b58\u5728\u8be5\u540d\u79f0\u7684\u6c47\u603b\u5355\u5143\uff0c\u8bf7\u66f4\u6539\u540d\u79f0", 3);
        }
        if (this.getFacade().isExistUnitNumber(nVo.getId(), nVo.getNumber(), oVo.getSumRangeID())) {
            throw new InfoException("\u5df2\u5b58\u5728\u8be5\u7f16\u7801\u7684\u6c47\u603b\u5355\u5143\uff0c\u8bf7\u66f4\u6539\u7f16\u7801", 2);
        }
        this.getFacade().updateSumUnit(nVo, oVo);
    }

    public void delSumUnit(SumUnitInfo vo) throws SumRangeException {
        this.getFacade().deleteSumUnit(vo);
    }

    public String addCompany(SumUnitOrgInfo[] infos) throws SumRangeException {
        ArrayList<SumUnitOrgInfo> unRef = new ArrayList<SumUnitOrgInfo>();
        StringBuffer msgBuf = new StringBuffer();
        boolean msgFlag = false;
        for (int i = 0; i < infos.length; ++i) {
            if (!this.getFacade().isOrgImport(infos[i])) {
                unRef.add(infos[i]);
                continue;
            }
            msgBuf.append("\u3010").append(infos[i].getOrgName()).append("\u3011").append(StringUtil.RETURN);
            msgFlag = true;
        }
        this.getFacade().insertUnitOrg(unRef);
        if (msgFlag) {
            msgBuf.append("\u4e4b\u524d\u5df2\u7ecf\u88ab\u5f15\u5165\uff0c\u4e0d\u53ef\u91cd\u590d\u5f15\u5165\uff01");
        }
        return msgBuf.toString();
    }

    public void delCompany(SumUnitOrgInfo info) throws SumRangeException {
        this.getFacade().deleteUnitOrg(info.getOrgID(), info.getSumUnitID());
    }

    public boolean isExistUnitName(SumUnitInfo info) throws SumRangeException {
        return this.getFacade().isExistUnitName(info.getId(), info.getName(), EASUtil.gelLoginLocal(), info.getSumRangeID());
    }

    public boolean isExistUnitNumber(SumUnitInfo info) throws SumRangeException {
        return this.getFacade().isExistUnitNumber(info.getId(), info.getNumber(), info.getSumRangeID());
    }

    public SumUnitInfo buildSumUnitTree(String rangeId) throws SumRangeException {
        String local = EASUtil.gelLoginLocal();
        List rsL = this.getFacade().getCurrentOrgUnitListByRangeID(rangeId, local);
        SumUnitInfo rootUnit = null;
        if (null != rsL && rsL.size() >= 1) {
            rootUnit = new SumUnitInfo();
            Map item = (Map)rsL.get(0);
            rootUnit.setName(MixUtil.toString(item.get("name")), local);
            rootUnit.setId(MixUtil.toString(item.get("id")));
            rootUnit.setLongNumber(MixUtil.toString(item.get("longnumber")));
            rootUnit.setManageOrgID(MixUtil.toString(item.get("manageorgid")));
            rootUnit.setDes(MixUtil.toString(item.get("dec")), local);
            rootUnit.setNumber(MixUtil.toString(item.get("num")));
            rootUnit.setManageOrgName(MixUtil.toString(item.get("orgname")));
            rootUnit.setOrgNumber(MixUtil.toString(item.get("orgnumber")));
            HashMap<String, SumUnitInfo> cache = new HashMap<String, SumUnitInfo>();
            cache.put(rootUnit.getId(), rootUnit);
            int size = rsL.size();
            for (int i = 1; i < size; ++i) {
                item = (Map)rsL.get(i);
                SumUnitInfo uItem = new SumUnitInfo();
                uItem.setName(MixUtil.toString(item.get("name")), local);
                uItem.setId(MixUtil.toString(item.get("id")));
                uItem.setLongNumber(MixUtil.toString(item.get("longnumber")));
                uItem.setManageOrgID(MixUtil.toString(item.get("manageorgid")));
                uItem.setDes(MixUtil.toString(item.get("dec")), local);
                uItem.setParentID(MixUtil.toString(item.get("pid")));
                uItem.setLevel(((Number)item.get("lev")).intValue());
                uItem.setNumber(MixUtil.toString(item.get("num")));
                uItem.setManageOrgName(MixUtil.toString(item.get("orgname")));
                uItem.setOrgNumber(MixUtil.toString(item.get("orgnumber")));
                if (cache.containsKey(uItem.getParentID())) {
                    SumUnitInfo pUnit = (SumUnitInfo)cache.get(uItem.getParentID());
                    pUnit.addChild(uItem);
                }
                cache.put(uItem.getId(), uItem);
            }
        }
        return rootUnit;
    }

    public SumUnitInfo buildSumUnitTreeIncluOrg(SumRangeInfo params) throws SumRangeException {
        String local = EASUtil.gelLoginLocal();
        ArrayList rsL = this.getFacade().queryfullUnitTree(params.getId(), local);
        SumUnitInfo rootUnit = null;
        if (null != rsL && rsL.size() >= 1) {
            rootUnit = new SumUnitInfo();
            Map item = (Map)rsL.get(0);
            if (!"0".equals(item.get("type"))) {
                return null;
            }
            rootUnit.setName(MixUtil.toString(item.get("name")), local);
            rootUnit.setId(MixUtil.toString(item.get("id")));
            HashMap<String, Serializable> cache = new HashMap<String, Serializable>();
            cache.put(rootUnit.getId(), rootUnit);
            int size = rsL.size();
            for (int i = 1; i < size; ++i) {
                SumUnitInfo pUnit;
                Serializable uItem;
                item = (Map)rsL.get(i);
                if ("0".equals(item.get("type"))) {
                    uItem = new SumUnitInfo();
                    ((BaseDataInfo)uItem).setName(MixUtil.toString(item.get("name")), local);
                    ((SumUnitInfo)uItem).setId(MixUtil.toString(item.get("id")));
                    ((SumUnitInfo)uItem).setParentID(MixUtil.toString(item.get("pid")));
                    if (cache.containsKey(((SumUnitInfo)uItem).getParentID())) {
                        pUnit = (SumUnitInfo)cache.get(((SumUnitInfo)uItem).getParentID());
                        pUnit.addChild((SumUnitInfo)uItem);
                    }
                    cache.put(((SumUnitInfo)uItem).getId(), uItem);
                    continue;
                }
                uItem = new SumUnitOrgInfo();
                ((SumUnitOrgInfo)uItem).setOrgName(MixUtil.toString(item.get("name")));
                ((SumUnitOrgInfo)uItem).setSumUnitID(MixUtil.toString(item.get("pid")));
                ((SumUnitOrgInfo)uItem).setOrgID(MixUtil.toString(item.get("id")));
                if (!cache.containsKey(((SumUnitOrgInfo)uItem).getSumUnitID())) continue;
                pUnit = (SumUnitInfo)cache.get(((SumUnitOrgInfo)uItem).getSumUnitID());
                pUnit.addOrgChild((SumUnitOrgInfo)uItem);
            }
        }
        return rootUnit;
    }

    public Vector querySumUnitOrg(String sumUnitID) throws SumRangeException {
        ArrayList rsL = this.getFacade().querySumUnitOrgByID(sumUnitID, EASUtil.gelLoginLocal());
        Vector<SumUnitOrgInfo> rs = new Vector<SumUnitOrgInfo>(rsL.size());
        int size = rsL.size();
        for (int i = 0; i < size; ++i) {
            Map item = (Map)rsL.get(i);
            SumUnitOrgInfo iItem = new SumUnitOrgInfo();
            iItem.setLongNumber(MixUtil.toString(item.get("longnumber")));
            iItem.setOrgID(MixUtil.toString(item.get("orgid")));
            iItem.setSumUnitID(MixUtil.toString(item.get("unitid")));
            iItem.setOrgAbbreviatioin(MixUtil.toString(item.get("orgabbreviation")));
            iItem.setOrgName(MixUtil.toString(item.get("orgname")));
            iItem.setOrgNumber(MixUtil.toString(item.get("orgnumber")));
            iItem.setOrgDes(MixUtil.toString(item.get("orgdes")));
            rs.add(iItem);
        }
        return rs;
    }

    public Vector querySumUnitOrgIncluSub(String rangeID, String sumUnitNumber) throws SumRangeException {
        ArrayList rsL = this.getFacade().querySumUnitOrgIncluSubByID(rangeID, sumUnitNumber, EASUtil.gelLoginLocal());
        Vector<SumUnitOrgInfo> rs = new Vector<SumUnitOrgInfo>(rsL.size());
        int size = rsL.size();
        for (int i = 0; i < size; ++i) {
            Map item = (Map)rsL.get(i);
            SumUnitOrgInfo iItem = new SumUnitOrgInfo();
            iItem.setLongNumber(MixUtil.toString(item.get("longnumber")));
            iItem.setOrgID(MixUtil.toString(item.get("orgid")));
            iItem.setSumUnitID(MixUtil.toString(item.get("unitid")));
            iItem.setOrgAbbreviatioin(MixUtil.toString(item.get("orgabbreviation")));
            iItem.setOrgName(MixUtil.toString(item.get("orgname")));
            iItem.setOrgNumber(MixUtil.toString(item.get("orgnumber")));
            iItem.setOrgDes(MixUtil.toString(item.get("orgdes")));
            rs.add(iItem);
        }
        return rs;
    }

    public List getUnitListByRangeID(String rangeId, String localString, String curOrgId) throws BOSException {
        if (rangeId == null) {
            return null;
        }
        if (curOrgId == null) {
            return null;
        }
        return this.getFacade().getUnitListByRangeID(rangeId, localString, curOrgId);
    }
}

