/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.reportmeta.tobi;

import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSONMap;
import com.kingdee.bos.ctrl.analysis.web.ext.ExtReport;
import com.kingdee.bos.ctrl.analysis.web.pagesetup.PageSetup;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.BIReportFilter;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.BIReportFilterImpl;
import com.kingdee.bos.ctrl.common.KDToolkit;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.util.style.StyleUtil;
import com.kingdee.bos.ctrl.kds.expans.model.data.ParameterImpl;
import com.kingdee.bos.ctrl.kds.io.htm.HtmlExporter;
import com.kingdee.bos.ctrl.kds.io.htm.KdsToHtmlExporter;
import com.kingdee.bos.ctrl.kds.io.htm.SheetHyperLinksProps;
import com.kingdee.bos.ctrl.kds.io.htm.explorer.HyperLinkHelper;
import com.kingdee.bos.ctrl.kds.io.htm.explorer.PageContext;
import com.kingdee.bos.ctrl.kds.io.htm.explorer.event.WebMouseEvent;
import com.kingdee.bos.ctrl.kds.io.kds.BookToKDSBook;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.UserObject;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.bos.ctrl.kds.model.struct.embed.chart.Chart;
import com.kingdee.bos.ctrl.kds.model.struct.embed.chart.ChartDataNode;
import com.kingdee.bos.ctrl.kds.model.struct.embed.chart.ChartModel;
import com.kingdee.bos.ctrl.kds.model.struct.filter.AlgorithmUtil;
import com.kingdee.bos.ctrl.kds.print.MultiPrintJobProvider;
import com.kingdee.bos.ctrl.kds.print.PrintManager;
import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.print.control.PaperInfo;
import com.kingdee.bos.ctrl.print.io.PdfExport;
import com.kingdee.eas.base.reportmeta.ctrlreport.bo.PermissionBO;
import com.kingdee.eas.base.reportmeta.ctrlreport.data.PermissionKind;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CheckJavaDataSet;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CheckJavaDataSetException;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.base.reportmeta.ctrlsqldesign.model.WebParamAdapter;
import com.kingdee.eas.base.reportmeta.tobi.FilterXmlTrans;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ExtReportImpl
implements ExtReport {
    private static Logger logger = Logger.getLogger(ExtReportImpl.class);
    private static float DPI_MM = KDToolkit.getCurrentDpi() * 10 / 72;
    private String reportPath;
    private String repositoryPath;
    private Document filterDocument;
    private PagingContext pagingContext;
    private PageContext pageContext;
    private Sheet _sheet;
    private HtmlExporter treeHtmlExporter;
    private KdsToHtmlExporter htmlExporter;
    private String FilePath = "?servletType=GetChart&filename=";
    private String webContextPath = "/easportal/BIReport";
    private String reportId = null;
    private WebParamAdapter _adapter;
    private int _pageCount = 50;
    private int _screenCount = 15;
    private boolean _hasScreenCount = false;
    private boolean _isTree = true;
    private Map _parameterMap;
    BIReportFilter filter = null;
    private final Object xslLock = new Object();
    private final Object pdfLock = new Object();

    public ExtReportImpl(String reportPath, String repositoryPath) {
        this.reportPath = reportPath;
        this.repositoryPath = repositoryPath;
        this.pageContext = new PageContext();
        this.pagingContext = new PagingContext();
    }

    public WebParamAdapter getAdapter(com.kingdee.bos.Context ctx, String reportID) {
        if (this._adapter == null) {
            this._adapter = new WebParamAdapter(ctx, reportID);
        }
        return this._adapter;
    }

    public WebParamAdapter getAdapter(com.kingdee.bos.Context ctx, String reportName, String systemID, String orgID) {
        if (this._adapter == null) {
            this._adapter = new WebParamAdapter(ctx, reportName, systemID, orgID);
        }
        return this._adapter;
    }

    public String execute(Object[] filterValue, Object[] filterCaption, HttpServletRequest request) throws BIReportException {
        String returnStr;
        HashMap<String, String> mapValue = new HashMap<String, String>();
        HashMap<String, String> mapAlias = new HashMap<String, String>();
        this.webContextPath = request.getRequestURL().toString();
        if (this._parameterMap == null && null != filterValue && filterValue.length > 0) {
            Element root = this.filterDocument.getDocumentElement();
            NodeList children = root.getChildNodes();
            for (int i = 0; i < filterValue.length; ++i) {
                Element element = (Element)children.item(i);
                Object obj = filterValue[i];
                if (null == obj) continue;
                List lstValue = (List)filterValue[i];
                List lstAlias = (List)filterCaption[i];
                if (lstValue.isEmpty()) continue;
                String defaultValue = element.getAttribute("defaultValue");
                String defaultAlias = element.getAttribute("defaultCaption");
                int size = lstValue.size();
                String value = "";
                String alias = "";
                for (int n = 0; n < size; ++n) {
                    String valueTmp = CtrlReportUtil.getObjectString(lstValue.get(n));
                    String aliasTmp = defaultAlias;
                    aliasTmp = valueTmp.equals(defaultValue) ? defaultAlias : CtrlReportUtil.getObjectString(lstAlias == null ? null : lstAlias.get(n));
                    value = value + valueTmp + "0xx1xx";
                    alias = alias + aliasTmp + "0xx1xx";
                }
                if (!value.equals("")) {
                    value = value.substring(0, value.length() - "0xx1xx".length());
                    alias = alias.substring(0, alias.length() - "0xx1xx".length());
                }
                String paramName = element.getAttribute("name");
                mapValue.put(paramName, value);
                mapAlias.put(paramName, alias);
            }
        }
        com.kingdee.bos.Context ctx = BISystem.getContext((HttpServletRequest)request);
        WebParamAdapter adapter = null;
        if (this.repositoryPath != null || this._parameterMap != null) {
            this.reportId = this.reportPath;
            adapter = this.getAdapter(ctx, this.reportPath);
        } else if (this.reportId != null) {
            adapter = this.getAdapter(ctx, this.reportId);
        } else {
            String[] list = this.reportPath.split("\u0001");
            adapter = this.getAdapter(ctx, list[0], list[1], request.getParameter("ExtRptsOrgID"));
        }
        adapter.setTree(this._isTree);
        try {
            if (!CheckJavaDataSet.checkUIType(ctx, this.reportId)) {
                throw new CheckJavaDataSetException("\u62a5\u8868\u4e2d\u7684JAVA\u6570\u636e\u96c6\u4f7f\u7528\u4e86\u4ee3\u7801\u7f16\u5199\u7684\u53c2\u6570\u754c\u9762\uff0c\u4e0d\u80fd\u6267\u884c\u3002");
            }
        }
        catch (CheckJavaDataSetException e) {
            logger.error((Object)"\u6267\u884c\u6269\u5c55\u62a5\u8868\u67e5\u8be2\u5931\u8d25", (Throwable)e);
            throw new BIReportException("\u6267\u884c\u6269\u5c55\u62a5\u8868\u5931\u8d25:" + e.getMessage(), (Throwable)e);
        }
        try {
            if (this._parameterMap == null) {
                adapter.execute(mapValue, mapAlias);
            } else {
                adapter.execute(this._parameterMap);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"\u6267\u884c\u6269\u5c55\u62a5\u8868\u67e5\u8be2\u5931\u8d25", (Throwable)ex);
            throw new BIReportException("\u6267\u884c\u6269\u5c55\u62a5\u8868\u67e5\u8be2\u5931\u8d25:" + ex.getMessage(), (Throwable)ex);
        }
        this._isTree = adapter.isTree();
        Book book = adapter.getBook();
        if (book.getSheetCount() > 1) {
            logger.error((Object)"BI\u6682\u4e0d\u652f\u6301\u591a\u9875\u7b7e\u62a5\u8868\uff01");
            throw new BIReportException("BI\u6682\u4e0d\u652f\u6301\u591a\u9875\u7b7e\u62a5\u8868\uff01", null);
        }
        for (int sh = book.getSheetCount() - 1; sh >= 0; --sh) {
            EmbedhLayer layer = book.getSheet(sh).getEmbedments(false);
            if (null == layer) continue;
            int size = layer.size();
            for (int i = 0; i < size; ++i) {
                EmbedObject eo = layer.getEmbed(i);
                if (!(eo instanceof Chart)) continue;
                ChartModel model = ((Chart)eo).getModel();
                ChartDataNode node = model.getDataNode();
                node.setDirty(true);
                node.getData();
                node.setNeedRecalc(false);
                node.setDirty(false);
                model.refreshChartData(model.getChartType());
            }
        }
        this._sheet = adapter.getPartSheet(0, 0);
        if (this._isTree) {
            Sheet curSheet = this._sheet;
            String pageId = request.getParameter("pageId");
            HyperLinkHelper hyperHelper = new HyperLinkHelper(ctx);
            this.treeHtmlExporter = new HtmlExporter(curSheet, this.pageContext, this._pageCount, pageId);
            this.treeHtmlExporter.setHyperLinkHelper(hyperHelper);
            this.pageContext = this.treeHtmlExporter.getPagingContext();
            this.treeHtmlExporter.setFileSavePath(System.getProperty("java.io.tmpdir"));
            this.treeHtmlExporter.setFilePrefixPath(this.getFilePath(""));
            returnStr = this.treeHtmlExporter.exportDiv();
            this._adapter = adapter;
        } else {
            Sheet sheet = book.getActiveSheet();
            SheetHyperLinksProps hyperLinksProps = SheetHyperLinksProps.getInst((Sheet)sheet, (int)0, (int)sheet.getMaxRowIndex());
            hyperLinksProps.setIdx2ParamsValueJson(new JSONMap(hyperLinksProps.getIdx2ParamsValues()).toString());
            hyperLinksProps.setIdx2ReportPropsJson(new JSONMap(hyperLinksProps.getIdx2ReportProps()).toString());
            Map idx2TargetParams = hyperLinksProps.getIdx2TargetParams();
            if (idx2TargetParams != null) {
                for (Object cellKey : idx2TargetParams.keySet()) {
                    List paramLst = (List)idx2TargetParams.get(cellKey);
                    ArrayList<String> jsonLst = new ArrayList<String>(paramLst.size());
                    int size = paramLst.size();
                    for (int i = 0; i < size; ++i) {
                        jsonLst.add(new JSONMap((Map)paramLst.get(i)).toString());
                    }
                    idx2TargetParams.put(cellKey, jsonLst);
                }
            }
            this.pagingContext.initPageContext(this._sheet, adapter);
            Sheet curSheet = this.pagingContext.firstPage();
            this.htmlExporter = new KdsToHtmlExporter(curSheet, null);
            this.htmlExporter.setHyperLinksProps(hyperLinksProps);
            this.htmlExporter.setFileSavePath(System.getProperty("java.io.tmpdir"));
            this.htmlExporter.setFilePrefixPath(this.getFilePath(""));
            try {
                this.htmlExporter.setRow1(this.pagingContext.currentRowStart);
                this.htmlExporter.setRow2(this.pagingContext.currentRowEnd);
                this.htmlExporter.setScreenHeight(this.pagingContext.getScreenHeight());
                this.htmlExporter.setScreenRow(this.pagingContext.hasScreenCount);
                if (this.pagingContext.pageCount == 1) {
                    this.htmlExporter.setEnforceShowGraph(true);
                }
                returnStr = this.htmlExporter.exportDiv();
            }
            catch (IOException e) {
                BIReportException be = new BIReportException((Throwable)e);
                throw be;
            }
        }
        return returnStr;
    }

    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    public BIReportFilter getFilter(HttpServletRequest request) throws BIReportException {
        if (this._parameterMap != null) {
            return null;
        }
        if (null != this.filter) {
            return this.filter;
        }
        com.kingdee.bos.Context ctx = BISystem.getContext((HttpServletRequest)request);
        WebParamAdapter adapter = null;
        if (request.getParameter("ExtRptsSystemID") == null) {
            adapter = this.getAdapter(ctx, this.reportPath);
        } else {
            String[] list = this.reportPath.split("\u0001");
            adapter = this.getAdapter(ctx, list[0], list[1], request.getParameter("ExtRptsOrgID"));
        }
        Element rootXML = null;
        try {
            Map parameters;
            String filter_xml = FilterXmlTrans.translate(adapter.getReportParamXmlString());
            this.reportId = adapter.getReportID();
            UserObject uo = adapter.getBook().getUserObject("ROW_COUNT_OF_WEB_REPORT");
            if (uo != null) {
                this._pageCount = Integer.parseInt((String)uo.getValue());
                if (!this._isTree) {
                    this.pagingContext.pageRowCount = this._pageCount;
                } else {
                    this.pageContext.setRowSum(this._pageCount);
                }
            }
            if ((uo = this._adapter.getBook().getUserObject("ROW_COUNT_OF_PAGE_REPORT")) != null) {
                this._screenCount = Integer.parseInt((String)uo.getValue());
                if (!this._isTree) {
                    this.pagingContext.screenCount = this._screenCount;
                } else {
                    this.pageContext.setScreenRowCount(this._screenCount);
                }
            }
            if ((uo = this._adapter.getBook().getUserObject("HAS_ROW_COUNT_OF_PAGE")) != null) {
                this._hasScreenCount = "true".equals((String)uo.getValue());
                if (!this._isTree) {
                    this.pagingContext.hasScreenCount = this._hasScreenCount;
                } else {
                    this.pageContext.setScreenCountEnable(this._hasScreenCount);
                }
            }
            if (filter_xml == null) {
                return null;
            }
            String newXml = filter_xml.replaceAll("\n", "").replaceAll("\r", "").replaceAll("\t", "");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(newXml)));
            if (request.getParameter("ExtRptsSystemID") != null && (parameters = request.getParameterMap()) != null) {
                NodeList nodelist = doc.getElementsByTagName("FilterItem");
                int size = nodelist.getLength();
                for (int i = 0; i < size; ++i) {
                    Node item = nodelist.item(i);
                    Node name = item.getAttributes().getNamedItem("name");
                    String nodeName = name.getNodeValue();
                    if (!parameters.containsKey(nodeName)) continue;
                    item.getAttributes().getNamedItem("defaultValue").setNodeValue(request.getParameter(nodeName));
                }
            }
            rootXML = doc.getDocumentElement();
            this.filterDocument = doc;
        }
        catch (Exception e) {
            logger.error((Object)("\u8fd4\u56de\u5171\u4eab\u7684WEB\u8fc7\u6ee4\u754c\u9762XML\u5b57\u7b26\u4e32\u5931\u8d25Exception:" + e.getMessage()), (Throwable)e);
            throw new BIReportException(e.getMessage(), (Throwable)e);
        }
        this.filter = new BIReportFilterImpl((Node)rootXML);
        return this.filter;
    }

    public boolean hasFilter(HttpServletRequest request) throws BIReportException {
        if (this._parameterMap != null) {
            return false;
        }
        try {
            this.filter = this.getFilter(request);
            return this.filter.getItemCount() > 0;
        }
        catch (Exception e) {
            logger.error((Object)("\u8fd4\u56de\u5171\u4eab\u7684WEB\u8fc7\u6ee4\u754c\u9762XML\u5b57\u7b26\u4e32\u5931\u8d25:" + e.getMessage()), (Throwable)e);
            throw new BIReportException(e.getMessage(), (Throwable)e);
        }
    }

    public String getFilterF7(int itemIndex, Map mapParams, HttpServletRequest request) throws BIReportException {
        String f7FilterData = null;
        Element element = null;
        if (this.filterDocument != null) {
            element = (Element)this.filterDocument.getDocumentElement().getChildNodes().item(itemIndex);
        }
        if (element != null && element.getAttribute("type").equalsIgnoreCase("sql")) {
            String errMsg = element.getAttribute("errMsg");
            if (errMsg != null && !"null".equals(errMsg) && errMsg.length() > 0) {
                throw new BIReportException(errMsg);
            }
            String fullName = element.getAttribute("fullname");
            String displayColumn = element.getAttribute("displayColumn");
            String valueColumn = element.getAttribute("valueColumn");
            try {
                f7FilterData = this._adapter.getF7Data(fullName, displayColumn, valueColumn);
            }
            catch (Exception e) {
                logger.error((Object)"get f7 data error", (Throwable)e);
                String emsg = CtrlReportUtil.getObjectString(e.getMessage());
                emsg = emsg.replaceAll("\n", "<br>");
                throw new BIReportException("\u83b7\u53d6F7\u6570\u636e\u5931\u8d25 :" + emsg, (Throwable)e);
            }
        }
        Document tmpDoc = null;
        String result = "";
        try {
            String newXml = f7FilterData.replaceAll("\n", "").replaceAll("\r", "").replaceAll("\t", "");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            tmpDoc = builder.parse(new InputSource(new StringReader(newXml)));
        }
        catch (Exception e) {
            logger.error((Object)"\u89e3\u6790F7\u6570\u636eXML\u5931\u8d25", (Throwable)e);
            throw new BIReportException("\u89e3\u6790F7\u6570\u636eXML\u5931\u8d25", (Throwable)e);
        }
        if (tmpDoc != null) {
            Element root = tmpDoc.getDocumentElement();
            NodeList children = root.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Element e = (Element)children.item(i);
                result = result + e.getAttribute("caption") + "\u0001";
                result = result + e.getAttribute("value") + "\u0001";
            }
            if (children.getLength() > 0) {
                result = result.substring(0, result.length() - 1);
            }
        }
        return result;
    }

    public String getF7ValueCaption(int itemIndex, String value, HttpServletRequest request) throws BIReportException {
        String defaultCaption = this.filter.getItem(itemIndex).getDefaultCaption();
        if (StringUtil.isEmptyString((String)defaultCaption)) {
            return value;
        }
        return defaultCaption;
    }

    public void filterVerify(Object[] filterValue, HttpServletRequest request) throws BIReportException {
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exportToXsl() {
        long randomId;
        Book book = this._adapter.getBook();
        if (this.treeHtmlExporter != null) {
            book = this.treeHtmlExporter.getPrintBook(book);
        }
        for (int sh = book.getSheetCount() - 1; sh >= 0; --sh) {
            Sheet sheet = book.getSheet(sh);
            boolean isSecurity = SheetBaseMath.isSecuritySheet((Sheet)sheet);
            if (!isSecurity) continue;
            AlgorithmUtil.delHideRowsAndCols((int[])sheet.getSecHidedRows(), (int[])sheet.getSecHidedCols(), (Sheet)sheet);
            sheet.clearHiddenRowsNCols();
        }
        KDSBook kdsbook = BookToKDSBook.traslate((Book)book, (String[])new String[]{this._adapter.getBook().getActiveSheet().getSheetName()});
        ExportManager em = new ExportManager();
        em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_TRUE, (Object)"TRUE");
        em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_FALSE, (Object)"FALSE");
        em.setExporterParmeter(ExporterParameter.EXPORT_FORMAT, (Object)"true");
        em.setExporterParmeter(ExporterParameter.EXPORT_STYLE, (Object)"true");
        em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"false");
        em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"false");
        em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
        Object object = this.xslLock;
        synchronized (object) {
            randomId = new Random().nextLong() & Integer.MAX_VALUE;
        }
        File xslFile = new File(new File(System.getProperty("java.io.tmpdir")), "EXTREPORT" + randomId + ".xls");
        em.exportToExcel(kdsbook, xslFile.getAbsolutePath());
        return xslFile.getName();
    }

    public String getFilePath(String fileName) {
        return this.webContextPath + this.FilePath + fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exportToPdf(PageSetup pageSetup) {
        long randomId;
        Book book = this._adapter.getBook();
        PrintManager printManager = new PrintManager(new MultiPrintJobProvider(book));
        PaperInfo paperInfo = new PaperInfo();
        int paperWidth = pageSetup.getPaperSizeWidth();
        int paperHeight = pageSetup.getPaperSizeHeight();
        int x = pageSetup.getPaperMaginLeft();
        int y = pageSetup.getPaperMaginTop();
        int pageWidth = paperWidth - x - pageSetup.getPaperMaginRight();
        int pageHeight = paperHeight - y - pageSetup.getPaperMaginBottom();
        paperInfo.setPaperSize((int)StyleUtil.lomToPt((double)((float)paperWidth * DPI_MM)), (int)StyleUtil.lomToPt((double)((float)paperHeight * DPI_MM)));
        paperInfo.setPageBounds((int)StyleUtil.lomToPt((double)((float)x * DPI_MM)), (int)StyleUtil.lomToPt((double)((float)y * DPI_MM)), (int)StyleUtil.lomToPt((double)((float)pageWidth * DPI_MM)), (int)StyleUtil.lomToPt((double)((float)pageHeight * DPI_MM)));
        Object object = this.pdfLock;
        synchronized (object) {
            randomId = new Random().nextLong() & Integer.MAX_VALUE;
        }
        File pdfFile = new File(new File(System.getProperty("java.io.tmpdir")), "EXTREPORT" + randomId + ".pdf");
        PdfExport pdf = new PdfExport();
        KDPrinter printer = null;
        printer = printManager.printImageOnly() ? printManager.getImagePrinter().getPrinter() : printManager.getPrinter();
        printer.getPrintJob().setPaperInfo(paperInfo);
        printManager.reloadPrintJob();
        this.setAttributes(printer, pageSetup);
        printer.getPrintJob().preparePagination();
        pdf.export(pdfFile.getAbsolutePath(), printer);
        return pdfFile.getName();
    }

    private void setAttributes(KDPrinter printer, PageSetup pageSetup) {
    }

    public int getCurPageNumber() throws BIReportException {
        if (this._isTree) {
            return this.pageContext.getPageIndex();
        }
        return this.pagingContext.getCurrentPage();
    }

    public int getPageTotal() throws BIReportException {
        if (this._isTree) {
            return this.pageContext.getPageCount();
        }
        return this.pagingContext.getPageCount();
    }

    public int getPerPageRows() throws BIReportException {
        if (this._isTree) {
            return this.pageContext.getRowSumPerPage();
        }
        return this.pagingContext.getPageRowCount();
    }

    public float getScreenHeight() throws BIReportException {
        if (this._isTree) {
            return this.pageContext.getScreenHeight();
        }
        return this.pagingContext.getScreenHeight();
    }

    public int getPerScreenRows() throws BIReportException {
        if (this._isTree) {
            return this.pageContext.getScreenCount();
        }
        return this.pagingContext.getPerScreenRows();
    }

    public boolean hasScreenCount() {
        if (this._isTree) {
            return this.pageContext.isScreenCountEnable();
        }
        return this.pagingContext.hasScreenCount();
    }

    public void setPerScreenRows(int perScreenRows) throws BIReportException {
        this._screenCount = perScreenRows;
        if (this._isTree) {
            this.pageContext.setScreenRowCount(perScreenRows);
        } else {
            this.pagingContext.setScreenRowCount(perScreenRows);
        }
    }

    private String refreshCurPage(Sheet _sheet) throws IOException {
        if (this._isTree) {
            if (this.treeHtmlExporter == null) {
                return null;
            }
            String result = this.treeHtmlExporter.exportDiv();
            return result;
        }
        if (this.htmlExporter == null) {
            return null;
        }
        if (_sheet != null) {
            this.htmlExporter.setSheet(_sheet);
        }
        this.htmlExporter.setRow1(this.pagingContext.currentRowStart);
        this.htmlExporter.setRow2(this.pagingContext.currentRowEnd);
        this.htmlExporter.setScreenHeight(this.pagingContext.getScreenHeight());
        this.htmlExporter.setScreenRow(this.pagingContext.hasScreenCount);
        if (this.pagingContext.pageCount == 1 && this.pagingContext.currentPage + 1 == this.pagingContext.pageCount) {
            this.htmlExporter.setEnforceShowGraph(true);
        }
        return this.htmlExporter.exportDiv();
    }

    public void setCurPageNumber(int pageNumber) throws BIReportException {
        if (this._isTree) {
            this.pageContext.setPageIndex(pageNumber);
        } else {
            this.pagingContext.goToPage(pageNumber);
        }
    }

    public int setPerPageRows(int perPageRows) throws BIReportException {
        if (this._isTree) {
            this.pageContext.setRowSum(perPageRows);
        } else {
            this.pagingContext.setPageRowCount(perPageRows);
            this.pagingContext.initPageContext(this._sheet, null);
        }
        return this.getCurPageNumber();
    }

    public int getTotalRows() throws BIReportException {
        return 0;
    }

    public String service(HttpServletRequest request, String action, Map params) throws BIReportException {
        if ("".equals(action != null ? action.trim() : "")) {
            return "";
        }
        String curAction = action.trim();
        if ("refresh".equals(curAction)) {
            try {
                String result = this.refreshCurPage(this.pagingContext.get_curSheet());
                return result;
            }
            catch (IOException e) {
                throw new BIReportException((Throwable)e);
            }
        }
        if (!this.authorizedExport(this.reportId, request)) {
            throw new BIReportException("\u6ca1\u6709\u5bfc\u51fa\u6743\u9650\uff0c\u4e0d\u80fd\u8fdb\u884c\u5bfc\u51fa\u64cd\u4f5c\uff01");
        }
        if ("exportToExcel".equals(curAction)) {
            String path = this.exportToXsl();
            return path;
        }
        if ("exportToPDF".equals(curAction)) {
            PageSetup pageSetup = (PageSetup)params.get("pageSetup");
            String path = this.exportToPdf(pageSetup);
            return path;
        }
        if ("responseClick".equals(curAction) && this._isTree) {
            String location = request.getParameter("location");
            String[] param = location.split(",");
            if (param.length != 2) {
                return "error";
            }
            int row = Integer.parseInt(param[0]);
            int col = Integer.parseInt(param[1]);
            WebMouseEvent event = new WebMouseEvent(row, col, 1);
            String result = this.treeHtmlExporter.doMouseEvent(event);
            return result;
        }
        return "";
    }

    private boolean authorizedExport(String reportID, HttpServletRequest request) throws BIReportException {
        return PermissionBO.hasDataPermissionByReportId(BISystem.getContext((HttpServletRequest)request), BISystem.getCurrentUser((HttpServletRequest)request), BISystem.getCurrentOrgUnitID((HttpServletRequest)request), reportID, PermissionKind.EXPORT);
    }

    public void setParameterJson(String json) {
        if (StringUtil.isEmptyString((String)json) || json.equals("null")) {
            return;
        }
        this._parameterMap = new TreeMap();
        Context ctx = Context.enter();
        Scriptable scope = ctx.initStandardObjects(null);
        Scriptable p = (Scriptable)ctx.evaluateString(scope, "json = (" + json + ")", "JSON", 1, null);
        p.has(0, scope);
        Scriptable s = (Scriptable)p.get(0, scope);
        Object[] ids = s.getIds();
        for (int i = 0; i < ids.length; ++i) {
            Object avv;
            Object o = s.get(ids[i].toString(), scope);
            if (o == null || Context.getUndefinedValue().equals(o) || Scriptable.NOT_FOUND.equals(o)) continue;
            HashMap<String, Object> pMap = new HashMap<String, Object>();
            Scriptable pOne = (Scriptable)o;
            Object obj = pOne.get("DT", scope);
            if (obj != null && !Context.getUndefinedValue().equals(obj) && !Scriptable.NOT_FOUND.equals(obj)) {
                pMap.put("DT", obj);
            }
            if ((obj = pOne.get("NM", scope)) != null && !Context.getUndefinedValue().equals(obj) && !Scriptable.NOT_FOUND.equals(obj)) {
                pMap.put("NM", obj);
            }
            if ((obj = pOne.get("AA", scope)) != null && !Context.getUndefinedValue().equals(obj) && !Scriptable.NOT_FOUND.equals(obj)) {
                pMap.put("AA", obj);
            }
            if ((obj = pOne.get("VA", scope)) != null && !Context.getUndefinedValue().equals(obj) && !Scriptable.NOT_FOUND.equals(obj)) {
                pMap.put("VA", obj);
            }
            if ((avv = pOne.get("AVV", scope)) instanceof Scriptable) {
                ArrayList<Object> list = new ArrayList<Object>();
                if ("Array".equals(((Scriptable)avv).getClassName())) {
                    Scriptable avvS = (Scriptable)avv;
                    int j = 0;
                    while (avvS.has(j, scope)) {
                        list.add(avvS.get(j, scope));
                        ++j;
                    }
                }
                pMap.put("AVV", list.toArray(new Object[1]));
            } else if (avv != null && !Context.getUndefinedValue().equals(avv) && !Scriptable.NOT_FOUND.equals(avv)) {
                pMap.put("AVV", avv);
            }
            ParameterImpl parameter = new ParameterImpl();
            parameter.fromJsonMap(pMap);
            this._parameterMap.put(parameter.getName(), parameter);
        }
    }

    class PagingContext {
        private boolean pagingOn = true;
        private int pageRowCount;
        private boolean hasScreenCount;
        private int screenCount;
        private int screenHeight = -1;
        private int currentRowStart = 0;
        private int currentRowEnd = 0;
        private int pageCount = 1;
        private int currentPage = 0;
        private int sheetRowCount = 0;
        private WebParamAdapter adapter;
        private Sheet _curSheet;

        public PagingContext() {
            this.pageRowCount = ExtReportImpl.this._pageCount;
            this.hasScreenCount = ExtReportImpl.this._hasScreenCount;
            this.screenCount = ExtReportImpl.this._screenCount;
        }

        public WebParamAdapter getAdapter() {
            return this.adapter;
        }

        public Sheet get_curSheet() {
            return this._curSheet;
        }

        public int getCurrentPage() {
            return this.currentPage;
        }

        public void setCurrentPage(int currentPage) {
            this.currentPage = currentPage;
        }

        public void initPageContext(Sheet _sSheet, WebParamAdapter _adapter) {
            if (this.pagingOn) {
                int maxRow = _sSheet.getMaxRowIndex() + 1;
                int remainder = maxRow % this.pageRowCount;
                int multiples = maxRow / this.pageRowCount;
                this.pageCount = remainder > 0 ? multiples + 1 : multiples;
                this.currentRowStart = 0;
                this.currentRowEnd = Math.min(maxRow, this.currentRowStart + this.pageRowCount - 1);
                this.currentPage = 0;
                this.sheetRowCount = maxRow - 1;
                this._curSheet = _sSheet;
                if (_adapter != null) {
                    this.adapter = _adapter;
                }
            }
        }

        public boolean isPagingOn() {
            return this.pagingOn;
        }

        public void setPagingOn(boolean pagingOn) {
            this.pagingOn = pagingOn;
        }

        public int getPageRowCount() {
            return this.pageRowCount;
        }

        public boolean hasScreenCount() {
            return this.hasScreenCount;
        }

        public int getScreenHeight() {
            if (!this.hasScreenCount) {
                return 0;
            }
            if (this.screenHeight > 0) {
                return this.screenHeight;
            }
            int min = Math.min(this.screenCount, Math.min(this.pageRowCount, this.sheetRowCount));
            this.screenHeight = this.getHeightBefore(min);
            return this.screenHeight;
        }

        public int getPerScreenRows() {
            return this.screenCount;
        }

        public void setScreenRowCount(int rowCount) {
            this.screenCount = rowCount;
            this.screenHeight = -1;
        }

        private int getHeightBefore(int rowCount) {
            int height = 0;
            Sheet sheet = this.adapter.getBook().getActiveSheet();
            int index = 0;
            int row = ExtReportImpl.this._sheet.getSheetOption().getViewSplitInfo().getRowSplit();
            int i = 0;
            while (i < rowCount) {
                int h = SheetBaseMath.getRowHeight((Sheet)sheet, (int)index, (boolean)false);
                if (h > 0) {
                    height += h;
                    if (index >= row) {
                        ++i;
                    }
                }
                ++index;
            }
            return height += 20;
        }

        public void setPageRowCount(int pageRowCount) {
            this.pageRowCount = pageRowCount;
            this.screenHeight = -1;
        }

        public int getCurrentRowStart() {
            return this.currentRowStart;
        }

        public void setCurrentRowStart(int currentRowStart) {
            this.currentRowStart = currentRowStart;
        }

        public int getCurrentRowEnd() {
            return this.currentRowEnd;
        }

        public void setCurrentRowEnd(int currentRowEnd) {
            this.currentRowEnd = currentRowEnd;
        }

        public int getPageCount() {
            return this.pageCount;
        }

        public void setPageCount(int pageCount) {
            this.pageCount = pageCount;
        }

        private void reCalculatePageContext(int curPage) {
            if (this.pagingOn && curPage >= 0 && curPage < this.pageCount) {
                this.currentRowStart = Math.max(curPage * this.pageRowCount, 0);
                this.currentRowEnd = Math.min(this.currentRowStart + this.pageRowCount - 1, this.sheetRowCount);
                this.currentPage = curPage;
            }
        }

        public Sheet nextPage() {
            this.reCalculatePageContext(this.currentPage + 1);
            Sheet _sheet = this.adapter.getPartSheet(this.currentRowStart, this.currentRowEnd);
            return _sheet;
        }

        public Sheet prePage() {
            this.reCalculatePageContext(this.currentPage + 1);
            Sheet _sheet = this.adapter.getPartSheet(this.currentRowStart, this.currentRowEnd);
            return _sheet;
        }

        public Sheet goToPage(int goToPageIdx) {
            this.reCalculatePageContext(goToPageIdx);
            Sheet _sheet = this.adapter.getPartSheet(this.currentRowStart, this.currentRowEnd);
            return _sheet;
        }

        public Sheet firstPage() {
            Sheet _sheet = this.adapter.getPartSheet(this.currentRowStart, this.currentRowEnd);
            return _sheet;
        }
    }
}

