/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.builder;

import com.kingdee.cbos.process.vm.builder.AbstractBuilder;
import com.kingdee.cbos.process.vm.builder.GroupBuilder;
import com.kingdee.cbos.process.vm.builder.NodeBuilder;
import com.kingdee.cbos.process.vm.builder.VariableBuilder;
import com.kingdee.cbos.process.vm.internal.f.Features;
import com.kingdee.cbos.process.vm.internal.f.advanced.ChildrenIteration;
import com.kingdee.cbos.process.vm.internal.f.advanced.ChildrenMultiInstance;
import com.kingdee.cbos.process.vm.internal.f.advanced.CriticalSection;
import com.kingdee.cbos.process.vm.internal.f.advanced.SetAsCallee;
import com.kingdee.cbos.process.vm.internal.m.FlowImpl;
import com.kingdee.cbos.process.vm.internal.m.NodeImpl;
import com.kingdee.cbos.process.vm.internal.m.TransitionImpl;
import com.kingdee.cbos.process.vm.internal.m.VariableImpl;
import com.kingdee.cbos.process.vm.model.DataType;
import com.kingdee.cbos.process.vm.model.Event;
import com.kingdee.cbos.process.vm.model.Flow;
import com.kingdee.cbos.process.vm.model.Transition;
import com.kingdee.cbos.process.vm.plugin.Condition;
import com.kingdee.cbos.process.vm.plugin.Listener;
import com.kingdee.cbos.process.vm.plugin.Synchronizer;
import com.kingdee.cbos.process.vm.runtime.Execution;
import java.util.HashMap;
import java.util.Map;

public final class FlowBuilder
extends AbstractBuilder<Flow> {
    private FlowImpl flow;

    public static FlowBuilder newBuilder(String id, String title) {
        return new FlowBuilder(null, Flow.Mode.CONTROL_FLOW, id, title, false);
    }

    public void registerListener(Listener<?> listener) {
        this.flow.registerListener(listener);
    }

    public static FlowBuilder newBuilder(Synchronizer synchronizer, String id, String title) {
        return new FlowBuilder(synchronizer, Flow.Mode.CONTROL_FLOW, id, title, false);
    }

    public static FlowBuilder newBuilder(Synchronizer synchronizer, Flow.Mode mode, String id, String title) {
        return new FlowBuilder(synchronizer, mode, id, title, false);
    }

    public static FlowBuilder newSubFlowBuilder(Synchronizer synchronizer, String id, String title) {
        return new FlowBuilder(synchronizer, Flow.Mode.CONTROL_FLOW, id, title, true);
    }

    public static FlowBuilder newSubFlowBuilder(String id, String title) {
        return new FlowBuilder(null, Flow.Mode.CONTROL_FLOW, id, title, true);
    }

    public Flow end() {
        this.flow.solidify();
        FlowImpl flow = this.flow;
        this.flow = null;
        return flow;
    }

    private FlowBuilder(Synchronizer synchronizer, Flow.Mode mode, String id, String title, boolean subFlow) {
        this.flow = new FlowImpl(synchronizer, mode, id, title, subFlow);
    }

    FlowImpl getFlow() {
        return this.flow;
    }

    @Override
    FlowBuilder getFlowBuilder() {
        return this;
    }

    @Override
    FlowImpl getProcessElement() {
        return this.flow;
    }

    public VariableBuilder<Flow, FlowBuilder> variable(String id, String name, String title, DataType type, Object initValue) {
        return this.variable(id, name, title, type, initValue, false);
    }

    public VariableBuilder<Flow, FlowBuilder> variable(String id, String name, String title, DataType type, Object initValue, boolean singleton) {
        VariableImpl var = this.flow.addVariable(id, title, name, type, initValue, singleton);
        return new VariableBuilder<Flow, FlowBuilder>(this, var);
    }

    public NodeBuilder node(String id, String title) {
        return new NodeBuilder(this, id, title);
    }

    public FlowBuilder input(String ... vars) {
        for (String var : vars) {
            this.flow.addInput(var);
        }
        return this;
    }

    public FlowBuilder output(String ... vars) {
        for (String var : vars) {
            this.flow.addOutput(var);
        }
        return this;
    }

    public GroupBuilder group(String id, String title) {
        return new GroupBuilder(this, id, title);
    }

    public FlowBuilder transition(String id, String title, String sourceId, String targetId, Condition condition) {
        return this.transition(id, title, Transition.Type.NORMAL, sourceId, targetId, condition);
    }

    public FlowBuilder transition(String id, String title, Transition.Type type, String sourceId, String targetId, Condition condition) {
        return this.transition(id, title, type, sourceId, targetId, condition, null);
    }

    public FlowBuilder transition(String id, String title, Transition.Type type, String sourceId, String targetId, Condition condition, Map<String, String> assigns) {
        NodeImpl source = this.flow.getNode(sourceId);
        NodeImpl target = this.flow.getNode(targetId);
        new TransitionImpl(id, title, type, source, target, condition, assigns);
        return this;
    }

    public FlowBuilder transition(String id, String title, Transition.Type type, String sourceId, String targetId, Condition condition, String sourceVar, String targetVar) {
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put(sourceVar, targetVar);
        return this.transition(id, title, type, sourceId, targetId, condition, map);
    }

    public FlowBuilder transition(String id, String title, String sourceId, String targetId, Condition condition, String sourceVar, String targetVar) {
        return this.transition(id, title, Transition.Type.NORMAL, sourceId, targetId, condition, sourceVar, targetVar);
    }

    public FlowBuilder listener(Event<Flow> e, Listener<Execution<Flow>> listener) {
        this.flow.addListener(e, listener);
        return this;
    }

    public FlowBuilder childrenSplit(String collectionVar, String[] returnVars, String ... paramVars) {
        ChildrenMultiInstance feature = new ChildrenMultiInstance(collectionVar, paramVars, returnVars);
        this.flow.getRoot().addFeature(feature);
        return this;
    }

    public FlowBuilder forEach(String masterVar) {
        ChildrenIteration feature = new ChildrenIteration(masterVar);
        this.flow.getRoot().addFeature(feature);
        return this;
    }

    public FlowBuilder function(String[] paramVars, String ... returnVars) {
        this.flow.getRoot().addFeature(new SetAsCallee(paramVars, returnVars));
        return this;
    }

    public FlowBuilder deferredDispatch() {
        this.flow.getRoot().addFeature(Features.DEFERRED_DISPATCH);
        return this;
    }

    public FlowBuilder critical(String sectId, String ... nodeIds) {
        return this.critical(sectId, false, nodeIds);
    }

    public FlowBuilder critical(String sectId, boolean global, String ... nodeIds) {
        CriticalSection.createCriticalSection(this.flow, sectId, nodeIds, global);
        return this;
    }

    public void setAttribute(String name, Object value) {
        this.flow.setAttribute(name, value);
    }

    public Object getAttribute(String name) {
        return this.flow.getAttribute(name);
    }
}

