/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.internal.i.var;

import com.kingdee.cbos.process.vm.internal.i.Instruction;
import com.kingdee.cbos.process.vm.internal.i.VIS;
import com.kingdee.cbos.process.vm.internal.m.NodeImpl;
import com.kingdee.cbos.process.vm.internal.m.VariableImpl;
import com.kingdee.cbos.process.vm.internal.r.ExecutionImpl;
import com.kingdee.cbos.process.vm.internal.r.FlowContextImpl;
import com.kingdee.cbos.process.vm.runtime.Execution;
import java.util.ArrayList;

public class StartUpByMessage
implements Instruction<VariableImpl<?>> {
    private int index;
    private ArrayList<NodeImpl> nodes = new ArrayList(1);
    private VariableImpl<?> v;

    public StartUpByMessage(VariableImpl<?> v, NodeImpl node, int index) {
        this.index = index;
        this.nodes.add(node);
        this.v = v;
    }

    @Override
    public int invoke(ExecutionImpl<VariableImpl<?>> e) {
        FlowContextImpl ctx = e.getContext();
        Execution root = ctx.getRootExecution();
        for (NodeImpl node : this.nodes) {
            ExecutionImpl<NodeImpl> fired = new ExecutionImpl<NodeImpl>((ExecutionImpl<?>)root, node, ((ExecutionImpl)root).getDataArea(), null, null);
            ctx.push(fired);
        }
        return 1;
    }

    @Override
    public int getLabel() {
        return this.index;
    }

    public String toString() {
        return "start-up " + this.nodes + " by [" + this.v + "]";
    }

    public static void insert(VariableImpl<?> v, NodeImpl node) {
        int label = VIS.START_UP_BY_MSG.getLabel();
        int addr = v.seekInstruction(label);
        if (addr == -1) {
            v.insert(new StartUpByMessage(v, node, label));
            return;
        }
        Instruction original = v.getInstruction(addr);
        if (original.getLabel() == label) {
            ((StartUpByMessage)original).nodes.add(node);
        } else {
            v.insert(new StartUpByMessage(v, node, label));
        }
    }
}

