/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.internal.r;

import com.kingdee.cbos.process.vm.runtime.PropertyContainer;
import com.kingdee.cbos.process.vm.utils.XmlUtil;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PropertyContainerImpl
implements PropertyContainer {
    private HashMap<String, Object> properties;
    private HashMap<String, Object> transientProperties;

    void restoreProperties(Element e) {
        Element container = XmlUtil.getChild(e, "properties");
        if (container == null) {
            return;
        }
        Collection<Element> properties = XmlUtil.getChildren(container, "item");
        this.properties = new HashMap(properties.size() << 1);
        for (Element property : properties) {
            AbstractCollection list;
            String key = property.getAttribute("key");
            String type = property.getAttribute("type");
            if (type.length() == 0) {
                this.properties.put(key, property.getAttribute("value"));
                continue;
            }
            if (type.equals("collection")) {
                list = this.restoreCollection(property);
                this.properties.put(key, list);
                continue;
            }
            if (type.equals("set")) {
                list = this.restoreSet(property);
                this.properties.put(key, list);
                continue;
            }
            if (!type.equals("map")) continue;
            HashMap<String, String> map = this.restoreMap(property);
            this.properties.put(key, map);
        }
    }

    private HashMap<String, String> restoreMap(Element property) {
        Collection<Element> values = XmlUtil.getChildren(property, "entry");
        HashMap<String, String> map = new HashMap<String, String>(values.size() << 1);
        for (Element entry : values) {
            String key = entry.getAttribute("key");
            String value = entry.getAttribute("value");
            map.put(key, value);
        }
        return map;
    }

    private ArrayList<String> restoreCollection(Element property) {
        Collection<Element> values = XmlUtil.getChildren(property, "value");
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (Element value : values) {
            list.add(value.getTextContent());
        }
        return list;
    }

    private HashSet<String> restoreSet(Element property) {
        Collection<Element> values = XmlUtil.getChildren(property, "value");
        HashSet<String> list = new HashSet<String>(values.size() * 2);
        for (Element value : values) {
            list.add(value.getTextContent());
        }
        return list;
    }

    void saveProperties(Element e) {
        if (this.properties == null) {
            return;
        }
        Document doc = e.getOwnerDocument();
        Element properties = doc.createElement("properties");
        e.appendChild(properties);
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            Element item = doc.createElement("item");
            properties.appendChild(item);
            item.setAttribute("key", entry.getKey());
            Object v = entry.getValue();
            if (v instanceof String) {
                item.setAttribute("value", v.toString());
                continue;
            }
            if (v instanceof Set) {
                item.setAttribute("type", "set");
                this.saveCollection(doc, item, v);
                continue;
            }
            if (v instanceof Collection) {
                item.setAttribute("type", "collection");
                this.saveCollection(doc, item, v);
                continue;
            }
            if (!(v instanceof Map)) continue;
            item.setAttribute("type", "map");
            this.saveMap(doc, item, v);
        }
    }

    private void saveMap(Document doc, Element item, Object v) {
        for (Map.Entry entry : ((Map)v).entrySet()) {
            Element value = doc.createElement("entry");
            item.appendChild(value);
            value.setAttribute("key", entry.getKey().toString());
            value.setAttribute("value", entry.getValue().toString());
        }
    }

    private void saveCollection(Document doc, Element item, Object v) {
        for (Object o : (Collection)v) {
            Element value = doc.createElement("value");
            item.appendChild(value);
            value.setTextContent(o.toString());
        }
    }

    @Override
    public final Object getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    @Override
    public final void setProperty(String name, String value) {
        if (value == null) {
            if (this.properties != null) {
                this.properties.remove(name);
            }
            return;
        }
        this.initProperties();
        this.properties.put(name, value);
    }

    @Override
    public final void setProperty(String name, Collection<String> values) {
        if (values == null) {
            if (this.properties != null) {
                this.properties.remove(name);
            }
            return;
        }
        this.initProperties();
        this.properties.put(name, values);
    }

    @Override
    public Object getTransientProperty(String name) {
        if (this.transientProperties == null) {
            return null;
        }
        return this.transientProperties.get(name);
    }

    @Override
    public void setTransientProperty(String name, Object value) {
        if (this.transientProperties == null) {
            this.transientProperties = new HashMap();
        }
        this.transientProperties.put(name, value);
    }

    @Override
    public void setProperty(String name, Map<String, String> values) {
        if (values == null) {
            if (this.properties != null) {
                this.properties.remove(name);
            }
            return;
        }
        this.initProperties();
        this.properties.put(name, values);
    }

    private void initProperties() {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
    }

    @Override
    public Map<String, ?> getProperties() {
        if (this.properties == null) {
            return new HashMap(1);
        }
        return (Map)this.properties.clone();
    }
}

