/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.utils.cache;

import com.kingdee.bos.rpc.RPCEngine;
import com.kingdee.bos.rpc.io.loadbalance.IRPCServer;
import com.kingdee.bos.rpc.io.loadbalance.RPCServerView;
import com.kingdee.bos.rpc.io.server.IServer;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.cbos.process.vm.utils.cache.CacheListener;
import com.kingdee.cbos.process.vm.utils.rpcgroup.IRPCInvoker;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class RPCBroadcastListener
implements CacheListener {
    private static Logger log = Logger.getLogger(RPCBroadcastListener.class);
    private HashMap<String, IRPCInvoker> map = new HashMap();

    private synchronized IRPCInvoker getInvoker(String url) throws Exception {
        IRPCInvoker invoker = this.map.get(url);
        if (invoker == null) {
            invoker = this.createInvoker(url);
            this.map.put(url, invoker);
        }
        return invoker;
    }

    private IRPCInvoker createInvoker(String url) throws Exception {
        IRPCInvoker invoker = (IRPCInvoker)RPCEngine.createRemoteObject((String)url, (String)"com.kingdee.cbos.process.vm.utils.rpcgroup.RPCInvoker", IRPCInvoker.class);
        return invoker;
    }

    private ArrayList getRemoteUrlList() {
        ArrayList<String> result = new ArrayList<String>(4);
        RPCServerView sv = RPCServerView.getLast();
        if (sv == null) {
            return result;
        }
        try {
            IRPCServer[] ss = sv.getServers();
            for (int i = 0; i < ss.length; ++i) {
                IRPCServer s = ss[i];
                String url = s.getUrl();
                if (s.connectionFailed()) {
                    this.map.remove(url);
                    continue;
                }
                if (url == null || "".equals(url) || RPCBroadcastListener.isLocal(url)) continue;
                result.add(url);
            }
        }
        catch (Throwable t) {
            log.error((Object)"error when getRemoteUrlList", t);
        }
        return result;
    }

    private static boolean isLocal(String url) {
        IServer[] servers = ServerManager.listServers();
        for (int i = 0; i < servers.length; ++i) {
            if (!servers[i].match(url)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void put(String namespace, String key, Object value) {
    }

    @Override
    public void get(String namespace, String key) {
    }

    @Override
    public void remove(String namespace, String key) {
        ArrayList urlList = this.getRemoteUrlList();
        for (String url : urlList) {
            try {
                IRPCInvoker invoker = this.getInvoker(url);
                invoker.removeCache(namespace, key);
            }
            catch (Throwable t) {
                log.error((Object)("removeCache error, url=" + url + ",key=" + key), t);
            }
        }
    }

    @Override
    public void clear(String namespace) {
        ArrayList urlList = this.getRemoteUrlList();
        for (String url : urlList) {
            try {
                IRPCInvoker invoker = this.getInvoker(url);
                invoker.clearCache(namespace);
            }
            catch (Throwable t) {
                log.error((Object)("clearCache error, url=" + url), t);
            }
        }
    }
}

