/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.utils.condition;

import com.kingdee.cbos.process.vm.internal.Consts;
import com.kingdee.cbos.process.vm.model.Variable;
import com.kingdee.cbos.process.vm.model.VariableScope;
import com.kingdee.cbos.process.vm.plugin.Identifier;
import com.kingdee.cbos.process.vm.runtime.Execution;
import com.kingdee.cbos.process.vm.utils.condition.Utils;
import java.lang.reflect.Method;

public final class PropertyIdentifier
implements Identifier {
    private String var;
    private String property;
    private Variable<?> v;
    private Method method;

    public PropertyIdentifier(String var, String property) {
        if (var == null || property == null) {
            throw new NullPointerException();
        }
        this.var = var;
        this.property = property;
    }

    public String[] getIds(Execution<?> e) {
        Object o = e.get(this.v);
        if (o == null) {
            return Consts.EMPTY_STR_ARRAY;
        }
        try {
            return Utils.toStringArray(this.method.invoke(o, new Object[0]));
        }
        catch (Exception e1) {
            throw new RuntimeException("\u8bbf\u95ee\u53d8\u91cf(" + this.var + ")\u503c(" + o + ")\u5c5e\u6027(" + this.property + ")\u5931\u8d25");
        }
    }

    @Override
    public void compile(VariableScope scope) {
        Variable<? extends VariableScope> v = scope.retrieveVariable(this.var);
        if (v == this.v) {
            return;
        }
        if (this.v != null) {
            throw new RuntimeException("\u53d8\u91cf\u51b2\u7a81\uff0c\u5e94\u7528\u672c\u6807\u8bc6\u7684\u5404\u53d8\u91cf\u8303\u56f4\u6709\u4e0d\u540c\u7684(" + this.var + ")\u53d8\u91cf\uff0e");
        }
        this.v = v;
        Class<?> type = v.getType().getValueClass();
        String methodName = "get" + this.property.substring(0, 1).toUpperCase() + this.property.substring(1);
        try {
            this.method = type.getMethod(methodName, new Class[0]);
        }
        catch (Exception e) {
            try {
                this.method = type.getMethod(this.property, new Class[0]);
            }
            catch (Exception e1) {
                throw new RuntimeException("\u53d8\u91cf(" + this.var + ")\u6ca1\u6709\u5c5e\u6027(" + this.property + ")\u3002");
            }
        }
        if (this.method.getReturnType() == Void.TYPE) {
            throw new RuntimeException("\u53d8\u91cf(" + this.var + ")\u7684\u5c5e\u6027(" + this.property + ")\u6ca1\u6709\u8fd4\u56de\u503c\u3002");
        }
    }

    public int hashCode() {
        return this.var.hashCode() ^ this.property.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != PropertyIdentifier.class) {
            return false;
        }
        PropertyIdentifier i = (PropertyIdentifier)obj;
        return i.var.equals(this.var) && i.property.equals(this.property);
    }

    public String toString() {
        return this.var + "#" + this.property;
    }
}

