/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.utils.graph;

import com.kingdee.cbos.process.vm.utils.graph.Block;
import com.kingdee.cbos.process.vm.utils.graph.Diagram;
import java.util.LinkedList;
import java.util.List;

public enum Type {
    Activity{

        @Override
        String getTitle(Block block) {
            return block.getActivity().getTitle();
        }

        @Override
        int getHeight(Block block) {
            return block.getActivity().getHeight();
        }

        @Override
        int getWidth(Block block) {
            return block.getActivity().getWidth();
        }

        @Override
        int layout(Block block, int hInterval) {
            LinkedList<Block> groups = block.getChildren();
            int width = block.getActivity().getWidth();
            if (groups != null) {
                if (groups.size() == 1) {
                    int tmp = Type.vLayout(hInterval, groups);
                    if (tmp > width) {
                        width = tmp;
                    }
                } else {
                    Type.createJoin(block, groups);
                    int tmp = Type.mLayout(hInterval, groups);
                    if (tmp > width) {
                        width = tmp;
                    }
                }
            }
            block.setWidth(width);
            return width;
        }

        @Override
        int locate(Block block, int hInterval, int vInterval) {
            int height = super.locate(block, hInterval, vInterval);
            LinkedList<Block> groups = block.getChildren();
            if (groups == null) {
                return height;
            }
            height = groups.size() == 1 ? Type.vLocate(block, hInterval, vInterval, height, groups) : Type.mLocate(block, hInterval, vInterval, height, groups);
            block.setHeight(height);
            return height;
        }
    }
    ,
    Join{

        @Override
        String getTitle(Block block) {
            return "-";
        }

        @Override
        int getHeight(Block block) {
            return 25;
        }

        @Override
        int getWidth(Block block) {
            return 25;
        }

        @Override
        int layout(Block block, int interval) {
            block.setWidth(25);
            return 25;
        }

        @Override
        int locate(Block block, int hInterval, int vInterval) {
            int height = super.locate(block, hInterval, vInterval);
            block.setHeight(height);
            return height;
        }
    }
    ,
    Group{

        @Override
        String getTitle(Block block) {
            return "+";
        }

        @Override
        int getHeight(Block block) {
            return 25;
        }

        @Override
        int getWidth(Block block) {
            return 25;
        }

        @Override
        int layout(Block group, int hInterval) {
            group.sortChildren();
            int width = this.calcWidth(group, hInterval);
            group.setWidth(width);
            return width;
        }

        private int calcWidth(Block group, int hInterval) {
            int width;
            LinkedList<Block> children = group.getChildren();
            List<Block> lastPriors = children.getLast().getPriors();
            if (lastPriors == null) {
                if (children.size() > 1) {
                    Type.createJoin(group, children);
                    width = Type.mLayout(hInterval, children);
                } else {
                    width = Type.vLayout(hInterval, children);
                }
            } else {
                width = lastPriors.size() == 1 ? Type.vLayout(hInterval, children) : Type.mLayout(hInterval, children);
            }
            return width;
        }

        @Override
        int locate(Block group, int hInterval, int vInterval) {
            int height = super.locate(group, hInterval, vInterval);
            LinkedList<Block> children = group.getChildren();
            List<Block> lastPriors = children.getLast().getPriors();
            height = lastPriors == null || lastPriors.size() == 1 ? Type.vLocate(group, hInterval, vInterval, height, children) : Type.mLocate(group, hInterval, vInterval, height, children);
            group.setHeight(height);
            return height;
        }
    };


    abstract int getHeight(Block var1);

    abstract int getWidth(Block var1);

    abstract String getTitle(Block var1);

    abstract int layout(Block var1, int var2);

    int locate(Block block, int hInterval, int vInterval) {
        Type.createLink2Parent(block);
        int y = block.getTop() + vInterval;
        block.setY(y);
        int offset = (block.getWidth() - block.getType().getWidth(block)) / 2;
        int x = block.getLeft() + offset;
        block.setX(x);
        return block.getType().getHeight(block) + vInterval * 2;
    }

    private static int mLocate(Block group, int hInterval, int vInterval, int height, LinkedList<Block> children) {
        Block join = children.removeLast();
        int max = 0;
        int left = group.getLeft();
        for (Block child : children) {
            child.setTop(group.getTop() + height);
            child.setLeft(left);
            left += child.getWidth() + hInterval;
            int tmp = child.getType().locate(child, hInterval, vInterval);
            if (tmp <= max) continue;
            max = tmp;
        }
        children.addLast(join);
        join.setTop(group.getTop() + (height += max));
        int offset = (group.getWidth() - join.getWidth()) / 2;
        join.setLeft(group.getLeft() + offset);
        return height += join.getType().locate(join, hInterval, vInterval);
    }

    private static int vLocate(Block group, int hInterval, int vInterval, int height, LinkedList<Block> children) {
        for (Block child : children) {
            int offset = (group.getWidth() - child.getWidth()) / 2;
            child.setLeft(group.getLeft() + offset);
            child.setTop(group.getTop() + height);
            height += child.getType().locate(child, hInterval, vInterval);
        }
        return height;
    }

    private static void createLink2Parent(Block block) {
        if (block.getPriors() != null) {
            return;
        }
        Block parent = block.getParent();
        if (parent != null) {
            parent.addNext(block);
            block.addPrior(parent);
        }
    }

    private static void createJoin(Block block, LinkedList<Block> children) {
        Diagram graph = block.getGraph();
        Block join = new Block(graph, block);
        for (Block sibling : children) {
            sibling.addNext(join);
            join.addPrior(sibling);
        }
        children.addLast(join);
        graph.addBlock(join);
    }

    private static int mLayout(int hInterval, LinkedList<Block> children) {
        int width = 0;
        Block last = children.removeLast();
        width = Type.hLayout(hInterval, children);
        int tmp = last.getType().layout(last, hInterval);
        if (tmp > width) {
            width = tmp;
        }
        children.addLast(last);
        return width;
    }

    private static int vLayout(int hInterval, LinkedList<Block> children) {
        int width = 0;
        for (Block child : children) {
            int tmp = child.getType().layout(child, hInterval);
            if (tmp <= width) continue;
            width = tmp;
        }
        return width;
    }

    private static int hLayout(int hInterval, List<Block> children) {
        int width = 0;
        for (Block child : children) {
            if (width > 0) {
                width += hInterval;
            }
            width += child.getType().layout(child, hInterval);
        }
        return width;
    }
}

