/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ng.pubsub;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.Properties;
import org.apache.log4j.Logger;

public class EASEnvirInfo {
    private static EASEnvirInfo easEnvir;
    private static Logger logger;

    public static synchronized EASEnvirInfo getInstance() {
        if (easEnvir == null) {
            easEnvir = new EASEnvirInfo();
        }
        return easEnvir;
    }

    public String getEnvirInfo() {
        StringBuffer sb = new StringBuffer();
        Properties props = System.getProperties();
        String osName = props.getProperty("os.name");
        String osVersion = props.getProperty("os.version");
        String javaVersion = props.getProperty("java.version");
        String javaVendor = props.getProperty("java.vendor");
        try {
            sb.append("osn=").append(URLEncoder.encode(osName, "utf-8"));
            sb.append("&osv=").append(URLEncoder.encode(osVersion, "utf-8"));
            sb.append("&jv=").append(URLEncoder.encode(javaVersion, "utf-8"));
            sb.append("&jp=").append(URLEncoder.encode(javaVendor, "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"encode to utf-8 fail!", (Throwable)e);
        }
        return sb.toString();
    }

    public String getEASEnvirInfo() {
        String result = "bv=";
        try {
            Class<?> bosversionClass = EASEnvirInfo.class.getClassLoader().loadClass("com.kingdee.bos.BOSVersion");
            Method bosVersion = bosversionClass.getMethod("getBOSVersion", new Class[0]);
            Object resultObj = bosVersion.invoke(bosversionClass.newInstance(), new Object[0]);
            result = resultObj != null ? result + URLEncoder.encode(resultObj.toString(), "utf-8") : result + "n";
        }
        catch (Throwable t) {
            result = "bv=n";
        }
        return result;
    }

    static {
        logger = Logger.getLogger((Class)EASEnvirInfo.class);
    }
}

