/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.format;

import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.common.i18n.Messages;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DateFormater {
    public static final int DATE_PART_ALL = 0;
    public static final int DATE_PART_YEAR = 1;
    public static final int DATE_PART_QUARTER = 2;
    public static final int DATE_PART_MONTH = 4;
    public static final int DATE_PART_DAY = 8;
    private static final Map<Integer, String> KEY_MONTH = new HashMap<Integer, String>();
    private static final Map<Integer, String> KEY_WEEK = new HashMap<Integer, String>();
    private static final Map<Integer, String> KEY_AMPM = new HashMap<Integer, String>();
    private II18nContext _i18nCtx;
    private List<Word> _words;

    public DateFormater(II18nContext ctx) {
        this._i18nCtx = ctx;
    }

    public void setFormatString(String format) {
        this.parse(format);
    }

    public String format(Calendar value, int datePart) {
        StringBuilder result = new StringBuilder();
        this.format(value, datePart, result);
        return result.toString();
    }

    public String format(Calendar value) {
        return this.format(value, 0);
    }

    private void parse(String format) {
        this._words = new ArrayList<Word>();
        char lastChar = '\u0000';
        StringBuilder lastWord = new StringBuilder();
        boolean isQuote = false;
        int c = format.length();
        for (int i = 0; i < c; ++i) {
            char chr = format.charAt(i);
            if (isQuote) {
                if (chr == '\'') {
                    isQuote = false;
                    this.acceptWord(lastWord, false);
                    continue;
                }
                lastWord.append(chr);
                continue;
            }
            if (chr == '\'' && format.indexOf(39, i + 1) >= 0) {
                isQuote = true;
                this.acceptWord(lastWord, true);
                lastChar = '\u0000';
                continue;
            }
            if (lastChar == '\u0000' || chr == lastChar) {
                lastWord.append(chr);
            } else {
                this.acceptWord(lastWord, true);
                lastWord.append(chr);
            }
            lastChar = chr;
        }
        this.acceptWord(lastWord, true);
    }

    private void acceptWord(StringBuilder lastWord, boolean maybeSign) {
        if (lastWord.length() > 0) {
            this._words.add(new Word(maybeSign, lastWord.toString()));
            lastWord.delete(0, lastWord.length());
        }
    }

    private char checkDatePart(char sign, int datePart) {
        if (datePart == 0 || (datePart & 1) == 1 && sign == 'y' || (datePart & 2) == 2 && sign == 'q' || (datePart & 4) == 4 && sign == 'M' || (datePart & 8) == 8 && sign == 'd') {
            return sign;
        }
        return '\u0000';
    }

    private void format(Calendar value, int datePart, StringBuilder result) {
        int c = this._words.size();
        block12: for (int i = 0; i < c; ++i) {
            Word word = this._words.get(i);
            String text = word.getText();
            int wordLength = text.length();
            char sign = this.checkDatePart(word.getSign(), datePart);
            switch (sign) {
                case 'y': {
                    this.formatYear(value, wordLength, result);
                    continue block12;
                }
                case 'q': {
                    this.formatQuarter(value, result);
                    continue block12;
                }
                case 'M': {
                    this.formatMonth(value, wordLength, result);
                    continue block12;
                }
                case 'd': {
                    this.formatDay(value, wordLength, result);
                    continue block12;
                }
                case 'H': {
                    this.formatHour(value, wordLength, result);
                    continue block12;
                }
                case 'm': {
                    this.formatMinute(value, wordLength, result);
                    continue block12;
                }
                case 's': {
                    this.formatSecond(value, wordLength, result);
                    continue block12;
                }
                case 'a': {
                    this.formatAmPmMarker(value, result);
                    continue block12;
                }
                case 'h': {
                    this.formatHourInAmPm(value, wordLength, result);
                    continue block12;
                }
                case 'E': {
                    this.formatDayNameInWeek(value, wordLength, result);
                    continue block12;
                }
                default: {
                    result.append(text);
                }
            }
        }
    }

    private String getLocalDisplay(String key) {
        return Messages.getMLS(this._i18nCtx, key, key, Messages.ProjectName.QING_COMMON);
    }

    private boolean fillFrontZero(StringBuilder outputTarget, String text, int expectLength) {
        int realLength = text.length();
        if (realLength < expectLength) {
            int zeroCount = expectLength - realLength;
            for (int i = 0; i < zeroCount; ++i) {
                outputTarget.append('0');
            }
            return true;
        }
        return false;
    }

    private void fillEnoughDigit(StringBuilder outputTarget, int target, int expectLength) {
        String text = Integer.toString(target);
        this.fillFrontZero(outputTarget, text, expectLength);
        outputTarget.append(text);
    }

    private void cut(StringBuilder outputTarget, String text, int expectLength, boolean keepFront) {
        int realLength = text.length();
        if (realLength > expectLength) {
            text = keepFront ? text.substring(0, expectLength) : text.substring(realLength - expectLength);
        }
        outputTarget.append(text);
    }

    private void formatYear(Calendar value, int wordLength, StringBuilder result) {
        String year = Integer.toString(value.get(1));
        if (this.fillFrontZero(result, year, wordLength)) {
            result.append(year);
        } else {
            this.cut(result, year, wordLength, false);
        }
    }

    private void formatQuarter(Calendar value, StringBuilder result) {
        int month = value.get(2);
        int quarter = month / 3 + 1;
        result.append(Integer.toString(quarter));
    }

    private void formatMonth(Calendar value, int wordLength, StringBuilder result) {
        int month = value.get(2);
        if (wordLength > 2) {
            String key = KEY_MONTH.get(month);
            String localMonth = this.getLocalDisplay(key);
            if (wordLength == 3) {
                this.cut(result, localMonth, 3, true);
            } else {
                result.append(localMonth);
            }
        } else {
            this.fillEnoughDigit(result, month + 1, wordLength);
        }
    }

    private void formatDay(Calendar value, int wordLength, StringBuilder result) {
        int day = value.get(5);
        this.fillEnoughDigit(result, day, wordLength);
    }

    private void formatHour(Calendar value, int wordLength, StringBuilder result) {
        int hour = value.get(11);
        this.fillEnoughDigit(result, hour, wordLength);
    }

    private void formatMinute(Calendar value, int wordLength, StringBuilder result) {
        int minute = value.get(12);
        this.fillEnoughDigit(result, minute, wordLength);
    }

    private void formatSecond(Calendar value, int wordLength, StringBuilder result) {
        int second = value.get(13);
        this.fillEnoughDigit(result, second, wordLength);
    }

    private void formatAmPmMarker(Calendar value, StringBuilder result) {
        int ampm = value.get(9);
        String key = KEY_AMPM.get(ampm);
        String localAmPm = this.getLocalDisplay(key);
        result.append(localAmPm);
    }

    private void formatHourInAmPm(Calendar value, int wordLength, StringBuilder result) {
        int hour = value.get(10);
        hour = hour == 0 ? 12 : hour;
        this.fillEnoughDigit(result, hour, wordLength);
    }

    private void formatDayNameInWeek(Calendar value, int wordLength, StringBuilder result) {
        int dayInWeek = value.get(7);
        String key = KEY_WEEK.get(dayInWeek);
        String localDayInWeek = this.getLocalDisplay(key);
        if (wordLength < 4) {
            this.cut(result, localDayInWeek, 3, true);
        } else {
            result.append(localDayInWeek);
        }
    }

    static {
        KEY_MONTH.put(0, "january");
        KEY_MONTH.put(1, "february");
        KEY_MONTH.put(2, "march");
        KEY_MONTH.put(3, "april");
        KEY_MONTH.put(4, "may");
        KEY_MONTH.put(5, "june");
        KEY_MONTH.put(6, "july");
        KEY_MONTH.put(7, "august");
        KEY_MONTH.put(8, "september");
        KEY_MONTH.put(9, "october");
        KEY_MONTH.put(10, "november");
        KEY_MONTH.put(11, "december");
        KEY_WEEK.put(1, "sunday");
        KEY_WEEK.put(2, "monday");
        KEY_WEEK.put(3, "tuesday");
        KEY_WEEK.put(4, "wednesday");
        KEY_WEEK.put(5, "thursday");
        KEY_WEEK.put(6, "friday");
        KEY_WEEK.put(7, "saturday");
        KEY_AMPM.put(0, "am");
        KEY_AMPM.put(1, "pm");
    }

    private static class Word {
        private boolean _maybeSign;
        private String _text;

        public Word(boolean maybeSign, String text) {
            this._maybeSign = maybeSign;
            this._text = text;
        }

        public char getSign() {
            return this._maybeSign ? this._text.charAt(0) : (char)'\u0000';
        }

        public String getText() {
            return this._text;
        }
    }
}

