/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.framework.model;

import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.ZipUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public abstract class AbstractMessage {
    protected String messageType;

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public String toJson() {
        return JsonUtil.encodeToString(this);
    }

    public byte[] toBytes() {
        try {
            return this.toJson().getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            LogUtil.error(e.getMessage(), e);
            return null;
        }
    }

    public String encode() {
        try {
            return AbstractMessage.encode(this.toJson());
        }
        catch (IOException e) {
            LogUtil.error(e.getMessage(), e);
            return null;
        }
    }

    public boolean isClientMessage() {
        return false;
    }

    public boolean isClientPingMessage() {
        return false;
    }

    public boolean isClientReomteCallMessage() {
        return false;
    }

    private static String encode(String message) throws IOException {
        return StringUtils.encodeToBase64String(ZipUtil.gzip(URLEncoder.encode(message, "utf-8").replace("+", "%20")));
    }
}

