/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.framework.server.task;

import com.kingdee.bos.qing.common.framework.server.task.ServerRequestInvokeContext;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class InvokeHealthCheckTask {
    private static ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(2);
    private static BlockingDeque<ServerRequestInvokeContext> invokeContexts = new LinkedBlockingDeque<ServerRequestInvokeContext>();
    private static long ttlIntervalMillis = TimeUnit.SECONDS.toMillis(3L);

    private InvokeHealthCheckTask() {
    }

    public static void stop() {
        scheduler.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void activeCallWorkingInServer() {
        if (!invokeContexts.isEmpty()) {
            Iterator<ServerRequestInvokeContext> iterator = invokeContexts.iterator();
            while (iterator.hasNext()) {
                ServerRequestInvokeContext invokeContext;
                ServerRequestInvokeContext serverRequestInvokeContext = invokeContext = iterator.next();
                synchronized (serverRequestInvokeContext) {
                    if (!invokeContext.isStopHealthCheck()) {
                        invokeContext.setCallWorkingInServer();
                        invokeContext.refreshRelativeClients();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkInterrupt() {
        if (!invokeContexts.isEmpty()) {
            Iterator<ServerRequestInvokeContext> iterator = invokeContexts.iterator();
            HashMap<String, Boolean> clientsClosed = new HashMap<String, Boolean>();
            HashMap<String, Boolean> callsCanceled = new HashMap<String, Boolean>();
            while (iterator.hasNext()) {
                ServerRequestInvokeContext invokeContext;
                ServerRequestInvokeContext serverRequestInvokeContext = invokeContext = iterator.next();
                synchronized (serverRequestInvokeContext) {
                    if (invokeContext.isStopHealthCheck()) {
                        LogUtil.info("health check is stopped:clientId=" + invokeContext.getClientID() + ",callId=" + invokeContext.getCallID());
                        iterator.remove();
                        invokeContext.stopHealthCheck();
                        invokeContext.clearCallWorkingStatus();
                        invokeContext.clearCallStopWoringStatus();
                    } else if (invokeContext.isClientClosedOrCallCancel(clientsClosed, callsCanceled)) {
                        LogUtil.info("ClientClosedOrCallCancel:clientId=" + invokeContext.getClientID() + ",callId=" + invokeContext.getCallID());
                        iterator.remove();
                        invokeContext.stopHealthCheck();
                        invokeContext.clearCallWorkingStatus();
                        invokeContext.clearCallStopWoringStatus();
                    } else if (invokeContext.isCallStopWorkingStatus()) {
                        LogUtil.info("CallStopWorkingStatus:clientId=" + invokeContext.getClientID() + ",callId=" + invokeContext.getCallID());
                        iterator.remove();
                        invokeContext.stopHealthCheck();
                        invokeContext.clearCallWorkingStatus();
                        invokeContext.clearCallStopWoringStatus();
                    } else if (invokeContext.isReqMigrated()) {
                        LogUtil.info("invokeContext is migrated to remote server,:clientId=" + invokeContext.getClientID() + ",callId=" + invokeContext.getCallID());
                        iterator.remove();
                    }
                }
            }
        }
    }

    public static void addInvokeContext(ServerRequestInvokeContext invokeContext) {
        invokeContext.setCallWorkingInServer();
        invokeContexts.offer(invokeContext);
    }

    static {
        Runnable checkInterruptTask = new Runnable(){

            @Override
            public void run() {
                try {
                    InvokeHealthCheckTask.checkInterrupt();
                }
                catch (Exception e) {
                    LogUtil.error(e.getMessage(), e);
                }
            }
        };
        scheduler.scheduleAtFixedRate(checkInterruptTask, ttlIntervalMillis, ttlIntervalMillis, TimeUnit.MILLISECONDS);
        Runnable activeCallWorkingInServerTask = new Runnable(){

            @Override
            public void run() {
                try {
                    InvokeHealthCheckTask.activeCallWorkingInServer();
                }
                catch (Exception e) {
                    LogUtil.error(e.getMessage(), e);
                }
            }
        };
        scheduler.scheduleAtFixedRate(activeCallWorkingInServerTask, ttlIntervalMillis, ttlIntervalMillis, TimeUnit.MILLISECONDS);
    }
}

