/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.grammar.expr;

import com.kingdee.bos.qing.common.grammar.IExecuteContext;
import com.kingdee.bos.qing.common.grammar.exception.ExecuteException;
import com.kingdee.bos.qing.common.grammar.exception.ParserException;
import com.kingdee.bos.qing.common.grammar.expr.AbstractExpr;
import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import java.math.BigDecimal;

public abstract class AbstractOpExpr
extends AbstractExpr {
    private IExpr[] _subExprs;
    private int _priority;

    public AbstractOpExpr() {
    }

    public AbstractOpExpr(IExpr[] subExprs) throws ParserException {
        this.initInstanceFromSubExprs(subExprs);
    }

    protected final void initInstanceFromSubExprs(IExpr[] subExprs) throws ParserException {
        this.checkSubExprsDataType(subExprs);
        this._subExprs = subExprs;
    }

    protected abstract void checkSubExprsDataType(IExpr[] var1) throws ParserException;

    protected final void checkSubExprsCommonImpl(IExpr[] subExprs, int[] subExprDataTypeLimit) throws ParserException {
        if (subExprDataTypeLimit.length != subExprs.length) {
            throw AbstractOpExpr.exUnmatchedParamCount(this);
        }
        this.innerCheckSubExprs(subExprs, subExprDataTypeLimit);
    }

    protected final void checkSubExprsCommonImpl(IExpr[] subExprs, int[] subExprDataTypeLimit1, int[] subExprDataTypeLimit2) throws ParserException {
        if (subExprDataTypeLimit1.length == subExprs.length) {
            this.innerCheckSubExprs(subExprs, subExprDataTypeLimit1);
        } else if (subExprDataTypeLimit2.length == subExprs.length) {
            this.innerCheckSubExprs(subExprs, subExprDataTypeLimit2);
        } else {
            throw AbstractOpExpr.exUnmatchedParamCount(this);
        }
    }

    protected final void checkSubExprsStrictlyMatch(IExpr[] subExprs, int[] ... subExprDataTypeLimitArray) throws ParserException {
        boolean isAnyLimitationMatch = false;
        boolean numberMatched = false;
        for (int[] subExprDataTypeLimit : subExprDataTypeLimitArray) {
            if (subExprs.length != subExprDataTypeLimit.length) continue;
            isAnyLimitationMatch |= this.doCheckSubExprsStrictlyMatch(subExprs, subExprDataTypeLimit);
            numberMatched = true;
        }
        if (!numberMatched) {
            throw AbstractOpExpr.exUnmatchedParamCount(this);
        }
        if (!isAnyLimitationMatch) {
            throw AbstractOpExpr.exUnmatchedDataType(this);
        }
    }

    private boolean doCheckSubExprsStrictlyMatch(IExpr[] subExprs, int[] subExprDataTypeLimit) throws ParserException {
        if (subExprDataTypeLimit.length == subExprs.length) {
            for (int i = 0; i < subExprs.length; ++i) {
                int expectType = subExprDataTypeLimit[i];
                IExpr subExpr = subExprs[i];
                if (AbstractOpExpr.isDataTypeCompatible(expectType, subExpr.getReturnDataType())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void innerCheckSubExprs(IExpr[] subExprs, int[] subExprDataTypeLimit) throws ParserException {
        for (int i = 0; i < subExprDataTypeLimit.length; ++i) {
            if (AbstractOpExpr.isDataTypeCompatible(subExprDataTypeLimit[i], subExprs[i].getReturnDataType())) continue;
            throw AbstractOpExpr.exUnmatchedDataType(subExprs[i]);
        }
    }

    protected static ParserException exUnmatchedDataType(IExpr expr) {
        return new ParserException(14, expr.getCharIndexAtFormula());
    }

    protected static ParserException exUnmatchedParamCount(IExpr expr) {
        return new ParserException(15, expr.getCharIndexAtFormula());
    }

    protected static ParserException exInconsistentDataType(IExpr expr) {
        return new ParserException(16, expr.getCharIndexAtFormula());
    }

    public final IExpr[] getSubExprs() {
        return this._subExprs;
    }

    protected final void setPriority(int priority) {
        this._priority = priority;
    }

    @Override
    public final int getPriority() {
        return this._priority;
    }

    protected final boolean isEquals(AbstractOpExpr another) {
        if (this._priority != another._priority || this._subExprs.length != another._subExprs.length) {
            return false;
        }
        for (int i = 0; i < this._subExprs.length; ++i) {
            if (this._subExprs[i].equals(another._subExprs[i])) continue;
            return false;
        }
        return true;
    }

    protected static BigDecimal getNumber(IExpr expr, IExecuteContext ctx) throws ExecuteException {
        Object value = expr.execute(ctx);
        return AbstractOpExpr.convertToNumber(value, expr);
    }

    protected static BigDecimal getNullableNumber(IExpr expr, IExecuteContext ctx) throws ExecuteException {
        Object value = expr.execute(ctx);
        return value == null ? null : AbstractOpExpr.convertToNumber(value, expr);
    }

    protected static BigDecimal divide(BigDecimal left, BigDecimal right) {
        int scale = Math.min(15, Math.max(8, left.scale() + right.scale()));
        return left.divide(right, scale, 4);
    }
}

