/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.grammar.expr;

import com.kingdee.bos.qing.common.grammar.IExecuteContext;
import com.kingdee.bos.qing.common.grammar.exception.ExecuteException;
import com.kingdee.bos.qing.common.grammar.exception.ParserException;
import com.kingdee.bos.qing.common.grammar.expr.AbstractOpExpr;
import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import java.math.BigDecimal;

public class NegativeExpr
extends AbstractOpExpr {
    public NegativeExpr(IExpr expr) throws ParserException {
        super(new IExpr[]{expr});
        this.setPriority(30);
    }

    private IExpr getExpr() {
        return this.getSubExprs()[0];
    }

    @Override
    public String encode() {
        return "-" + this.getExpr().encode();
    }

    @Override
    protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
        this.checkSubExprsCommonImpl(subExprs, new int[]{2});
    }

    @Override
    public int getReturnDataType() {
        return 2;
    }

    @Override
    public Object execute(IExecuteContext ctx) throws ExecuteException {
        BigDecimal value = NegativeExpr.getNumber(this.getExpr(), ctx);
        return BigDecimal.ZERO.subtract(value);
    }

    public boolean equals(Object obj) {
        if (obj instanceof NegativeExpr) {
            NegativeExpr another = (NegativeExpr)obj;
            return this.isEquals(another);
        }
        return false;
    }
}

