/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.grammar.funcimpl;

import com.kingdee.bos.qing.common.format.Formater;
import com.kingdee.bos.qing.common.grammar.IExecuteContext;
import com.kingdee.bos.qing.common.grammar.exception.ExecuteException;
import com.kingdee.bos.qing.common.grammar.exception.ParserException;
import com.kingdee.bos.qing.common.grammar.expr.AbstractFunctionExpr;
import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TypeConvertFunctions {

    public static class FORMAT
    extends AbstractFunctionExpr {
        public FORMAT() {
            super("FORMAT");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsCommonImpl(subExprs, new int[]{0, 1});
        }

        @Override
        public int getReturnDataType() {
            return 1;
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            Object value = this.getParams()[0].execute(ctx);
            if (value == null) {
                return null;
            }
            String formatString = this.getStringValue(this.getParams()[1], ctx);
            try {
                Formater formater = new Formater();
                formater.setI18nContext(ctx.getI18nContext());
                formater.setFormatString(formatString);
                return formater.format(value);
            }
            catch (IllegalArgumentException ex) {
                return ex.getMessage();
            }
        }
    }

    public static class TONUMBER
    extends AbstractFunctionExpr {
        private static final int[] PARAMS_STRING = new int[]{1};
        private static final int[] PARAMS_DATE = new int[]{4};
        private static final int[] PARAMS_TIME = new int[]{5};
        private static final int[] PARAMS_DATETIME = new int[]{3};

        public TONUMBER() {
            super("TONUMBER");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, PARAMS_STRING, PARAMS_DATETIME, PARAMS_DATE, PARAMS_TIME);
        }

        @Override
        public int getReturnDataType() {
            return 2;
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            try {
                return TONUMBER.getNullableNumber(this.getSubExprs()[0], ctx);
            }
            catch (ExecuteException ex) {
                if (ex.getType() == 19) {
                    return null;
                }
                throw ex;
            }
        }
    }

    public static class TODATE
    extends AbstractFunctionExpr {
        private static final int[] PARAMS_STRING = new int[]{1};
        private static final int[] PARAMS_NUMBER = new int[]{2};
        private static Pattern datePartFormat = Pattern.compile("(\\d{4})[-/]{1}(\\d{1,2})[-/]{1}(\\d{1,2})((\\s{1})(\\d{1,2}):(\\d{1,2})(:(\\d{1,2}))?)?");

        public TODATE() {
            super("TODATE");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, PARAMS_STRING, PARAMS_NUMBER);
        }

        @Override
        public int getReturnDataType() {
            return 4;
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            IExpr expr = this.getSubExprs()[0];
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            switch (expr.getReturnDataType()) {
                case 2: {
                    BigDecimal value = TODATE.toNumber(expr, ctx);
                    if (value == null) {
                        return null;
                    }
                    Double millis = (value.doubleValue() - 1.0) * 8.64E7 + -2.2090176E12;
                    calendar.setTimeInMillis(millis.longValue());
                    return calendar;
                }
                case 1: {
                    String input = this.getNullableStringValue(expr, ctx);
                    if (input == null) {
                        return null;
                    }
                    Matcher matcher = datePartFormat.matcher(input);
                    if (matcher.matches()) {
                        int year = Integer.parseInt(matcher.group(1));
                        int month = Integer.parseInt(matcher.group(2));
                        int date = Integer.parseInt(matcher.group(3));
                        int hour = matcher.group(6) == null ? 0 : Integer.parseInt(matcher.group(6));
                        int minute = matcher.group(7) == null ? 0 : Integer.parseInt(matcher.group(7));
                        int second = matcher.group(9) == null ? 0 : Integer.parseInt(matcher.group(9));
                        calendar.set(year, month - 1, date, hour, minute, second);
                        return calendar;
                    }
                    return null;
                }
                case 3: 
                case 4: {
                    return expr.execute(ctx);
                }
            }
            return null;
        }

        private static BigDecimal toNumber(IExpr expr, IExecuteContext ctx) throws ExecuteException {
            try {
                return TODATE.getNullableNumber(expr, ctx);
            }
            catch (ExecuteException ex) {
                if (ex.getType() == 19) {
                    return null;
                }
                throw ex;
            }
        }
    }

    public static class TOSTRING
    extends AbstractFunctionExpr {
        public TOSTRING() {
            super("TOSTRING");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            if (subExprs.length != 1) {
                throw TOSTRING.exUnmatchedParamCount(this);
            }
        }

        @Override
        public int getReturnDataType() {
            return 1;
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            return this.getNullableStringValue(this.getSubExprs()[0], ctx);
        }
    }
}

