/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.grammar.funcimpl;

import com.kingdee.bos.qing.common.grammar.IExecuteContext;
import com.kingdee.bos.qing.common.grammar.exception.ExecuteException;
import com.kingdee.bos.qing.common.grammar.exception.ParserException;
import com.kingdee.bos.qing.common.grammar.expr.AbstractFunctionExpr;
import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import java.math.BigDecimal;
import java.util.Calendar;

public class WorkTimeFunctions {
    private static IWorkTimeCalculator _calculator;

    public static void hookWorkTimeCalculator(IWorkTimeCalculator impl) {
        _calculator = impl;
    }

    public static class WORKDAY
    extends AbstractWorkTimeFunction {
        public WORKDAY() {
            super("WORKDAY");
        }

        @Override
        protected BigDecimal exeImpl(Calendar fromTimestamp, Calendar toTimestamp, String orgNumber) {
            Integer days = _calculator.workDay(fromTimestamp, toTimestamp, orgNumber);
            return days == null ? null : new BigDecimal(days);
        }
    }

    public static class WORKHOUR
    extends AbstractWorkTimeFunction {
        public WORKHOUR() {
            super("WORKHOUR");
        }

        @Override
        protected BigDecimal exeImpl(Calendar fromTimestamp, Calendar toTimestamp, String orgNumber) {
            Double hours = _calculator.workHour(fromTimestamp, toTimestamp, orgNumber);
            return hours == null ? null : new BigDecimal(Double.toString(hours));
        }
    }

    private static abstract class AbstractWorkTimeFunction
    extends AbstractFunctionExpr {
        public AbstractWorkTimeFunction(String name) {
            super(name);
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] exprs) throws ParserException {
            this.checkSubExprsCommonImpl(exprs, new int[]{3, 3}, new int[]{3, 3, 1});
        }

        @Override
        public int getReturnDataType() {
            return 2;
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            IExpr[] params = this.getParams();
            Calendar t1 = this.getDateValue(params[0], ctx);
            Calendar t2 = this.getDateValue(params[1], ctx);
            if (t1 == null || t2 == null) {
                return null;
            }
            String orgNumber = null;
            if (params.length > 2) {
                orgNumber = this.getStringValue(params[2], ctx);
            }
            BigDecimal value = this.exeImpl(t1, t2, orgNumber);
            return value;
        }

        protected abstract BigDecimal exeImpl(Calendar var1, Calendar var2, String var3);
    }

    public static interface IWorkTimeCalculator {
        public Double workHour(Calendar var1, Calendar var2, String var3);

        public Integer workDay(Calendar var1, Calendar var2, String var3);
    }
}

