/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.network.blacklist;

import com.kingdee.bos.qing.common.network.blacklist.BlackIPV4Range;
import com.kingdee.bos.qing.common.network.blacklist.BlackItem;
import com.kingdee.bos.qing.common.network.blacklist.BlackItemType;
import com.kingdee.bos.qing.common.network.blacklist.SimpleBlackHost;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom2.Element;

public class IpBlackList {
    private Map<String, Set<BlackItem>> blackListItems = new HashMap<String, Set<BlackItem>>();
    private static final IpBlackList instance = new IpBlackList();

    private IpBlackList() {
        InputStream in = this.loadFromSystemProperty();
        if (null == in) {
            in = IpBlackList.class.getResourceAsStream("/qing-ip-blacklist.xml");
        }
        if (null == in) {
            in = this.loadFromFile();
        }
        if (null != in) {
            this.load(in);
        }
    }

    public static IpBlackList getInstance() {
        return instance;
    }

    private InputStream loadFromSystemProperty() {
        String blackListXmlStr = System.getProperty("qing.ip.blacklist");
        ByteArrayInputStream in = null;
        if (null != blackListXmlStr && !blackListXmlStr.trim().isEmpty()) {
            in = new ByteArrayInputStream(blackListXmlStr.getBytes());
        }
        return in;
    }

    private InputStream loadFromFile() {
        File brother;
        String filePath;
        File blacklistFile;
        String path = System.getProperty("bos.config");
        if (path != null && (blacklistFile = new File(filePath = (path = (brother = new File(path)).getParent()) + File.separator + "qing-ip-blacklist.xml")).exists()) {
            try {
                return new FileInputStream(blacklistFile);
            }
            catch (FileNotFoundException e) {
                LogUtil.error("file not found:" + filePath, e);
            }
        }
        return null;
    }

    public void load(InputStream inputStream) {
        try {
            Element root = XmlUtil.loadRootElement(inputStream);
            List sourceTypes = root.getChildren();
            for (Element element : sourceTypes) {
                Set<BlackItem> blackItems = this.readBlackItems(element);
                this.blackListItems.put(element.getName(), blackItems);
            }
        }
        catch (Exception e) {
            LogUtil.error("create black list error", e);
        }
    }

    private Set<BlackItem> readBlackItems(Element element) {
        if (null == element) {
            return new HashSet<BlackItem>();
        }
        List children = element.getChildren();
        HashSet<BlackItem> blackItems = new HashSet<BlackItem>();
        for (int index = 0; index < children.size(); ++index) {
            BlackItem blackItem = this.newBlackItem((Element)children.get(index));
            if (null == blackItem) continue;
            blackItems.add(blackItem);
        }
        return blackItems;
    }

    private BlackItem newBlackItem(Element blackItemEle) {
        String type = blackItemEle.getAttributeValue("type");
        BlackItemType itemType = BlackItemType.valueOf(type);
        BlackItem blackItem = null;
        if (null != itemType) {
            switch (itemType) {
                case IPV4: 
                case DNS: {
                    blackItem = new SimpleBlackHost();
                    break;
                }
                case IPV4_RANGE: {
                    blackItem = new BlackIPV4Range();
                    break;
                }
            }
            if (blackItem != null) {
                blackItem.fromElement(blackItemEle);
            }
        }
        return blackItem;
    }

    public boolean isInDbBlackList(String host) {
        return this.matchAddress("DB", host);
    }

    public boolean isInFileBlackList(String host) {
        return this.matchAddress("FILE", host);
    }

    private boolean matchAddress(String type, String host) {
        Set<BlackItem> blackItems = this.blackListItems.get(type);
        if (null == blackItems) {
            return false;
        }
        for (BlackItem blackItem : blackItems) {
            if (!blackItem.match(host)) continue;
            return true;
        }
        return false;
    }
}

