/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.session;

import com.kingdee.bos.qing.common.cache.ISessionCacheable;
import com.kingdee.bos.qing.common.session.IQingSession;

public abstract class AbstractQingSession
implements IQingSession {
    private static final String QING_SESSION_KEY_PREFIX = "";
    protected static final int DEFAULT_TIMEOUT = 3600;
    protected static final String LOGIN_KEY = "login";
    protected static final String LOGIN_VALUE = "true";
    private String sessionId = "";

    public AbstractQingSession(String sessionId) {
        if (sessionId != null) {
            this.sessionId = sessionId;
        }
    }

    @Override
    public final String getId() {
        return this.sessionId;
    }

    protected String getKey() {
        return QING_SESSION_KEY_PREFIX + this.sessionId;
    }

    @Override
    public final void login(String sessionId) {
        this.sessionId = sessionId;
        this.set(LOGIN_KEY, LOGIN_VALUE);
    }

    @Override
    public boolean checkLogin() {
        String value = this.get(LOGIN_KEY);
        return LOGIN_VALUE.equals(value);
    }

    @Override
    public final <T extends ISessionCacheable> void setCache(T cacheable) {
        this.set(cacheable.getCacheKey(), cacheable.toJson());
    }

    @Override
    public final <T extends ISessionCacheable> T getCache(String cacheKey, Class<T> class1) {
        ISessionCacheable t;
        try {
            t = (ISessionCacheable)class1.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return (T)t.fromJson(this.get(cacheKey));
    }
}

