/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.session;

import com.kingdee.bos.qing.common.cache.ISessionCacheable;
import com.kingdee.bos.qing.common.session.AbstractQingSession;
import com.kingdee.bos.qing.common.session.IGlobalQingSession;
import com.kingdee.bos.qing.common.session.IQingSession;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.common.strategy.IQingSessionFactoryStrategy;

public class QingSessionUtil {
    private static IGlobalQingSession globalQingSession;
    private static ThreadLocal<IQingSession> threadLocal;

    private static IQingSessionFactoryStrategy getSessionFactory() {
        IQingSessionFactoryStrategy sessionFactory = CustomStrategyRegistrar.getStrategy(IQingSessionFactoryStrategy.class);
        if (null == sessionFactory) {
            throw new RuntimeException("qing session factory impl is not configured");
        }
        return sessionFactory;
    }

    public static IQingSession getQingSession(String sessionId) {
        IQingSessionFactoryStrategy sessionFactory = QingSessionUtil.getSessionFactory();
        AbstractQingSession qingSession = sessionFactory.createSessionableCache(sessionId);
        QingSessionUtil.setQingSessionImpl(qingSession);
        return qingSession;
    }

    public static void setQingSessionImpl(IQingSession qingSession) {
        threadLocal.set(qingSession);
    }

    public static void clearQingSessionImpl() {
        threadLocal.remove();
    }

    public static IQingSession getQingSessionImpl() {
        return threadLocal.get();
    }

    public static IGlobalQingSession getGlobalQingSessionImpl() {
        if (globalQingSession == null) {
            IQingSessionFactoryStrategy sessionFactory = QingSessionUtil.getSessionFactory();
            globalQingSession = sessionFactory.createSessionlessCache();
        }
        return globalQingSession;
    }

    public static void set(String key, String value) {
        threadLocal.get().set(key, value);
    }

    public static String get(String key) {
        return threadLocal.get().get(key);
    }

    public static void setCache(ISessionCacheable cacheable) {
        threadLocal.get().setCache(cacheable);
    }

    public static <T extends ISessionCacheable> T getCache(String cacheKey, Class<T> class1) {
        return threadLocal.get().getCache(cacheKey, class1);
    }

    public static void remove(String key) {
        threadLocal.get().remove(key);
    }

    static {
        threadLocal = new ThreadLocal();
    }
}

