/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.session.impl;

import com.kingdee.bos.qing.common.session.AbstractGlobalQingSession;
import com.kingdee.bos.qing.common.session.impl.JVMMapCache;
import com.kingdee.bos.qing.common.session.impl.JVMQingSessionImpl;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class JVMGlobalQingSessionImpl
extends AbstractGlobalQingSession {
    private static long ttlIntervalMillis = TimeUnit.MINUTES.toMillis(1L);
    private static JVMMapCache sessionlessCache = new JVMMapCache();
    private static Runnable task;

    public static void stop() {
        JVMQingSessionImpl.scheduler.shutdown();
    }

    public static void start() {
        task = new CleanTask();
        JVMQingSessionImpl.scheduler.scheduleAtFixedRate(task, ttlIntervalMillis, ttlIntervalMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void set(String key, String value, int timeout, TimeUnit timeUnit) {
        sessionlessCache.set(key, value, timeout, timeUnit);
    }

    @Override
    public String hGet(String key, String subKey) {
        return sessionlessCache.get(key, subKey);
    }

    @Override
    public void hRemove(String key, String subKey) {
        sessionlessCache.remove(key, subKey);
    }

    @Override
    public void hSet(String key, String subKey, String value, int timeout, TimeUnit timeUnit) {
        sessionlessCache.set(key, subKey, value, timeout, timeUnit);
    }

    @Override
    public void expireAfter(String key, int paramInt, TimeUnit paramTimeUnit) {
        sessionlessCache.expireAfter(key, paramTimeUnit.toMillis(paramInt));
    }

    @Override
    public String get(String key) {
        return sessionlessCache.get(key);
    }

    @Override
    public byte[] getByteData(String key) {
        String value = sessionlessCache.get(key);
        return value.getBytes(Charset.forName("UTF-8"));
    }

    @Override
    public void setBytesData(String key, byte[] datas, int timeoutSecond) {
        sessionlessCache.set(key, new String(datas), timeoutSecond, TimeUnit.SECONDS);
    }

    @Override
    public void remove(String key) {
        sessionlessCache.remove(key);
    }

    @Override
    public void addToSet(String key, String[] values) {
        sessionlessCache.addToSet(key, values);
    }

    @Override
    public void addToSet(String key, String[] values, int timeout, TimeUnit timeUnit) {
        sessionlessCache.addToSet(key, values, timeout, timeUnit);
    }

    @Override
    public String[] getSetValues(String key) {
        return sessionlessCache.getSetValues(key);
    }

    @Override
    public void removeSetValue(String key, String[] valuesToRemove) {
        sessionlessCache.removeSetValues(key, valuesToRemove);
    }

    @Override
    public List<String> hKeys(String key) {
        return sessionlessCache.getSubKeys(key);
    }

    @Override
    public long incrBy(String key, int count) {
        return sessionlessCache.incrBy(key, count);
    }

    static {
        JVMGlobalQingSessionImpl.start();
    }

    private static class CleanTask
    implements Runnable {
        private CleanTask() {
        }

        @Override
        public void run() {
            sessionlessCache.cleanup();
        }
    }
}

