/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.thread;

import com.kingdee.bos.qing.common.thread.ListenableFutureCallback;
import com.kingdee.bos.qing.common.thread.ListenableFutureTask;
import com.kingdee.bos.qing.common.thread.StopPooledThreadException;
import com.kingdee.bos.qing.common.thread.TaskQueue;
import com.kingdee.bos.qing.common.thread.TaskThread;
import com.kingdee.bos.qing.common.thread.ThreadPoolExecuteListener;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ThreadPoolExecutor<T>
extends java.util.concurrent.ThreadPoolExecutor {
    private static final String threadPoolExecutor_queueFull = "Queue capacity is full";
    private final AtomicInteger submittedCount = new AtomicInteger(0);
    private final AtomicLong lastContextStoppedTime = new AtomicLong(0L);
    private final AtomicLong lastTimeThreadKilledItself = new AtomicLong(0L);
    private long threadRenewalDelay = 1000L;
    private ThreadPoolExecuteListener executeListener;
    private ListenableFutureCallback callback;

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
        this.prestartAllCoreThreads();
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        this.prestartAllCoreThreads();
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, new RejectHandler());
        this.prestartAllCoreThreads();
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, new RejectHandler());
        this.prestartAllCoreThreads();
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler, ListenableFutureCallback<T> callback) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        this.prestartAllCoreThreads();
        this.callback = callback;
    }

    public void setExecuteListener(ThreadPoolExecuteListener executeListener) {
        this.executeListener = executeListener;
    }

    public long getThreadRenewalDelay() {
        return this.threadRenewalDelay;
    }

    public void setThreadRenewalDelay(long threadRenewalDelay) {
        this.threadRenewalDelay = threadRenewalDelay;
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        this.submittedCount.decrementAndGet();
        if (null != this.executeListener) {
            this.executeListener.onFinished(r);
        }
        if (t == null) {
            this.stopCurrentThreadIfNeeded();
        }
    }

    protected void stopCurrentThreadIfNeeded() {
        long lastTime;
        if (this.currentThreadShouldBeStopped() && (lastTime = this.lastTimeThreadKilledItself.longValue()) + this.threadRenewalDelay < System.currentTimeMillis() && this.lastTimeThreadKilledItself.compareAndSet(lastTime, System.currentTimeMillis() + 1L)) {
            String msg = "Stopping thread [" + Thread.currentThread().getName() + "] to avoid potential memory leaks after a context was stopped.";
            throw new StopPooledThreadException(msg);
        }
    }

    protected boolean currentThreadShouldBeStopped() {
        TaskThread currentTaskThread;
        return this.threadRenewalDelay >= 0L && Thread.currentThread() instanceof TaskThread && (currentTaskThread = (TaskThread)Thread.currentThread()).getCreationTime() < this.lastContextStoppedTime.longValue();
    }

    public int getSubmittedCount() {
        return this.submittedCount.get();
    }

    @Override
    public void execute(Runnable command) {
        this.execute(command, 0L, TimeUnit.MILLISECONDS);
    }

    public void execute(Runnable command, long timeout, TimeUnit unit) {
        this.submittedCount.incrementAndGet();
        try {
            if (null != this.executeListener) {
                this.executeListener.onNewThreadSubmitted(command);
            }
            super.execute(command);
        }
        catch (RejectedExecutionException rx) {
            if (super.getQueue() instanceof TaskQueue) {
                TaskQueue queue = (TaskQueue)super.getQueue();
                try {
                    if (!queue.force(command, timeout, unit)) {
                        this.submittedCount.decrementAndGet();
                        if (null != this.executeListener) {
                            this.executeListener.onThreadRejected(command);
                        }
                        throw new RejectedExecutionException(threadPoolExecutor_queueFull);
                    }
                }
                catch (InterruptedException x) {
                    this.submittedCount.decrementAndGet();
                    if (null != this.executeListener) {
                        this.executeListener.onThreadRejected(command);
                    }
                    throw new RejectedExecutionException(x);
                }
            }
            this.submittedCount.decrementAndGet();
            if (null != this.executeListener) {
                this.executeListener.onThreadRejected(command);
            }
            throw rx;
        }
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        if (runnable instanceof ListenableFutureTask && this.callback != null) {
            return new ListenableFutureTask<T>(runnable, value, this.callback);
        }
        return super.newTaskFor(runnable, value);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        if (callable instanceof ListenableFutureTask && this.callback != null) {
            return new ListenableFutureTask<T>(callable, this.callback);
        }
        return super.newTaskFor(callable);
    }

    private static class RejectHandler
    implements RejectedExecutionHandler {
        private RejectHandler() {
        }

        @Override
        public void rejectedExecution(Runnable r, java.util.concurrent.ThreadPoolExecutor executor) {
            throw new RejectedExecutionException();
        }
    }
}

