/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.trace;

import com.kingdee.bos.qing.common.trace.TraceSpan;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class TracerUtil {
    private static ThreadLocal<List<TraceSpan>> rootTraceSpanTLs = new ThreadLocal();
    private static ThreadLocal<LinkedList<TraceSpan>> traceSpanTLs = new ThreadLocal();

    public static TraceSpan create(String description) {
        TraceSpan parent = TracerUtil.getCurrentTraceSpan();
        TraceSpan traceSpan = TraceSpan.createEmpty(description);
        if (parent != null) {
            parent.getChildren().add(traceSpan);
        } else {
            List<TraceSpan> rootTraceSpans = TracerUtil.getRootTraceSpans();
            rootTraceSpans.add(traceSpan);
        }
        LinkedList<TraceSpan> traceSpans = traceSpanTLs.get();
        if (traceSpans == null) {
            traceSpans = new LinkedList();
        }
        traceSpans.add(traceSpan);
        traceSpanTLs.set(traceSpans);
        return traceSpan;
    }

    public static TraceSpan getCurrentTraceSpan() {
        LinkedList<TraceSpan> traceSpans = traceSpanTLs.get();
        if (traceSpans == null || traceSpans.isEmpty()) {
            return null;
        }
        return traceSpans.getLast();
    }

    public static LinkedList<TraceSpan> getTraceSpans() {
        return traceSpanTLs.get();
    }

    public static void setTraceSpans(LinkedList<TraceSpan> traceSpans) {
        traceSpanTLs.set(traceSpans);
    }

    public static void removeTraceSpanTLs() {
        traceSpanTLs.remove();
    }

    public static void addToCurrentTraceSpanChildren(TraceSpan traceSpan) {
        TraceSpan currentTraceSpan = TracerUtil.getCurrentTraceSpan();
        if (currentTraceSpan != null) {
            currentTraceSpan.getChildren().add(traceSpan);
        }
    }

    public static void close(TraceSpan traceSpan) {
        if (traceSpan == null) {
            return;
        }
        traceSpan.close();
        TracerUtil.removeTraceSpanFromTL(traceSpan);
    }

    public static void close(TraceSpan traceSpan, long customCost) {
        if (traceSpan == null) {
            return;
        }
        traceSpan.close(customCost);
        TracerUtil.removeTraceSpanFromTL(traceSpan);
    }

    public static List<TraceSpan> getRootTraceSpans() {
        List<TraceSpan> rootTraceSpans = rootTraceSpanTLs.get();
        if (rootTraceSpans == null) {
            rootTraceSpans = new ArrayList<TraceSpan>();
            rootTraceSpanTLs.set(rootTraceSpans);
        }
        return rootTraceSpans;
    }

    private static void removeTraceSpanFromTL(TraceSpan traceSpan) {
        LinkedList<TraceSpan> traceSpans = traceSpanTLs.get();
        if (traceSpans == null || traceSpans.isEmpty()) {
            return;
        }
        traceSpans.remove(traceSpan);
        traceSpanTLs.set(traceSpans);
    }

    public static void clearCurrentThreadCache() {
        List<TraceSpan> rootTraceSpans = rootTraceSpanTLs.get();
        if (null != rootTraceSpans) {
            rootTraceSpans.clear();
        }
    }
}

