/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.exceptionlog.model;

import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.util.StackTraceUtil;
import java.sql.SQLException;

public abstract class AbstractExceptionLog {
    protected int errorCode = 0;
    protected String errorMessage;
    protected String errorStackTrace;

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorStackTrace() {
        return this.errorStackTrace;
    }

    public void setErrorStackTrace(String errorStackTrace) {
        this.errorStackTrace = errorStackTrace;
    }

    public void bindException(Throwable exception) {
        if (exception == null) {
            return;
        }
        if (exception instanceof AbstractQingException) {
            AbstractQingException qingException = (AbstractQingException)exception;
            this.errorCode = qingException.getErrorCode();
        } else if (exception instanceof SQLException) {
            SQLException qingException = (SQLException)exception;
            this.errorCode = qingException.getErrorCode();
        }
        this.errorMessage = exception.getMessage();
        this.errorStackTrace = StackTraceUtil.getStackTrace(exception);
    }
}

