/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.filesystem.manager;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.framework.manage.ClientClosedListenerAdapter;
import com.kingdee.bos.qing.common.framework.manage.ClientManager;
import com.kingdee.bos.qing.common.framework.server.task.ServerRequestInvokeContext;
import com.kingdee.bos.qing.common.session.IGlobalQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileUpdater;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.OneClientToMultiFileRelation;
import com.kingdee.bos.qing.filesystem.manager.model.OneFileToMultiClientIdRelation;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.SystemPropertyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class ClientAndTmpFileRelationManager
extends ClientClosedListenerAdapter {
    private static final IGlobalQingSession globalSession = QingSessionUtil.getGlobalQingSessionImpl();
    private static ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName("qing-temp-file-cleaner");
            return t;
        }
    });
    private static ThreadLocal<Boolean> ENABLE_FILE_AND_CLIENT_BIND = new ThreadLocal();
    private Map<String, OneClientToMultiFileRelation> oneClientToMultiFileRelationMap = new HashMap<String, OneClientToMultiFileRelation>(10);
    private Map<String, OneFileToMultiClientIdRelation> oneFileToMultiClientIdRelationMap = new HashMap<String, OneFileToMultiClientIdRelation>(10);
    private static final String CLIENT_TO_FILE_RELATION_KEY_PREFIX = "Qing-clientId-to-fileName-relation-";
    private static final String FILE_TO_CLIENT_RELATION_KEY_PREFIX = "Qing-fileName-to-clientId-relation-";
    private static final String FILE_TYPE_KEY_PREFIX = "Qing-fileType-";
    private static final String FILE_DELETE_LOCK_KEY_PREFIX = "Qing-delete-tmp-file-lock-";
    private static final String WRITING_FILENAME_SET_KEY = "qing-writing-filename-set";
    private LinkedBlockingQueue<String[]> clientIdToFileNameRelationUpdateQueue = new LinkedBlockingQueue();
    private LinkedBlockingQueue<FileClientUpdateEvent> fileNameToClientIdRelationUpdateQueue = new LinkedBlockingQueue();
    private final int ADD_OPERATION = 1;
    private final int DEL_OPERATION = -1;
    private static Set<Integer> SUPPORTED_FILE_TYPES = new HashSet<Integer>(5);
    private boolean openTmpFileCleaner = SystemPropertyUtil.getBoolean("qing.enable.tempfile.delete.onclientclose", false);
    private static final ClientAndTmpFileRelationManager instance = new ClientAndTmpFileRelationManager();

    private ClientAndTmpFileRelationManager() {
        if (this.openTmpFileCleaner) {
            Thread clientIdAndFileNameUpdateThread = new Thread(new ClientIdWithMultiFileNameRelationUpdater());
            clientIdAndFileNameUpdateThread.setName("QING-clientIdToFileNames-relation-update-thread");
            clientIdAndFileNameUpdateThread.start();
            Thread fileNameAndClientIdUpdateThread = new Thread(new FileNameWithMultiClientIdRelationUpdater());
            fileNameAndClientIdUpdateThread.setName("QING-fileNameToClientIds-relation-update-thread");
            fileNameAndClientIdUpdateThread.start();
            scheduler.scheduleAtFixedRate(new UnUsableFileCleaner(), 1000L, 10000L, TimeUnit.MILLISECONDS);
            scheduler.scheduleAtFixedRate(new ClosedClientStateChecker(), 1000L, 5L, TimeUnit.MINUTES);
            SUPPORTED_FILE_TYPES.add(QingTempFileType.TEMP_QS.getTypeIndex());
        }
    }

    public static void enableBind(boolean bind) {
        ENABLE_FILE_AND_CLIENT_BIND.set(bind ? Boolean.TRUE : null);
    }

    public static ClientAndTmpFileRelationManager getInstance() {
        return instance;
    }

    public void bindOnStartWrite(IQingFile qingFile) {
        AbstractQingFileType fileType = qingFile.getFileType();
        if (!this.needCacheRelation(fileType)) {
            return;
        }
        ServerRequestInvokeContext context = ServerRequestInvokeContext.get();
        if (null == context) {
            return;
        }
        Set<String> clientIds = context.getRelativeClientIDs();
        if (clientIds.isEmpty()) {
            return;
        }
        String fileName = qingFile.getName();
        for (String clientId : clientIds) {
            this.setClientIdFileNameRelation(fileType, fileName, clientId);
        }
        globalSession.addToSet(WRITING_FILENAME_SET_KEY, new String[]{fileName}, 24, TimeUnit.HOURS);
    }

    public void fileWriteFinish(IQingFile qingFile) {
        String fileName = qingFile.getName();
        globalSession.removeSetValue(WRITING_FILENAME_SET_KEY, new String[]{fileName});
    }

    private boolean isBindEnabledInCurrentThread() {
        Boolean enable = ENABLE_FILE_AND_CLIENT_BIND.get();
        return enable == null ? false : enable;
    }

    public void bindOnVisit(IQingFileVisitor visitor) {
        if (!this.isBindEnabledInCurrentThread()) {
            return;
        }
        AbstractQingFileType fileType = visitor.getFileType();
        if (!this.needCacheRelation(fileType)) {
            return;
        }
        ServerRequestInvokeContext context = ServerRequestInvokeContext.get();
        if (null == context) {
            return;
        }
        Set<String> clientIds = context.getRelativeClientIDs();
        if (clientIds.isEmpty()) {
            String clientId = context.getClientID();
            if (StringUtils.isBlank(clientId)) {
                return;
            }
            clientIds.add(clientId);
        }
        if (!visitor.exists()) {
            return;
        }
        for (String clientId : clientIds) {
            this.setClientIdFileNameRelation(fileType, visitor.getName(), clientId);
        }
    }

    private void setClientIdFileNameRelation(AbstractQingFileType fileType, String fileName, String clientId) {
        OneFileToMultiClientIdRelation oneFileToMultiClientRelation;
        OneClientToMultiFileRelation oneClientToMultiFileRelation = this.getOrCreateClientAndFileRelation(clientId);
        if (oneClientToMultiFileRelation.addIfNotExist(fileName)) {
            LogUtil.info("set clientId with filename relation,clientId:" + clientId + ",fileName:" + fileName);
            this.clientIdToFileNameRelationUpdateQueue.offer(new String[]{clientId, fileName, fileType.getSubFolder()});
        }
        if ((oneFileToMultiClientRelation = this.getOrCreateFileAndClientRelation(fileName, fileType)).addIfNotExist(clientId)) {
            this.fileNameToClientIdRelationUpdateQueue.offer(new FileClientUpdateEvent(fileName, clientId, 1));
        }
    }

    private boolean needCacheRelation(AbstractQingFileType fileType) {
        return this.openTmpFileCleaner && fileType.isTemp() && SUPPORTED_FILE_TYPES.contains(fileType.getTypeIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OneFileToMultiClientIdRelation getOrCreateFileAndClientRelation(String fileName, AbstractQingFileType fileType) {
        Map<String, OneFileToMultiClientIdRelation> map = this.oneFileToMultiClientIdRelationMap;
        synchronized (map) {
            OneFileToMultiClientIdRelation relation = this.oneFileToMultiClientIdRelationMap.get(fileName);
            if (relation == null) {
                relation = new OneFileToMultiClientIdRelation(fileName, fileType);
                this.oneFileToMultiClientIdRelationMap.put(fileName, relation);
            }
            return relation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OneClientToMultiFileRelation getOrCreateClientAndFileRelation(String clientId) {
        Map<String, OneClientToMultiFileRelation> map = this.oneClientToMultiFileRelationMap;
        synchronized (map) {
            OneClientToMultiFileRelation relation = this.oneClientToMultiFileRelationMap.get(clientId);
            if (null == relation) {
                relation = new OneClientToMultiFileRelation(clientId);
                this.oneClientToMultiFileRelationMap.put(clientId, relation);
            }
            return relation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeClientIdFromFileRelation(String clientId, String[] relatedFileNames) {
        if (null != relatedFileNames && relatedFileNames.length > 0) {
            LogUtil.info("client is closed,clientId:" + clientId + ",related fileNames:" + StringUtils.join(relatedFileNames, ','));
            ArrayList<OneFileToMultiClientIdRelation> relationList = new ArrayList<OneFileToMultiClientIdRelation>(3);
            Map<String, OneFileToMultiClientIdRelation> map = this.oneFileToMultiClientIdRelationMap;
            synchronized (map) {
                for (String fileName : relatedFileNames) {
                    OneFileToMultiClientIdRelation relation = this.oneFileToMultiClientIdRelationMap.get(fileName);
                    if (null != relation) {
                        relation.removeClientId(clientId);
                        relationList.add(relation);
                    }
                    this.fileNameToClientIdRelationUpdateQueue.offer(new FileClientUpdateEvent(fileName, clientId, -1));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onClientClosed(QingContext qingContext, String clientID) {
        String cacheKey = this.createClientIdCacheKey(clientID);
        String[] subFileNames = globalSession.getSetValues(cacheKey);
        globalSession.remove(cacheKey);
        Map<String, OneClientToMultiFileRelation> map = this.oneClientToMultiFileRelationMap;
        synchronized (map) {
            this.oneClientToMultiFileRelationMap.remove(clientID);
        }
        this.removeClientIdFromFileRelation(clientID, subFileNames);
    }

    @Override
    public String getListenerKey() {
        return ClientAndTmpFileRelationManager.class.getName();
    }

    private Set<String> getFileNamesWithNoRelatedClient(Set<String> fileNameSet) {
        HashSet<String> fileNameSetToDelete = new HashSet<String>(10);
        for (String fileName : fileNameSet) {
            String keyInRedis = this.createFileNameCacheKey(fileName);
            String[] clientIds = globalSession.getSetValues(keyInRedis);
            if (null == clientIds || clientIds.length == 0) {
                fileNameSetToDelete.add(fileName);
                continue;
            }
            globalSession.expireAfter(keyInRedis, 24, TimeUnit.HOURS);
        }
        return fileNameSetToDelete;
    }

    private String createClientIdCacheKey(String clientId) {
        return CLIENT_TO_FILE_RELATION_KEY_PREFIX + clientId;
    }

    private String createFileNameCacheKey(String fileName) {
        return FILE_TO_CLIENT_RELATION_KEY_PREFIX + fileName;
    }

    private String createFileTypeCacheKey(String fileName) {
        return FILE_TYPE_KEY_PREFIX + fileName;
    }

    private class UnUsableFileCleaner
    implements Runnable {
        private UnUsableFileCleaner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Set fileNameSet = null;
                Map map = ClientAndTmpFileRelationManager.this.oneFileToMultiClientIdRelationMap;
                synchronized (map) {
                    fileNameSet = ClientAndTmpFileRelationManager.this.oneFileToMultiClientIdRelationMap.keySet();
                }
                Set fileNameSetToDelete = ClientAndTmpFileRelationManager.this.getFileNamesWithNoRelatedClient(fileNameSet);
                this.removeWritingFiles(fileNameSetToDelete);
                if (fileNameSetToDelete.isEmpty()) {
                    return;
                }
                for (String fileNameToDelete : fileNameSetToDelete) {
                    String subFolder = globalSession.get(ClientAndTmpFileRelationManager.this.createFileTypeCacheKey(fileNameToDelete));
                    if (null == subFolder) continue;
                    QingTempFileType fileType = QingTempFileType.getInstanceBySubFolder(subFolder);
                    String lockKey = ClientAndTmpFileRelationManager.FILE_DELETE_LOCK_KEY_PREFIX + fileNameToDelete;
                    try {
                        IQingFileUpdater fileUpdater = FileFactory.newFileUpdater(null, fileType, fileNameToDelete);
                        long value = globalSession.incrBy(lockKey, 1);
                        if (value != 1L) continue;
                        LogUtil.info("delete temp qing file:" + fileNameToDelete + ",fileType:" + subFolder);
                        fileUpdater.delete();
                        globalSession.remove(ClientAndTmpFileRelationManager.this.createFileNameCacheKey(fileNameToDelete));
                        globalSession.remove(ClientAndTmpFileRelationManager.this.createFileTypeCacheKey(fileNameToDelete));
                    }
                    catch (Exception e) {
                        LogUtil.error("schedule to clear unusable tmp file error,fileName:" + fileNameToDelete, e);
                    }
                    finally {
                        globalSession.expireAfter(lockKey, 3, TimeUnit.MINUTES);
                    }
                }
                Map map2 = ClientAndTmpFileRelationManager.this.oneFileToMultiClientIdRelationMap;
                synchronized (map2) {
                    for (String fileName : fileNameSetToDelete) {
                        ClientAndTmpFileRelationManager.this.oneFileToMultiClientIdRelationMap.remove(fileName);
                    }
                }
            }
            catch (Exception e) {
                LogUtil.error("", e);
            }
        }

        private void removeWritingFiles(Set<String> fileNameSetToDelete) {
            String[] writingFiles = globalSession.getSetValues(ClientAndTmpFileRelationManager.WRITING_FILENAME_SET_KEY);
            if (null != writingFiles) {
                for (String writingFileName : writingFiles) {
                    fileNameSetToDelete.remove(writingFileName);
                }
            }
        }
    }

    private class ClosedClientStateChecker
    implements Runnable {
        private ClosedClientStateChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashSet relations = new HashSet();
            Map map = ClientAndTmpFileRelationManager.this.oneClientToMultiFileRelationMap;
            synchronized (map) {
                relations.addAll(ClientAndTmpFileRelationManager.this.oneClientToMultiFileRelationMap.values());
            }
            HashSet<String> closedClientIds = new HashSet<String>(4);
            for (OneClientToMultiFileRelation relation : relations) {
                String clientID = relation.getClientId();
                if (ClientManager.isClientClosed(clientID, true, null)) {
                    LogUtil.info("client is closed,clientId:" + clientID);
                    String cacheKey = ClientAndTmpFileRelationManager.this.createClientIdCacheKey(clientID);
                    String[] subFileNames = globalSession.getSetValues(cacheKey);
                    globalSession.remove(cacheKey);
                    ClientAndTmpFileRelationManager.this.removeClientIdFromFileRelation(clientID, subFileNames);
                    closedClientIds.add(clientID);
                    continue;
                }
                relation.touch();
            }
            Map map2 = ClientAndTmpFileRelationManager.this.oneClientToMultiFileRelationMap;
            synchronized (map2) {
                for (String clientId : closedClientIds) {
                    ClientAndTmpFileRelationManager.this.oneClientToMultiFileRelationMap.remove(clientId);
                }
            }
        }
    }

    private class FileClientUpdateEvent {
        private String fileName;
        private String clientId;
        private int opera;

        public FileClientUpdateEvent(String fileName, String clientId, int opera) {
            this.fileName = fileName;
            this.clientId = clientId;
            this.opera = opera;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public int getOpera() {
            return this.opera;
        }

        public void setOpera(int opera) {
            this.opera = opera;
        }
    }

    private class ClientIdWithMultiFileNameRelationUpdater
    implements Runnable {
        private ClientIdWithMultiFileNameRelationUpdater() {
        }

        @Override
        public void run() {
            while (true) {
                String fileName = null;
                try {
                    String[] clientAndFileNamePair = (String[])ClientAndTmpFileRelationManager.this.clientIdToFileNameRelationUpdateQueue.take();
                    String clientId = clientAndFileNamePair[0];
                    fileName = clientAndFileNamePair[1];
                    String subFolder = clientAndFileNamePair[2];
                    globalSession.addToSet(ClientAndTmpFileRelationManager.this.createClientIdCacheKey(clientId), new String[]{fileName}, 24, TimeUnit.HOURS);
                    globalSession.set(ClientAndTmpFileRelationManager.this.createFileTypeCacheKey(fileName), subFolder, 24, TimeUnit.HOURS);
                    continue;
                }
                catch (InterruptedException e) {
                }
                catch (Exception e) {
                    LogUtil.error("save clientId and fileName to global cache error, fileName:" + fileName, e);
                    continue;
                }
                break;
            }
        }
    }

    private class FileNameWithMultiClientIdRelationUpdater
    implements Runnable {
        private FileNameWithMultiClientIdRelationUpdater() {
        }

        @Override
        public void run() {
            while (true) {
                String fileName = null;
                try {
                    FileClientUpdateEvent event = (FileClientUpdateEvent)ClientAndTmpFileRelationManager.this.fileNameToClientIdRelationUpdateQueue.take();
                    fileName = event.getFileName();
                    switch (event.getOpera()) {
                        case 1: {
                            globalSession.addToSet(ClientAndTmpFileRelationManager.this.createFileNameCacheKey(fileName), new String[]{event.getClientId()}, 24, TimeUnit.HOURS);
                            LogUtil.info("add file with client id relation,fileName:" + fileName + ",clientId:" + event.getClientId());
                            break;
                        }
                        case -1: {
                            globalSession.removeSetValue(ClientAndTmpFileRelationManager.this.createFileNameCacheKey(fileName), new String[]{event.getClientId()});
                            LogUtil.info("remove file with client id relation,fileName:" + fileName + ",clientId:" + event.getClientId());
                        }
                    }
                    continue;
                }
                catch (InterruptedException e) {
                }
                catch (Exception e) {
                    LogUtil.error("save clientId and fileName to global cache error, fileName:" + fileName, e);
                    continue;
                }
                break;
            }
        }
    }
}

