/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.filesystem.manager.localimpl;

import com.kingdee.bos.qing.filesystem.manager.api.IFileResourceService;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileWriter;
import com.kingdee.bos.qing.filesystem.manager.model.QingFileResourceInfo;
import com.kingdee.bos.qing.filesystem.stream.QingOutputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class LocalQingFileWriter
implements IQingFileWriter {
    private IFileResourceService _resourceService;
    private File _file;
    private QingFileResourceInfo _fileResourceInfo;

    public LocalQingFileWriter(IFileResourceService resourceService, QingFileResourceInfo fileResourceInfo, String filePath) {
        this._file = new File(filePath);
        this._resourceService = resourceService;
        this._fileResourceInfo = fileResourceInfo;
    }

    @Override
    public QingOutputStream getOutputStream() throws IOException {
        File parentFile = this._file.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        if (this._file.exists()) {
            throw new IOException("Duplicate Key :" + this._file.getName());
        }
        return new QingOutputStream(this._resourceService, this._fileResourceInfo, new BufferedOutputStream(new FileOutputStream(this._file), 1024));
    }

    @Override
    public void close(Exception e) {
        if (e != null) {
            this._file.delete();
        }
    }
}

