/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.filesystem.manager.localimpl;

import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileUpdater;
import com.kingdee.bos.qing.filesystem.manager.localimpl.AbstractLocalQingFile;
import com.kingdee.bos.qing.filesystem.manager.localimpl.DirUtil;
import com.kingdee.bos.qing.filesystem.manager.localimpl.FileSysUtil;
import com.kingdee.bos.qing.filesystem.manager.localimpl.filter.FileOverdueFilter;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.util.IOUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.SystemPropertyUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class LocalTempQingFile
extends AbstractLocalQingFile {
    private static final String TEMPDIR = "QingTemp";
    private static ConcurrentHashMap<String, TTLEntry> cache = new ConcurrentHashMap();
    private static ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    public static final long ttlIntervalMillis = TimeUnit.HOURS.toMillis(SystemPropertyUtil.getLong("qing.localtempfile.ttl", 12L));

    public static void stop() {
        scheduler.shutdown();
    }

    private static void cleanup() {
        Iterator<Map.Entry<String, TTLEntry>> iterator = cache.entrySet().iterator();
        ArrayList<String> fileToRemove = new ArrayList<String>(cache.size());
        while (iterator.hasNext()) {
            Map.Entry<String, TTLEntry> entry = iterator.next();
            if (entry.getValue().isLive()) continue;
            iterator.remove();
            fileToRemove.add(entry.getKey());
        }
        for (String file : fileToRemove) {
            if (new File(file).delete()) continue;
            LogUtil.error("QingLocalTempFile remove file " + file + " failed!", null);
        }
    }

    public LocalTempQingFile(QingTempFileType fileType) {
        super(fileType);
        String fullPath = this.getFullPath();
        TTLEntry entry = new TTLEntry(ttlIntervalMillis);
        TTLEntry entry2 = cache.putIfAbsent(fullPath, entry);
        if (entry2 != null) {
            entry = entry2;
            entry.updateTTL(ttlIntervalMillis);
        }
    }

    private LocalTempQingFile(QingTempFileType fileType, String name) {
        super(fileType, name);
        String fullPath = this.getFullPath();
        TTLEntry entry = new TTLEntry(ttlIntervalMillis);
        TTLEntry entry2 = cache.putIfAbsent(fullPath, entry);
        if (entry2 != null) {
            entry = entry2;
            entry.updateTTL(ttlIntervalMillis);
        }
    }

    @Override
    public String getRootDir() {
        return TEMPDIR;
    }

    @Override
    protected boolean doDelete() {
        if (super.doDelete()) {
            cache.remove(this.getFullPath());
            return true;
        }
        return false;
    }

    @Override
    public IQingFileUpdater findFile(AbstractQingFileType fileType, String name) {
        return new LocalTempQingFile((QingTempFileType)fileType, name);
    }

    public static void addTempFileCache(String fullPath) {
        TTLEntry entry = new TTLEntry(ttlIntervalMillis);
        TTLEntry entry2 = cache.putIfAbsent(fullPath, entry);
        if (entry2 != null) {
            entry = entry2;
            entry.updateTTL(ttlIntervalMillis);
        }
    }

    @Override
    public void copyTo(IQingFile qingFile, boolean autoDeleteIfFailed) throws IOException {
        if (qingFile instanceof LocalTempQingFile) {
            LocalTempQingFile tempQingFile = (LocalTempQingFile)qingFile;
            try {
                IOUtil.copyFile(this.file, tempQingFile.file);
            }
            catch (IOException e) {
                if (autoDeleteIfFailed) {
                    tempQingFile.file.deleteOnExit();
                }
            }
        } else {
            super.copyTo(qingFile, autoDeleteIfFailed);
        }
    }

    static {
        Runnable cleanResidualTempTask = new Runnable(){

            @Override
            public void run() {
                File[] childDirs;
                String tempDirPath = FileSysUtil.getAbsoluteFilePath(File.separator + "QingStorage" + File.separator + LocalTempQingFile.TEMPDIR + File.separator);
                File tempDir = new File(tempDirPath);
                if (!tempDir.exists()) {
                    return;
                }
                for (File childDir : childDirs = tempDir.listFiles()) {
                    FileOverdueFilter filter = new FileOverdueFilter();
                    DirUtil.delOverdueFileAndCacheOthers(tempDirPath + childDir.getName(), filter);
                }
            }
        };
        scheduler.execute(cleanResidualTempTask);
        Runnable cleanupTask = new Runnable(){

            @Override
            public void run() {
                LocalTempQingFile.cleanup();
            }
        };
        scheduler.scheduleAtFixedRate(cleanupTask, ttlIntervalMillis, ttlIntervalMillis, TimeUnit.MILLISECONDS);
    }

    private static class TTLEntry {
        private long ttl;

        public TTLEntry(long ttl) {
            this.updateTTL(ttl);
        }

        public boolean isLive() {
            return this.ttl > System.currentTimeMillis();
        }

        public void updateTTL(long ttl) {
            this.ttl = System.currentTimeMillis() + ttl;
        }
    }
}

