/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.msgbus.dispatch;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.session.IQingSession;
import com.kingdee.bos.qing.common.session.QingSessionUtil;
import com.kingdee.bos.qing.msgbus.dispatch.MessageDispatchTask;
import com.kingdee.bos.qing.util.ThreadPoolManage;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class MessageDispatcher {
    private static ConcurrentHashMap<String, MessageDispatchTask> tasks = new ConcurrentHashMap();
    private static ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private QingContext qingContext;

    public MessageDispatcher(QingContext qingContext) {
        this.qingContext = qingContext;
    }

    public void dispatch(String msgPackId) {
        MessageDispatchTask task = this.getDispatchTask();
        task.addPackId(msgPackId);
        this.activateDispatchTask(task);
    }

    private MessageDispatchTask getDispatchTask() {
        MessageDispatchTask taskExists;
        String sessionId = this.qingContext.getSessionID();
        MessageDispatchTask task = tasks.get(sessionId);
        if (task == null && (taskExists = tasks.putIfAbsent(sessionId, task = new MessageDispatchTask(sessionId))) != null) {
            task = taskExists;
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateDispatchTask(MessageDispatchTask task) {
        MessageDispatchTask messageDispatchTask = task;
        synchronized (messageDispatchTask) {
            if (!task.isRunning() && !task.isSubmitted()) {
                ThreadPoolManage.submit(ThreadPoolManage.QingThreadPoolName.QING_SHORT_TIME_TASK_HANDLER, task);
                task.setSubmitted(true);
            }
        }
    }

    static {
        long interval = 30L;
        scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                Set entrySet = tasks.entrySet();
                HashSet<String> sessionToRemove = new HashSet<String>(10);
                for (Map.Entry entry : entrySet) {
                    String sessionId = (String)entry.getKey();
                    IQingSession session = QingSessionUtil.getQingSession(sessionId);
                    if (session != null && session.checkLogin()) continue;
                    sessionToRemove.add(sessionId);
                }
                for (String sessionId : sessionToRemove) {
                    tasks.remove(sessionId);
                }
            }
        }, interval, interval, TimeUnit.MINUTES);
    }
}

