/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.resource;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.resource.AbstractResourceManager;
import com.kingdee.bos.qing.util.LogUtil;
import java.lang.reflect.Constructor;

public class ResourceManagerFactory {
    private static Constructor<AbstractResourceManager> constructor = null;

    private static Constructor<AbstractResourceManager> getResourceManagerConstructor() {
        if (constructor != null) {
            return constructor;
        }
        Class<ResourceManagerFactory> clazz = ResourceManagerFactory.class;
        synchronized (ResourceManagerFactory.class) {
            if (constructor != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return constructor;
            }
            String specifiedClass = System.getProperty("qing.resource.manager.impl");
            if (specifiedClass != null && !"".equals(specifiedClass.trim())) {
                try {
                    Class<?> clazz2 = Class.forName(specifiedClass);
                    if (clazz2 != null) {
                        constructor = clazz2.getConstructor(QingContext.class);
                        if (LogUtil.isDebugEnabled()) {
                            LogUtil.debug("ResourceManager switch to " + clazz2.getName());
                        }
                        // ** MonitorExit[var0] (shouldn't be in output)
                        return constructor;
                    }
                    throw new IllegalArgumentException("Class " + specifiedClass + " cannot be loaded!");
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Class " + specifiedClass + " cannot be loaded!", e);
                }
            }
            throw new IllegalArgumentException("qing.resource.manager.impl should not be null!");
        }
    }

    public static AbstractResourceManager createResourceManager(QingContext qingContext) {
        AbstractResourceManager resourceManager;
        try {
            resourceManager = ResourceManagerFactory.getResourceManagerConstructor().newInstance(qingContext);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("qing.resource.manager.impl newInstance failed!", e);
        }
        return resourceManager;
    }
}

