/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.response;

import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.common.framework.server.task.DuplicatedWorkWaiting;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.response.AbstractResponseWrap;
import com.kingdee.bos.qing.response.IResponseStrategy;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StackTraceUtil;

public class ResponseErrorWrap
extends AbstractResponseWrap {
    private static final long serialVersionUID = 2453304714744782297L;
    private int errorCode;
    private String errorMessage;
    private String errorStackMessage;

    public ResponseErrorWrap(int errorCode, String errorMessage) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public ResponseErrorWrap(int errorCode, String errorMessage, Throwable exception) {
        AbstractQingException e = this.getAbstractQingException(exception);
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.handleDuplicatedWorkWaitAndStackTrace(exception);
        LogUtil.error(exception.getMessage(), exception);
    }

    public ResponseErrorWrap(String errorMessage, Throwable exception) {
        AbstractQingException e = this.getAbstractQingException(exception);
        this.errorCode = e.getErrorCode();
        this.errorMessage = errorMessage;
        this.handleDuplicatedWorkWaitAndStackTrace(exception);
        LogUtil.error(exception.getMessage(), exception);
    }

    public ResponseErrorWrap(Throwable exception) {
        AbstractQingException e = this.getAbstractQingException(exception);
        this.errorCode = e.getErrorCode();
        this.errorMessage = e.getMessage();
        this.handleDuplicatedWorkWaitAndStackTrace(exception);
        LogUtil.error(exception.getMessage(), exception);
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorStackMessage() {
        return this.errorStackMessage;
    }

    public void setErrorStackMessage(String errorStackMessage) {
        this.errorStackMessage = errorStackMessage;
    }

    private AbstractQingException getAbstractQingException(Throwable exception) {
        AbstractQingException e = null;
        e = !(exception instanceof AbstractQingException) ? new IntegratedRuntimeException(exception) : (AbstractQingException)exception;
        return e;
    }

    private void handleDuplicatedWorkWaitAndStackTrace(Throwable exception) {
        if (exception instanceof DuplicatedWorkWaiting) {
            throw (DuplicatedWorkWaiting)exception;
        }
        boolean isWrapStackTrace = true;
        IResponseStrategy responseStrategy = CustomStrategyRegistrar.getStrategy(IResponseStrategy.class);
        if (responseStrategy != null && !responseStrategy.isShowStackTrace()) {
            isWrapStackTrace = false;
        }
        if (isWrapStackTrace) {
            this.errorStackMessage = StackTraceUtil.getStackTrace(exception);
        }
    }
}

