/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.util;

import com.kingdee.bos.qing.util.CloseUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipSingleFile(String name, File source, File target, byte[] prebytes, byte[] postbytes) throws IOException {
        FileInputStream ins = null;
        try {
            ins = new FileInputStream(source);
            ZipUtil.zipSingleFile(name, (InputStream)ins, target, prebytes, postbytes);
        }
        catch (Throwable throwable) {
            CloseUtil.close(ins);
            throw throwable;
        }
        CloseUtil.close(ins);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipSingleFile(String name, InputStream source, File target, byte[] prebytes, byte[] postbytes) throws IOException {
        FileOutputStream outs = null;
        try {
            outs = new FileOutputStream(target);
            ZipUtil.zipSingleFile(name, source, outs, prebytes, postbytes);
        }
        catch (Throwable throwable) {
            CloseUtil.close(outs);
            throw throwable;
        }
        CloseUtil.close(outs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipSingleFile(String name, InputStream source, OutputStream target, byte[] prebytes, byte[] postbytes) throws IOException {
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(new BufferedOutputStream(target));
            ZipUtil.addEntry(name, source, zos, prebytes, postbytes);
        }
        catch (Throwable throwable) {
            CloseUtil.close(zos);
            throw throwable;
        }
        CloseUtil.close(zos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addEntry(String name, InputStream ins, ZipOutputStream zos, byte[] prebytes, byte[] postbytes) throws IOException {
        BufferedInputStream bis = null;
        try {
            byte[] buffer = new byte[10240];
            bis = new BufferedInputStream(ins, buffer.length);
            int length = 0;
            zos.putNextEntry(new ZipEntry(name));
            if (prebytes != null) {
                zos.write(prebytes);
            }
            while ((length = bis.read(buffer, 0, buffer.length)) != -1) {
                zos.write(buffer, 0, length);
            }
            if (postbytes != null) {
                zos.write(postbytes);
            }
            zos.closeEntry();
        }
        catch (Throwable throwable) {
            CloseUtil.close(bis);
            throw throwable;
        }
        CloseUtil.close(bis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] gzip(String json) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter writer = null;
        try {
            int start = 0;
            int end = 0;
            char[] b = new char[4096];
            writer = new OutputStreamWriter((OutputStream)new GZIPOutputStream(byteArrayOutputStream), Charset.forName("utf-8"));
            start = 0;
            while (start < json.length()) {
                end = Math.min(start + 4096, json.length());
                json.getChars(start, end, b, 0);
                int length = end - start;
                writer.write(b, 0, length);
                start = end;
            }
        }
        catch (Throwable throwable) {
            CloseUtil.close(writer);
            throw throwable;
        }
        CloseUtil.close(writer);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] gzip(byte[] jsonBytes) throws IOException {
        String json = "";
        if (jsonBytes != null) {
            json = new String(jsonBytes, "utf-8");
        }
        return ZipUtil.gzip(json);
    }

    public static String unGzipToStr(byte[] data) throws IOException {
        return new String(ZipUtil.unGzip(data), "utf-8");
    }

    public static byte[] unGzip(byte[] bytes) throws IOException {
        int n;
        if (!ZipUtil.isGzipCompressed(bytes)) {
            return bytes;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        GZIPInputStream ungzip = new GZIPInputStream(in);
        byte[] buffer = new byte[256];
        while ((n = ungzip.read(buffer)) >= 0) {
            out.write(buffer, 0, n);
        }
        return out.toByteArray();
    }

    public static boolean isGzipCompressed(byte[] bytes) {
        if (bytes == null || bytes.length < 2) {
            return false;
        }
        return bytes[0] == 31 && bytes[1] == -117;
    }
}

